/*
 * Decompiled with CFR 0.152.
 */
package fr.alphadesnoc.pixelmongocine.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import fr.alphadesnoc.pixelmongocine.CineMod;
import fr.alphadesnoc.pixelmongocine.utils.MemoryTracker;
import java.awt.Dimension;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import me.lib720.caprica.vlcj.player.base.State;
import me.srrapero720.watermedia.api.WaterMediaAPI;
import me.srrapero720.watermedia.api.image.ImageAPI;
import me.srrapero720.watermedia.api.image.ImageRenderer;
import me.srrapero720.watermedia.api.player.SyncVideoPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.loading.FMLLoader;
import org.lwjgl.opengl.GL11;

public final class VideoScreen
extends Screen {
    private static final DateFormat FORMAT = new SimpleDateFormat("HH:mm:ss");
    private final SyncVideoPlayer player;
    int tick = 0;
    int closingOnTick = -1;
    float fadeLevel = 0.0f;
    boolean started;
    boolean closing = false;
    boolean paused = false;
    float volume;
    int videoTexture = -1;

    public VideoScreen(String url, int volume) {
        super((ITextComponent)new StringTextComponent(""));
        Minecraft minecraft = Minecraft.func_71410_x();
        Minecraft.func_71410_x().func_147118_V().func_147689_b();
        this.volume = volume;
        this.player = new SyncVideoPlayer(null, (Executor)minecraft, MemoryTracker::create);
        this.player.setVolume((int)(Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MASTER) * (float)volume));
        String[] vlcArgs = new String[]{"--sout-video-bitrate=8000", "--network-caching=1000", "--avcodec-hw=any", "--video-filter=hqdn3d", "--deinterlace", "--auto-quality"};
        this.player.start((CharSequence)url, vlcArgs);
        this.started = true;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        ++this.tick;
    }

    public void func_230430_a_(MatrixStack stack, int pMouseX, int pMouseY, float pPartialTicks) {
        if (!this.started) {
            return;
        }
        this.videoTexture = this.player.prepareTexture();
        if ((this.player.isEnded() || this.player.isStopped() || this.player.getRawPlayerState().equals((Object)State.ERROR)) && (this.fadeLevel == 1.0f || this.closing)) {
            this.closing = true;
            if (this.closingOnTick == -1) {
                this.closingOnTick = this.tick + 20;
            }
            if (this.tick >= this.closingOnTick) {
                this.fadeLevel = Math.max(this.fadeLevel - pPartialTicks / 8.0f, 0.0f);
            }
            this.renderBlackBackground(stack);
            this.renderIcon(stack, ImageAPI.loadingGif());
            if (this.fadeLevel == 0.0f) {
                this.func_231164_f_();
            }
            return;
        }
        boolean playingState = !(!this.player.isPlaying() && !this.player.isPaused() || !this.player.getRawPlayerState().equals((Object)State.PLAYING) && !this.player.getRawPlayerState().equals((Object)State.PAUSED));
        float f = this.fadeLevel = playingState ? Math.max(this.fadeLevel - pPartialTicks / 8.0f, 0.0f) : Math.min(this.fadeLevel + pPartialTicks / 16.0f, 1.0f);
        if (playingState || this.player.isStopped() || this.player.isEnded()) {
            this.renderTexture(stack, this.videoTexture);
        }
        if (!this.paused) {
            this.renderBlackBackground(stack);
        }
        if (!this.player.isPlaying() || !this.player.getRawPlayerState().equals((Object)State.PLAYING)) {
            if (this.player.isPaused() && this.player.getRawPlayerState().equals((Object)State.PAUSED)) {
                this.renderIcon(stack, CineMod.pausedImage());
            } else {
                this.renderIcon(stack, ImageAPI.loadingGif());
            }
        }
        if (!FMLLoader.isProduction()) {
            this.draw(stack, String.format("State: %s", this.player.getRawPlayerState().name()), this.getHeightCenter(-12));
            this.draw(stack, String.format("Time: %s (%s) / %s (%s)", FORMAT.format(new Date(this.player.getTime())), this.player.getTime(), FORMAT.format(new Date(this.player.getDuration())), this.player.getDuration()), this.getHeightCenter(0));
            this.draw(stack, String.format("Media Duration: %s (%s)", FORMAT.format(new Date(this.player.getMediaInfoDuration())), this.player.getMediaInfoDuration()), this.getHeightCenter(12));
        }
    }

    private void renderBlackBackground(MatrixStack stack) {
        RenderSystem.enableBlend();
        VideoScreen.func_238467_a_((MatrixStack)stack, (int)0, (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)WaterMediaAPI.math_colorARGB((int)((int)(this.fadeLevel * 255.0f)), (int)0, (int)0, (int)0));
        RenderSystem.disableBlend();
    }

    private void renderTexture(MatrixStack stack, int texture) {
        int renderHeight;
        int renderWidth;
        if (this.player.getDimensions() == null) {
            return;
        }
        RenderSystem.enableBlend();
        VideoScreen.func_238467_a_((MatrixStack)stack, (int)0, (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)WaterMediaAPI.math_colorARGB((int)255, (int)0, (int)0, (int)0));
        RenderSystem.disableBlend();
        RenderSystem.bindTexture((int)texture);
        Dimension videoDimensions = this.player.getDimensions();
        double videoWidth = videoDimensions.getWidth();
        double videoHeight = videoDimensions.getHeight();
        float screenAspectRatio = (float)this.field_230708_k_ / (float)this.field_230709_l_;
        float videoAspectRatio = (float)((double)((float)videoWidth) / videoHeight);
        if (videoAspectRatio > screenAspectRatio) {
            renderWidth = this.field_230708_k_;
            renderHeight = (int)((float)this.field_230708_k_ / videoAspectRatio);
        } else {
            renderWidth = (int)((float)this.field_230709_l_ * videoAspectRatio);
            renderHeight = this.field_230709_l_;
        }
        int xOffset = (this.field_230708_k_ - renderWidth) / 2;
        int yOffset = (this.field_230709_l_ - renderHeight) / 2;
        RenderSystem.enableBlend();
        RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)xOffset, (int)yOffset, (float)0.0f, (float)0.0f, (int)renderWidth, (int)renderHeight, (int)renderWidth, (int)renderHeight);
        RenderSystem.disableBlend();
    }

    private void renderIcon(MatrixStack stack, ImageRenderer image) {
        RenderSystem.enableBlend();
        RenderSystem.bindTexture((int)image.texture(this.tick, 1L, true));
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)(this.field_230708_k_ - 36), (int)(this.field_230709_l_ - 36), (float)0.0f, (float)0.0f, (int)36, (int)36, (int)28, (int)28);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.disableBlend();
    }

    private int getHeightCenter(int offset) {
        return this.field_230709_l_ / 2 + offset;
    }

    private void draw(MatrixStack stack, String text, int height) {
        VideoScreen.func_238476_c_((MatrixStack)stack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)text, (int)5, (int)height, (int)0xFFFFFF);
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231046_a_(int pKeyCode, int pScanCode, int pModifiers) {
        float newVolume;
        float actualVolume;
        if (pKeyCode == 256) {
            this.func_231164_f_();
        }
        if (pKeyCode == 265) {
            if (this.volume <= 95.0f) {
                this.volume += 5.0f;
            } else {
                this.volume = 100.0f;
                float masterVolume = Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MASTER);
                if ((double)masterVolume <= 0.95) {
                    Minecraft.func_71410_x().field_71474_y.func_186712_a(SoundCategory.MASTER, masterVolume + 0.1f);
                } else {
                    Minecraft.func_71410_x().field_71474_y.func_186712_a(SoundCategory.MASTER, 1.0f);
                }
            }
            actualVolume = Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MASTER);
            newVolume = this.volume * actualVolume;
            this.player.setVolume((int)newVolume);
        }
        if (pKeyCode == 264) {
            this.volume = this.volume >= 5.0f ? (this.volume -= 5.0f) : 0.0f;
            actualVolume = Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MASTER);
            newVolume = this.volume * actualVolume;
            this.player.setVolume((int)newVolume);
        }
        if (pKeyCode == 262) {
            this.player.seekTo(this.player.getTime() + 30000L);
        }
        if (pKeyCode == 263) {
            this.player.seekTo(this.player.getTime() - 10000L);
        }
        if (pKeyCode == 32) {
            if (!this.player.isPaused()) {
                this.paused = true;
                this.player.pause();
            } else {
                this.paused = false;
                this.player.play();
            }
        }
        return super.func_231046_a_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean func_231178_ax__() {
        return false;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        if (this.started) {
            this.started = false;
            this.player.stop();
            Minecraft.func_71410_x().func_147118_V().func_147687_e();
            GlStateManager.func_227758_s_((int)this.videoTexture);
            this.player.release();
            Minecraft.func_71410_x().func_147108_a((Screen)new IngameMenuScreen(true));
        }
    }

    protected void func_231160_c_() {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            this.field_230708_k_ = Minecraft.func_71410_x().field_71462_r.field_230708_k_;
            this.field_230709_l_ = Minecraft.func_71410_x().field_71462_r.field_230709_l_;
        }
        super.func_231160_c_();
    }

    static {
        FORMAT.setTimeZone(TimeZone.getTimeZone("GMT-00:00"));
    }
}

