/*
 * Decompiled with CFR 0.152.
 */
package fr.alphadesnoc.pixelmongocine.utils.cache;

import fr.alphadesnoc.pixelmongocine.utils.displayers.IDisplay;
import fr.alphadesnoc.pixelmongocine.utils.displayers.ImageDisplayer;
import fr.alphadesnoc.pixelmongocine.utils.displayers.VideoDisplayer;
import fr.alphadesnoc.pixelmongocine.utils.maths.Vec3d;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import me.srrapero720.watermedia.api.image.ImageFetch;
import me.srrapero720.watermedia.api.image.ImageRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SoundCategory;

public class TextureCache {
    private static final Map<String, TextureCache> CACHE = new HashMap<String, TextureCache>();
    public final String url;
    private volatile ImageFetch seeker;
    private volatile ImageRenderer picture;
    private volatile String error;
    private volatile boolean ready = false;
    private volatile boolean isVideo = false;
    private final AtomicInteger usage = new AtomicInteger();

    private TextureCache(String url) {
        this.url = url;
        this.use();
        this.attemptToLoad();
    }

    public static TextureCache get(String url) {
        TextureCache cache = CACHE.get(url);
        if (cache != null) {
            cache.use();
            return cache;
        }
        cache = new TextureCache(url);
        CACHE.put(url, cache);
        return cache;
    }

    private synchronized void attemptToLoad() {
        if (this.seeker != null) {
            return;
        }
        if (!this.url.isEmpty()) {
            this.seeker = new FramePictureFetcher(this, this.url);
            this.seeker.start();
        }
    }

    public IDisplay createDisplay(Vec3d pos, String url, float volume, float minDistance, float maxDistance, boolean loop, boolean playing) {
        return this.createDisplay(pos, url, volume, minDistance, maxDistance, loop, playing, false);
    }

    public IDisplay createDisplay(Vec3d pos, String url, float volume, float minDistance, float maxDistance, boolean loop, boolean playing, boolean noVideo) {
        volume *= Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MASTER);
        if (this.picture == null && !noVideo) {
            return VideoDisplayer.createVideoDisplay(pos, url, volume, minDistance, maxDistance, loop, playing);
        }
        return new ImageDisplayer(this.picture){

            @Override
            public void release() {
                TextureCache.this.deuse();
            }
        };
    }

    public void process(ImageRenderer picture) {
        if (this.ready) {
            return;
        }
        this.ready = true;
        this.seeker = null;
        this.picture = picture;
        this.error = null;
        this.isVideo = false;
    }

    public void processVideo() {
        this.ready = true;
        this.seeker = null;
        this.picture = null;
        this.error = null;
        this.isVideo = true;
    }

    public void processFailed(String error) {
        this.error = error;
        this.seeker = null;
        this.picture = null;
        this.ready = true;
        this.isVideo = false;
    }

    public synchronized boolean ready() {
        if (this.ready || this.seeker == null) {
            return true;
        }
        this.attemptToLoad();
        return false;
    }

    public String getError() {
        return this.error;
    }

    public boolean isVideo() {
        return this.isVideo;
    }

    public void use() {
        this.usage.incrementAndGet();
    }

    public void deuse() {
        this.usage.decrementAndGet();
    }

    public boolean isUsed() {
        return this.usage.get() > 0;
    }

    public void remove() {
        this.ready = false;
        if (this.picture != null) {
            this.picture.release();
            Arrays.fill(this.picture.textures, -1);
        }
        this.picture = null;
        this.seeker = null;
    }

    public static void clientTick() {
        CACHE.values().removeIf(o -> !o.isUsed());
    }

    public static void renderTick() {
        VideoDisplayer.tick();
    }

    public static void unload() {
        for (TextureCache cache : CACHE.values()) {
            cache.remove();
        }
        CACHE.clear();
    }

    private static final class FramePictureFetcher
    extends ImageFetch {
        public FramePictureFetcher(TextureCache cache, String originalURL) {
            super(originalURL);
            this.setOnSuccessCallback(imageRenderer -> Minecraft.func_71410_x().execute(() -> cache.process(imageRenderer)));
            this.setOnFailedCallback(e -> Minecraft.func_71410_x().execute(() -> {
                if (e instanceof ImageFetch.NoPictureException) {
                    cache.processVideo();
                    return;
                }
                if (!cache.isVideo()) {
                    if (e == null) {
                        cache.processFailed("download.exception.gif");
                    } else if (e.getMessage().startsWith("Server returned HTTP response code: 403")) {
                        cache.processFailed("download.exception.forbidden");
                    } else if (e.getMessage().startsWith("Server returned HTTP response code: 404")) {
                        cache.processFailed("download.exception.notfound");
                    } else {
                        cache.processFailed("download.exception.invalid");
                    }
                }
            }));
        }
    }
}

