/*
 * Decompiled with CFR 0.152.
 */
package fr.alphadesnoc.pixelmongocine.utils.displayers;

import com.mojang.blaze3d.platform.GlStateManager;
import fr.alphadesnoc.pixelmongocine.utils.MemoryTracker;
import fr.alphadesnoc.pixelmongocine.utils.cache.TextureCache;
import fr.alphadesnoc.pixelmongocine.utils.displayers.IDisplay;
import fr.alphadesnoc.pixelmongocine.utils.maths.Vec3d;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import me.lib720.watermod.safety.TryCore;
import me.srrapero720.watermedia.api.player.SyncVideoPlayer;
import net.minecraft.client.Minecraft;

public class VideoDisplayer
implements IDisplay {
    private static final String VLC_FAILED = "https://i.imgur.com/XCcN2uX.png";
    private static final int ACCEPTABLE_SYNC_TIME = 1000;
    private static final List<VideoDisplayer> OPEN_DISPLAYS = new ArrayList<VideoDisplayer>();
    public SyncVideoPlayer player;
    private final Vec3d pos;
    private float lastSetVolume;
    private long lastCorrectedTime = Long.MIN_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        List<VideoDisplayer> list = OPEN_DISPLAYS;
        synchronized (list) {
            for (VideoDisplayer display : OPEN_DISPLAYS) {
                if (!Minecraft.func_71410_x().func_147113_T()) continue;
                SyncVideoPlayer media = display.player;
                if (media.isPlaying() && display.player.isLive()) {
                    media.setPauseMode(true);
                    continue;
                }
                if (media.getDuration() <= 0L || !media.isPlaying()) continue;
                media.setPauseMode(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unload() {
        List<VideoDisplayer> list = OPEN_DISPLAYS;
        synchronized (list) {
            for (VideoDisplayer display : OPEN_DISPLAYS) {
                display.free();
            }
            OPEN_DISPLAYS.clear();
        }
    }

    public static IDisplay createVideoDisplay(Vec3d pos, String url, float volume, float minDistance, float maxDistance, boolean loop, boolean playing) {
        return (IDisplay)TryCore.withReturn(defaultVar -> {
            VideoDisplayer display = new VideoDisplayer(pos, url, volume, minDistance, maxDistance, loop);
            if (display.player.raw() == null) {
                throw new IllegalStateException("MediaDisplay uses a broken player");
            }
            OPEN_DISPLAYS.add(display);
            return display;
        }, (Object)((Supplier<IDisplay>)() -> {
            TextureCache cache = TextureCache.get(VLC_FAILED);
            if (cache.ready()) {
                return cache.createDisplay(pos, VLC_FAILED, volume, minDistance, maxDistance, loop, playing);
            }
            return null;
        }).get());
    }

    public VideoDisplayer(Vec3d pos, String url, float volume, float minDistance, float maxDistance, boolean loop) {
        this.pos = pos;
        if (url.isEmpty()) {
            return;
        }
        this.player = new SyncVideoPlayer(null, (Executor)Minecraft.func_71410_x(), MemoryTracker::create);
        volume = pos != null ? (float)this.getVolume(volume, minDistance, maxDistance) : volume;
        this.player.setVolume((int)volume);
        this.lastSetVolume = volume;
        this.player.setRepeatMode(loop);
        this.player.start((CharSequence)url);
    }

    public int getVolume(float volume, float minDistance, float maxDistance) {
        return (int)(volume * 100.0f);
    }

    @Override
    public void tick(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null || url == null) {
            return;
        }
        float f = volume = this.pos != null ? (float)this.getVolume(volume, minDistance, maxDistance) : volume;
        if (volume != this.lastSetVolume) {
            this.player.setVolume((int)volume);
            this.lastSetVolume = volume;
        }
        if (this.player.isValid()) {
            boolean realPlaying;
            boolean bl = realPlaying = playing && !Minecraft.func_71410_x().func_147113_T();
            if (this.player.getRepeatMode() != loop) {
                this.player.setRepeatMode(loop);
            }
            long tickTime = 50L;
            if (this.player.isLive()) {
                if (this.player.isPlaying() != realPlaying) {
                    this.player.setPauseMode(!realPlaying);
                }
            } else if (this.player.getDuration() > 0L) {
                if (this.player.isPlaying() != realPlaying) {
                    this.player.setPauseMode(!realPlaying);
                }
                if (this.player.isSeekAble()) {
                    Minecraft mc = Minecraft.func_71410_x();
                    long time = (long)tick * tickTime + (realPlaying ? (long)(mc.func_147113_T() ? 1.0f : mc.func_184121_ak() * (float)tickTime) : 0L);
                    if (time > this.player.getTime() && loop) {
                        time %= this.player.getDuration();
                    }
                    if (Math.abs(time - this.player.getTime()) > 1000L && Math.abs(time - this.lastCorrectedTime) > 1000L) {
                        this.lastCorrectedTime = time;
                        this.player.seekTo(time);
                    }
                }
            }
        }
    }

    @Override
    public int maxTick() {
        return IDisplay.super.maxTick();
    }

    @Override
    public int prepare(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return -1;
        }
        return this.player.prepareTexture();
    }

    public void free() {
        if (this.player != null) {
            this.player.release();
            if (this.player.getTexture() != -1) {
                GlStateManager.func_227758_s_((int)this.player.getTexture());
            }
            this.player = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.free();
        List<VideoDisplayer> list = OPEN_DISPLAYS;
        synchronized (list) {
            OPEN_DISPLAYS.remove(this);
        }
    }

    @Override
    public void pause(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return;
        }
        this.player.seekTo((long)tick);
        this.player.pause();
    }

    @Override
    public void resume(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return;
        }
        this.player.seekTo((long)tick);
        this.player.play();
    }

    @Override
    public Dimension getDimensions() {
        if (this.player == null) {
            return null;
        }
        return this.player.getDimensions();
    }
}

