/*
 * Decompiled with CFR 0.152.
 */
package gg.levely.pixelmongo.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import gg.levely.pixelmongo.client.util.BoxUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HUDOverlay {
    private static List<String> BLOCKS = Collections.emptyList();

    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        MatrixStack matrixStack = event.getMatrixStack();
        int screenWidth = event.getWindow().func_198107_o();
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        int x = screenWidth / 2 - BLOCKS.stream().map(BoxUtil::getBlockWidth).reduce(0, Integer::sum) / 2 - (int)(0.5 * (double)BLOCKS.size());
        int y = 4;
        for (String s : BLOCKS) {
            BoxUtil.drawBlock(matrixStack, x, y, s);
            x += BoxUtil.getBlockWidth(s) + 2;
        }
    }

    @SubscribeEvent
    public static void onChat(ClientChatReceivedEvent event) {
        String message = event.getMessage().getString();
        if (!message.startsWith("PGHUD-H|") || Minecraft.func_71410_x().func_71387_A()) {
            return;
        }
        event.setCanceled(true);
        String[] split = message.substring(8).replace("&", "\u00a7").split("\\|");
        BLOCKS = Arrays.asList(split);
    }
}

