/*
 * Decompiled with CFR 0.152.
 */
package gg.levely.pixelmongo.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;

public class BoxUtil {
    private static final HashMap<String, ResourceLocation> textures = new HashMap();
    private static final String TEXTURE_PATTERN = "\\$\\{([a-zA-Z0-9_]+)\\}";
    private static final Pattern TEXTURE_REGEX;

    public static void drawBlock(MatrixStack stack, int x, int y, String text) {
        int textWidth = BoxUtil.getTextWidth(text);
        Minecraft.func_71410_x().field_71466_p.getClass();
        int textHeight = 9;
        BoxUtil.drawBox(stack, x, y, textWidth, textHeight, 0x44000000);
        BoxUtil.drawText(stack, x, y + 1, -1, text);
    }

    private static void drawBox(MatrixStack stack, int x, int y, int width, int height, int color) {
        AbstractGui.func_238467_a_((MatrixStack)stack, (int)(x - 2), (int)(y - 2), (int)(x + width + 2), (int)(y + height + 2), (int)color);
        AbstractGui.func_238467_a_((MatrixStack)stack, (int)(x - 3), (int)(y - 1), (int)(x - 2), (int)(y + height + 1), (int)color);
        AbstractGui.func_238467_a_((MatrixStack)stack, (int)(x + width + 2), (int)(y - 1), (int)(x + width + 3), (int)(y + height + 1), (int)color);
    }

    public static void drawText(MatrixStack stack, int x, int y, int color, String text) {
        String[] texts = text.split(TEXTURE_PATTERN);
        Matcher matcher = TEXTURE_REGEX.matcher(text);
        int width = x;
        while (texts.length > 0) {
            String textureName;
            ResourceLocation texture;
            AbstractGui.func_238476_c_((MatrixStack)stack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)texts[0], (int)width, (int)y, (int)color);
            width += Minecraft.func_71410_x().field_71466_p.func_78256_a(texts[0]);
            if (matcher.find() && (texture = textures.get(textureName = matcher.group(1))) != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
                AbstractGui.func_238463_a_((MatrixStack)stack, (int)width, (int)y, (float)0.0f, (float)0.0f, (int)8, (int)8, (int)8, (int)8);
                width += 8;
            }
            texts = Arrays.copyOfRange(texts, 1, texts.length);
        }
    }

    public static int getTextWidth(String text) {
        String[] texts = text.split(TEXTURE_PATTERN);
        if (texts.length == 0) {
            return 0;
        }
        Matcher matcher = TEXTURE_REGEX.matcher(text);
        int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(texts[0]);
        while (matcher.find()) {
            String textureName = matcher.group(1);
            ResourceLocation texture = textures.get(textureName);
            if (texture == null) continue;
            width += 8;
            if ((texts = Arrays.copyOfRange(texts, 1, texts.length)).length <= 0) continue;
            width += Minecraft.func_71410_x().field_71466_p.func_78256_a(texts[0]);
        }
        return width;
    }

    public static int getBlockWidth(String text) {
        return BoxUtil.getTextWidth(text) + 6;
    }

    static {
        textures.put("gemme_bleue", new ResourceLocation("pixelhud", "textures/gemme_bleu.png"));
        textures.put("gemme_rouge", new ResourceLocation("pixelhud", "textures/gemme_rouge.png"));
        textures.put("monde", new ResourceLocation("pixelhud", "textures/monde.png"));
        textures.put("piece", new ResourceLocation("pixelhud", "textures/piece.png"));
        textures.put("pokeball", new ResourceLocation("pixelhud", "textures/pokeball.png"));
        TEXTURE_REGEX = Pattern.compile(TEXTURE_PATTERN);
    }
}

