/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.lightfall.client;

import io.izzel.lightfall.client.bridge.ClientLoginNetHandlerBridge;
import io.izzel.lightfall.client.gui.LightfallHandshakeScreen;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.login.ClientLoginNetHandler;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.login.client.CCustomPayloadLoginPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.event.EventNetworkChannel;
import net.minecraftforge.registries.GameData;

@Mod(value="lightfallclient")
public class LightfallClient {
    private static final byte[] RESET_ACK = "lightfall:ack".getBytes(StandardCharsets.UTF_8);

    public LightfallClient() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::registerChannel);
    }

    private void registerChannel() {
        EventNetworkChannel channel = NetworkRegistry.newEventChannel((ResourceLocation)new ResourceLocation("lightfall", "reset"), () -> "1", s -> true, s -> true);
        channel.addListener(this::handleReset);
    }

    private void handleReset(NetworkEvent.ServerCustomPayloadEvent event) {
        NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
        NetworkManager netManager = context.getNetworkManager();
        if (netManager == null || !(netManager.func_150729_e() instanceof ClientPlayNetHandler)) {
            return;
        }
        context.enqueueWork(() -> {
            Minecraft client = Minecraft.func_71410_x();
            LightfallHandshakeScreen screen = new LightfallHandshakeScreen(netManager);
            client.func_147108_a((Screen)screen);
            if (client.field_71441_e != null) {
                GameData.revertToFrozen();
                client.field_71441_e = null;
            }
            netManager.func_150723_a(ProtocolType.LOGIN);
            PacketBuffer buffer = new PacketBuffer(Unpooled.wrappedBuffer((byte[])RESET_ACK));
            netManager.func_179290_a((IPacket)new CCustomPayloadLoginPacket(0x11FFA1, buffer));
            ClientLoginNetHandler netHandler = new ClientLoginNetHandler(netManager, client, (Screen)new MultiplayerScreen((Screen)new MainMenuScreen()), arg_0 -> ((LightfallHandshakeScreen)screen).func_200210_a(arg_0));
            ((ClientLoginNetHandlerBridge)netHandler).bridge$reusePlayHandler((ClientPlayNetHandler)netManager.func_150729_e());
            netManager.func_150719_a((INetHandler)netHandler);
        });
        context.setPacketHandled(true);
    }
}

