/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.config.options.ConfigBase;

public class ConfigString
extends ConfigBase<ConfigString>
implements IConfigValue {
    private final String defaultValue;
    private String value;

    public ConfigString(String name, String defaultValue, String comment) {
        super(ConfigType.STRING, name, comment);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public String getDefaultStringValue() {
        return this.defaultValue;
    }

    @Override
    public void setValueFromString(String value) {
        String oldValue = this.value;
        this.value = value;
        if (!oldValue.equals(this.value)) {
            this.onValueChanged();
        }
    }

    @Override
    public void resetToDefault() {
        this.value = this.defaultValue;
    }

    @Override
    public boolean isModified() {
        return !this.value.equals(this.defaultValue);
    }

    @Override
    public boolean isModified(String newValue) {
        return !this.defaultValue.equals(newValue);
    }

    @Override
    public void setValueFromJsonElement(JsonElement element) {
        try {
            if (element.isJsonPrimitive()) {
                this.value = element.getAsString();
            } else {
                MaLiLib.logger.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element);
            }
        }
        catch (Exception e) {
            MaLiLib.logger.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element, (Object)e);
        }
    }

    @Override
    public JsonElement getAsJsonElement() {
        return new JsonPrimitive(this.value);
    }
}

