/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IMessageConsumer;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetLabel;
import fi.dy.masa.malilib.gui.wrappers.TextFieldWrapper;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.render.MessageRenderer;
import fi.dy.masa.malilib.render.RenderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class GuiBase
extends Screen
implements IMessageConsumer,
IStringConsumer {
    public static final String TXT_AQUA = TextFormatting.AQUA.toString();
    public static final String TXT_BLACK = TextFormatting.BLACK.toString();
    public static final String TXT_BLUE = TextFormatting.BLUE.toString();
    public static final String TXT_GOLD = TextFormatting.GOLD.toString();
    public static final String TXT_GRAY = TextFormatting.GRAY.toString();
    public static final String TXT_GREEN = TextFormatting.GREEN.toString();
    public static final String TXT_RED = TextFormatting.RED.toString();
    public static final String TXT_WHITE = TextFormatting.WHITE.toString();
    public static final String TXT_YELLOW = TextFormatting.YELLOW.toString();
    public static final String TXT_BOLD = TextFormatting.BOLD.toString();
    public static final String TXT_ITALIC = TextFormatting.ITALIC.toString();
    public static final String TXT_RST = TextFormatting.RESET.toString();
    public static final String TXT_STRIKETHROUGH = TextFormatting.STRIKETHROUGH.toString();
    public static final String TXT_UNDERLINE = TextFormatting.UNDERLINE.toString();
    public static final String TXT_DARK_AQUA = TextFormatting.DARK_AQUA.toString();
    public static final String TXT_DARK_BLUE = TextFormatting.DARK_BLUE.toString();
    public static final String TXT_DARK_GRAY = TextFormatting.DARK_GRAY.toString();
    public static final String TXT_DARK_GREEN = TextFormatting.DARK_GREEN.toString();
    public static final String TXT_DARK_PURPLE = TextFormatting.DARK_PURPLE.toString();
    public static final String TXT_DARK_RED = TextFormatting.DARK_RED.toString();
    public static final String TXT_LIGHT_PURPLE = TextFormatting.LIGHT_PURPLE.toString();
    protected static final String BUTTON_LABEL_ADD = TXT_DARK_GREEN + "+" + TXT_RST;
    protected static final String BUTTON_LABEL_REMOVE = TXT_DARK_RED + "-" + TXT_RST;
    public static final int COLOR_WHITE = -1;
    public static final int TOOLTIP_BACKGROUND = -1342177280;
    public static final int COLOR_HORIZONTAL_BAR = -6710887;
    protected static final int LEFT = 20;
    protected static final int TOP = 10;
    public final Minecraft mc = Minecraft.func_71410_x();
    public final FontRenderer textRenderer;
    public final int fontHeight;
    private final List<ButtonBase> buttons;
    private final List<WidgetBase> widgets;
    private final List<TextFieldWrapper<? extends GuiTextFieldGeneric>> textFields;
    private final MessageRenderer messageRenderer;
    protected WidgetBase hoveredWidget;
    protected String field_230704_d_;
    protected boolean useTitleHierarchy;
    private int keyInputCount;
    @Nullable
    private Screen parent;

    protected GuiBase() {
        super((ITextComponent)new StringTextComponent(""));
        this.textRenderer = this.mc.field_71466_p;
        this.textRenderer.getClass();
        this.fontHeight = 9;
        this.buttons = new ArrayList<ButtonBase>();
        this.widgets = new ArrayList<WidgetBase>();
        this.textFields = new ArrayList<TextFieldWrapper<? extends GuiTextFieldGeneric>>();
        this.messageRenderer = new MessageRenderer(-587202560, -6710887);
        this.hoveredWidget = null;
        this.field_230704_d_ = "";
        this.useTitleHierarchy = true;
    }

    public GuiBase setParent(@Nullable Screen parent) {
        if (parent == null || parent.getClass() != this.getClass()) {
            this.parent = parent;
        }
        return this;
    }

    @Nullable
    public Screen getParent() {
        return this.parent;
    }

    public String getTitleString() {
        return this.useTitleHierarchy && this.parent instanceof GuiBase ? ((GuiBase)this.parent).getTitleString() + " => " + this.field_230704_d_ : this.field_230704_d_;
    }

    public ITextComponent func_231171_q_() {
        return new StringTextComponent(this.getTitleString());
    }

    public void setTitle(String title) {
        this.field_230704_d_ = title;
    }

    public void removed() {
        this.mc.field_195559_v.func_197967_a(false);
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.initGui();
    }

    public void initGui() {
        this.clearElements();
    }

    protected void closeGui(boolean showParent) {
        if (showParent) {
            this.mc.func_147108_a(this.parent);
        } else {
            this.func_231164_f_();
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.drawScreenBackground(mouseX, mouseY);
        this.drawTitle(matrixStack, mouseX, mouseY, partialTicks);
        this.drawWidgets(mouseX, mouseY, matrixStack);
        this.drawTextFields(mouseX, mouseY, matrixStack);
        this.drawButtons(mouseX, mouseY, partialTicks, matrixStack);
        this.drawContents(matrixStack, mouseX, mouseY, partialTicks);
        this.drawButtonHoverTexts(mouseX, mouseY, partialTicks, matrixStack);
        this.drawHoveredWidget(mouseX, mouseY, matrixStack);
        this.drawGuiMessages(matrixStack);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (amount == 0.0 || this.onMouseScrolled((int)mouseX, (int)mouseY, amount)) {
            return super.func_231043_a_(mouseX, mouseY, amount);
        }
        return false;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (!this.onMouseClicked((int)mouseX, (int)mouseY, mouseButton)) {
            return super.func_231044_a_(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        if (!this.onMouseReleased((int)mouseX, (int)mouseY, mouseButton)) {
            return super.func_231048_c_(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        ++this.keyInputCount;
        if (this.onKeyTyped(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char charIn, int modifiers) {
        if (this.keyInputCount <= 0) {
            return true;
        }
        if (this.onCharTyped(charIn, modifiers)) {
            return true;
        }
        return super.func_231042_a_(charIn, modifiers);
    }

    public boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        for (ButtonBase button : this.buttons) {
            if (!button.onMouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        boolean handled = false;
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> entry : this.textFields) {
            if (!entry.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            handled = true;
        }
        if (!handled) {
            for (WidgetBase widget : this.widgets) {
                if (!widget.isMouseOver(mouseX, mouseY) || !widget.onMouseClicked(mouseX, mouseY, mouseButton)) continue;
                handled = true;
                break;
            }
        }
        return handled;
    }

    public boolean onMouseReleased(int mouseX, int mouseY, int mouseButton) {
        for (WidgetBase widget : this.widgets) {
            widget.onMouseReleased(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean onMouseScrolled(int mouseX, int mouseY, double mouseWheelDelta) {
        for (ButtonBase button : this.buttons) {
            if (!button.onMouseScrolled(mouseX, mouseY, mouseWheelDelta)) continue;
            return true;
        }
        for (WidgetBase widget : this.widgets) {
            if (!widget.onMouseScrolled(mouseX, mouseY, mouseWheelDelta)) continue;
            return true;
        }
        return false;
    }

    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        boolean handled = false;
        int selected = -1;
        for (int i = 0; i < this.textFields.size(); ++i) {
            TextFieldWrapper<? extends GuiTextFieldGeneric> entry = this.textFields.get(i);
            if (!entry.isFocused()) continue;
            if (keyCode == 258) {
                entry.setFocused(false);
                selected = i;
            } else {
                entry.onKeyTyped(keyCode, scanCode, modifiers);
            }
            handled = keyCode != 256;
            break;
        }
        if (!handled) {
            for (WidgetBase widget : this.widgets) {
                if (!widget.onKeyTyped(keyCode, scanCode, modifiers)) continue;
                handled = true;
                break;
            }
        }
        if (!handled && keyCode == 256) {
            this.closeGui(!GuiBase.isShiftDown());
            return true;
        }
        if (selected >= 0) {
            selected = GuiBase.isShiftDown() ? (selected > 0 ? selected - 1 : this.textFields.size() - 1) : (selected + 1) % this.textFields.size();
            this.textFields.get(selected).setFocused(true);
        }
        return handled;
    }

    public boolean onCharTyped(char charIn, int modifiers) {
        boolean handled = false;
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> entry : this.textFields) {
            if (!entry.onCharTyped(charIn, modifiers)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            for (WidgetBase widget : this.widgets) {
                if (!widget.onCharTyped(charIn, modifiers)) continue;
                handled = true;
                break;
            }
        }
        return handled;
    }

    @Override
    public void setString(String string) {
        this.messageRenderer.addMessage(3000, string, new Object[0]);
    }

    @Override
    public void addMessage(Message.MessageType type, String messageKey, Object ... args) {
        this.addGuiMessage(type, 5000, messageKey, args);
    }

    @Override
    public void addMessage(Message.MessageType type, int lifeTime, String messageKey, Object ... args) {
        this.addGuiMessage(type, lifeTime, messageKey, args);
    }

    public void addGuiMessage(Message.MessageType type, int displayTimeMs, String messageKey, Object ... args) {
        this.messageRenderer.addMessage(type, displayTimeMs, messageKey, args);
    }

    public void setNextMessageType(Message.MessageType type) {
        this.messageRenderer.setNextMessageType(type);
    }

    protected void drawGuiMessages(MatrixStack matrixStack) {
        this.messageRenderer.drawMessages(this.field_230708_k_ / 2, this.field_230709_l_ / 2, matrixStack);
    }

    public void bindTexture(ResourceLocation texture) {
        RenderUtils.bindTexture(texture);
    }

    public <T extends ButtonBase> T addButton(T button, IButtonActionListener listener) {
        button.setActionListener(listener);
        this.buttons.add(button);
        return button;
    }

    public <T extends GuiTextFieldGeneric> TextFieldWrapper<T> addTextField(T textField, @Nullable ITextFieldListener<T> listener) {
        TextFieldWrapper<T> wrapper = new TextFieldWrapper<T>(textField, listener);
        this.textFields.add(wrapper);
        return wrapper;
    }

    public <T extends WidgetBase> T addWidget(T widget) {
        this.widgets.add(widget);
        return widget;
    }

    public WidgetLabel addLabel(int x, int y, int width, int height, int textColor, String ... lines) {
        return this.addLabel(x, y, width, height, textColor, Arrays.asList(lines));
    }

    public WidgetLabel addLabel(int x, int y, int width, int height, int textColor, List<String> lines) {
        if (lines.size() > 0 && width == -1) {
            for (String line : lines) {
                width = Math.max(width, this.getStringWidth(line));
            }
        }
        return this.addWidget(new WidgetLabel(x, y, width, height, textColor, lines));
    }

    protected boolean removeWidget(WidgetBase widget) {
        if (widget != null && this.widgets.contains(widget)) {
            this.widgets.remove(widget);
            return true;
        }
        return false;
    }

    protected void clearElements() {
        this.clearWidgets();
        this.clearButtons();
        this.clearTextFields();
    }

    protected void clearWidgets() {
        this.widgets.clear();
    }

    protected void clearButtons() {
        this.buttons.clear();
    }

    protected void clearTextFields() {
        this.textFields.clear();
    }

    protected void drawScreenBackground(int mouseX, int mouseY) {
        RenderUtils.drawRect(0, 0, this.field_230708_k_, this.field_230709_l_, -1342177280);
    }

    protected void drawTitle(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.drawString(matrixStack, this.getTitleString(), 20, 10, -1);
    }

    protected void drawContents(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
    }

    protected void drawButtons(int mouseX, int mouseY, float partialTicks, MatrixStack matrixStack) {
        for (ButtonBase button : this.buttons) {
            button.render(mouseX, mouseY, button.isMouseOver(), matrixStack);
        }
    }

    protected void drawTextFields(int mouseX, int mouseY, MatrixStack matrixStack) {
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> entry : this.textFields) {
            entry.draw(mouseX, mouseY, matrixStack);
        }
    }

    protected void drawWidgets(int mouseX, int mouseY, MatrixStack matrixStack) {
        this.hoveredWidget = null;
        if (!this.widgets.isEmpty()) {
            for (WidgetBase widget : this.widgets) {
                widget.render(mouseX, mouseY, false, matrixStack);
                if (!widget.isMouseOver(mouseX, mouseY)) continue;
                this.hoveredWidget = widget;
            }
        }
    }

    protected void drawButtonHoverTexts(int mouseX, int mouseY, float partialTicks, MatrixStack matrixStack) {
        for (ButtonBase button : this.buttons) {
            if (!button.hasHoverText() || !button.isMouseOver()) continue;
            RenderUtils.drawHoverText(mouseX, mouseY, button.getHoverStrings(), matrixStack);
        }
        RenderUtils.disableDiffuseLighting();
    }

    protected void drawHoveredWidget(int mouseX, int mouseY, MatrixStack matrixStack) {
        if (this.hoveredWidget != null) {
            this.hoveredWidget.postRenderHovered(mouseX, mouseY, false, matrixStack);
            RenderUtils.disableDiffuseLighting();
        }
    }

    public static boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public int getStringWidth(String text) {
        return this.textRenderer.func_78256_a(text);
    }

    public void drawString(MatrixStack matrixStack, String text, int x, int y, int color) {
        this.textRenderer.func_238421_b_(matrixStack, text, (float)x, (float)y, color);
    }

    public void drawStringWithShadow(MatrixStack matrixStack, String text, int x, int y, int color) {
        this.textRenderer.func_238405_a_(matrixStack, text, (float)x, (float)y, color);
    }

    public int getMaxPrettyNameLength(List<? extends IConfigBase> configs) {
        int width = 0;
        for (IConfigBase iConfigBase : configs) {
            width = Math.max(width, this.getStringWidth(iConfigBase.getPrettyName()));
        }
        return width;
    }

    public static void openGui(Screen gui) {
        Minecraft.func_71410_x().func_147108_a(gui);
    }

    public static boolean isShiftDown() {
        return GuiBase.func_231173_s_();
    }

    public static boolean isCtrlDown() {
        return GuiBase.func_231172_r_();
    }

    public static boolean isAltDown() {
        return GuiBase.func_231174_t_();
    }
}

