/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.util.ItemType;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class InventoryUtils {
    private static final NonNullList<ItemStack> EMPTY_LIST = NonNullList.func_191196_a();

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean areStacksEqualIgnoreDurability(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_185132_d((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static void swapSlots(Container container, int slotNum, int hotbarSlot) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71442_b.func_187098_a(container.field_75152_c, slotNum, hotbarSlot, ClickType.SWAP, (PlayerEntity)mc.field_71439_g);
    }

    public static boolean isRegularInventorySlot(int slotNumber, boolean allowOffhand) {
        return slotNumber > 8 && (allowOffhand || slotNumber < 45);
    }

    public static int findEmptySlotInPlayerInventory(Container containerPlayer, boolean allowOffhand, boolean reverse) {
        int startSlot = reverse ? containerPlayer.field_75151_b.size() - 1 : 0;
        int endSlot = reverse ? -1 : containerPlayer.field_75151_b.size();
        int increment = reverse ? -1 : 1;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            Slot slot = (Slot)containerPlayer.field_75151_b.get(slotNum);
            ItemStack stackSlot = slot.func_75211_c();
            if (!stackSlot.func_190926_b() || !InventoryUtils.isRegularInventorySlot(slot.field_75222_d, allowOffhand)) continue;
            return slot.field_75222_d;
        }
        return -1;
    }

    public static int findSlotWithItem(Container container, ItemStack stackReference, boolean reverse) {
        int startSlot = reverse ? container.field_75151_b.size() - 1 : 0;
        int endSlot = reverse ? -1 : container.field_75151_b.size();
        int increment = reverse ? -1 : 1;
        boolean isPlayerInv = container instanceof PlayerContainer;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            Slot slot = (Slot)container.field_75151_b.get(slotNum);
            if (isPlayerInv && !InventoryUtils.isRegularInventorySlot(slot.field_75222_d, false) || !InventoryUtils.areStacksEqualIgnoreDurability(slot.func_75211_c(), stackReference)) continue;
            return slot.field_75222_d;
        }
        return -1;
    }

    public static boolean swapItemToMainHand(ItemStack stackReference, Minecraft mc) {
        ClientPlayerEntity player = mc.field_71439_g;
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        if (InventoryUtils.areStacksEqual(stackReference, player.func_184614_ca())) {
            return false;
        }
        if (isCreative) {
            player.field_71071_by.func_184434_a(stackReference);
            mc.field_71442_b.func_78761_a(player.func_184614_ca(), 36 + player.field_71071_by.field_70461_c);
            return true;
        }
        int slot = InventoryUtils.findSlotWithItem((Container)player.field_71069_bz, stackReference, true);
        if (slot != -1) {
            int currentHotbarSlot = player.field_71071_by.field_70461_c;
            mc.field_71442_b.func_187098_a(player.field_71069_bz.field_75152_c, slot, currentHotbarSlot, ClickType.SWAP, (PlayerEntity)mc.field_71439_g);
            return true;
        }
        return false;
    }

    @Nullable
    public static IInventory getInventory(World world, BlockPos pos) {
        if (!world.func_175667_e(pos)) {
            return null;
        }
        TileEntity te = world.func_217349_x(pos).func_175625_s(pos);
        if (te instanceof IInventory) {
            BlockPos posAdj;
            ChestType type;
            IInventory inv = (IInventory)te;
            BlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof ChestBlock && te instanceof ChestTileEntity && (type = (ChestType)state.func_177229_b((Property)ChestBlock.field_196314_b)) != ChestType.SINGLE && world.func_175667_e(posAdj = pos.func_177972_a(ChestBlock.func_196311_i((BlockState)state)))) {
                BlockState stateAdj = world.func_180495_p(posAdj);
                TileEntity te2 = world.func_217349_x(posAdj).func_175625_s(posAdj);
                if (stateAdj.func_177230_c() == state.func_177230_c() && te2 instanceof ChestTileEntity && stateAdj.func_177229_b((Property)ChestBlock.field_196314_b) != ChestType.SINGLE && stateAdj.func_177229_b((Property)ChestBlock.field_176459_a) == state.func_177229_b((Property)ChestBlock.field_176459_a)) {
                    IInventory invRight = type == ChestType.RIGHT ? inv : (IInventory)te2;
                    IInventory invLeft = type == ChestType.RIGHT ? (IInventory)te2 : inv;
                    inv = new DoubleSidedInventory(invRight, invLeft);
                }
            }
            return inv;
        }
        return null;
    }

    public static boolean shulkerBoxHasItems(ItemStack stackShulkerBox) {
        CompoundNBT tag;
        CompoundNBT nbt = stackShulkerBox.func_77978_p();
        if (nbt != null && nbt.func_150297_b("BlockEntityTag", 10) && (tag = nbt.func_74775_l("BlockEntityTag")).func_150297_b("Items", 9)) {
            ListNBT tagList = tag.func_150295_c("Items", 10);
            return tagList.size() > 0;
        }
        return false;
    }

    public static NonNullList<ItemStack> getStoredItems(ItemStack stackIn) {
        CompoundNBT tagBlockEntity;
        CompoundNBT nbt = stackIn.func_77978_p();
        if (nbt != null && nbt.func_150297_b("BlockEntityTag", 10) && (tagBlockEntity = nbt.func_74775_l("BlockEntityTag")).func_150297_b("Items", 9)) {
            NonNullList items = NonNullList.func_191196_a();
            ListNBT tagList = tagBlockEntity.func_150295_c("Items", 10);
            int count = tagList.size();
            for (int i = 0; i < count; ++i) {
                ItemStack stack = ItemStack.func_199557_a((CompoundNBT)tagList.func_150305_b(i));
                if (stack.func_190926_b()) continue;
                items.add((Object)stack);
            }
            return items;
        }
        return NonNullList.func_191196_a();
    }

    public static NonNullList<ItemStack> getStoredItems(ItemStack stackIn, int slotCount) {
        CompoundNBT tagBlockEntity;
        CompoundNBT nbt = stackIn.func_77978_p();
        if (nbt != null && nbt.func_150297_b("BlockEntityTag", 10) && (tagBlockEntity = nbt.func_74775_l("BlockEntityTag")).func_150297_b("Items", 9)) {
            ListNBT tagList = tagBlockEntity.func_150295_c("Items", 10);
            int count = tagList.size();
            byte maxSlot = -1;
            if (slotCount <= 0) {
                for (int i = 0; i < count; ++i) {
                    CompoundNBT tag = tagList.func_150305_b(i);
                    byte slot = tag.func_74771_c("Slot");
                    if (slot <= maxSlot) continue;
                    maxSlot = slot;
                }
                slotCount = maxSlot + 1;
            }
            NonNullList items = NonNullList.func_191197_a((int)slotCount, (Object)ItemStack.field_190927_a);
            for (int i = 0; i < count; ++i) {
                CompoundNBT tag = tagList.func_150305_b(i);
                ItemStack stack = ItemStack.func_199557_a((CompoundNBT)tag);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= items.size() || stack.func_190926_b()) continue;
                items.set((int)slot, (Object)stack);
            }
            return items;
        }
        return EMPTY_LIST;
    }

    public static Object2IntOpenHashMap<ItemType> getStoredItemCounts(ItemStack stackShulkerBox) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        NonNullList<ItemStack> items = InventoryUtils.getStoredItems(stackShulkerBox);
        for (int slot = 0; slot < items.size(); ++slot) {
            ItemStack stack = (ItemStack)items.get(slot);
            if (stack.func_190926_b()) continue;
            map.addTo((Object)new ItemType(stack), stack.func_190916_E());
        }
        return map;
    }

    public static Object2IntOpenHashMap<ItemType> getInventoryItemCounts(IInventory inv) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        int slots = inv.func_70302_i_();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack.func_190926_b()) continue;
            map.addTo((Object)new ItemType(stack, false, true), stack.func_190916_E());
            if (!(stack.func_77973_b() instanceof BlockItem) || !(((BlockItem)stack.func_77973_b()).func_179223_d() instanceof ShulkerBoxBlock) || !InventoryUtils.shulkerBoxHasItems(stack)) continue;
            Object2IntOpenHashMap<ItemType> boxCounts = InventoryUtils.getStoredItemCounts(stack);
            for (ItemType type : boxCounts.keySet()) {
                map.addTo((Object)type, boxCounts.getInt((Object)type));
            }
        }
        return map;
    }

    public static IInventory getAsInventory(NonNullList<ItemStack> items) {
        Inventory inv = new Inventory(items.size());
        for (int slot = 0; slot < items.size(); ++slot) {
            inv.func_70299_a(slot, (ItemStack)items.get(slot));
        }
        return inv;
    }
}

