/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class PositionUtils {
    public static final Direction[] ALL_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final Direction[] HORIZONTAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final Direction[] VERTICAL_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP};

    public static Vector3d modifyValue(CoordinateType type, Vector3d valueIn, double amount) {
        switch (type) {
            case X: {
                return new Vector3d(valueIn.field_72450_a + amount, valueIn.field_72448_b, valueIn.field_72449_c);
            }
            case Y: {
                return new Vector3d(valueIn.field_72450_a, valueIn.field_72448_b + amount, valueIn.field_72449_c);
            }
            case Z: {
                return new Vector3d(valueIn.field_72450_a, valueIn.field_72448_b, valueIn.field_72449_c + amount);
            }
        }
        return valueIn;
    }

    public static BlockPos modifyValue(CoordinateType type, BlockPos valueIn, int amount) {
        switch (type) {
            case X: {
                return new BlockPos(valueIn.func_177958_n() + amount, valueIn.func_177956_o(), valueIn.func_177952_p());
            }
            case Y: {
                return new BlockPos(valueIn.func_177958_n(), valueIn.func_177956_o() + amount, valueIn.func_177952_p());
            }
            case Z: {
                return new BlockPos(valueIn.func_177958_n(), valueIn.func_177952_p(), valueIn.func_177952_p() + amount);
            }
        }
        return valueIn;
    }

    public static Vector3d setValue(CoordinateType type, Vector3d valueIn, double newValue) {
        switch (type) {
            case X: {
                return new Vector3d(newValue, valueIn.field_72448_b, valueIn.field_72449_c);
            }
            case Y: {
                return new Vector3d(valueIn.field_72450_a, newValue, valueIn.field_72449_c);
            }
            case Z: {
                return new Vector3d(valueIn.field_72450_a, valueIn.field_72448_b, newValue);
            }
        }
        return valueIn;
    }

    public static BlockPos setValue(CoordinateType type, BlockPos valueIn, int newValue) {
        switch (type) {
            case X: {
                return new BlockPos(newValue, valueIn.func_177956_o(), valueIn.func_177952_p());
            }
            case Y: {
                return new BlockPos(valueIn.func_177958_n(), newValue, valueIn.func_177952_p());
            }
            case Z: {
                return new BlockPos(valueIn.func_177958_n(), valueIn.func_177952_p(), newValue);
            }
        }
        return valueIn;
    }

    public static BlockPos getEntityBlockPos(Entity entity) {
        return new BlockPos(Math.floor(entity.func_226277_ct_()), Math.floor(entity.func_226278_cu_()), Math.floor(entity.func_226281_cx_()));
    }

    public static Direction getClosestLookingDirection(Entity entity) {
        return PositionUtils.getClosestLookingDirection(entity, 60.0f);
    }

    public static Direction getClosestLookingDirection(Entity entity, float verticalThreshold) {
        if (entity.field_70125_A >= verticalThreshold) {
            return Direction.DOWN;
        }
        if (entity.field_70125_A <= -verticalThreshold) {
            return Direction.UP;
        }
        return entity.func_174811_aO();
    }

    public static BlockPos getPositionInfrontOfEntity(Entity entity) {
        return PositionUtils.getPositionInfrontOfEntity(entity, 60.0f);
    }

    public static BlockPos getPositionInfrontOfEntity(Entity entity, float verticalThreshold) {
        double x = entity.func_226277_ct_();
        double y = entity.func_226278_cu_();
        double z = entity.func_226281_cx_();
        double w = entity.func_213311_cf();
        BlockPos pos = new BlockPos(x, y, z);
        if (entity.field_70125_A >= verticalThreshold) {
            return pos.func_177979_c(1);
        }
        if (entity.field_70125_A <= -verticalThreshold) {
            return new BlockPos(x, Math.ceil(entity.func_174813_aQ().field_72337_e), z);
        }
        y = Math.floor(y + (double)entity.func_70047_e());
        switch (entity.func_174811_aO()) {
            case EAST: {
                return new BlockPos((int)Math.ceil(x + w / 2.0), (int)y, (int)Math.floor(z));
            }
            case WEST: {
                return new BlockPos((int)Math.floor(x - w / 2.0) - 1, (int)y, (int)Math.floor(z));
            }
            case SOUTH: {
                return new BlockPos((int)Math.floor(x), (int)y, (int)Math.ceil(z + w / 2.0));
            }
            case NORTH: {
                return new BlockPos((int)Math.floor(x), (int)y, (int)Math.floor(z - w / 2.0) - 1);
            }
        }
        return pos;
    }

    public static Vector3d getHitVecCenter(BlockPos basePos, Direction facing) {
        int x = basePos.func_177958_n();
        int y = basePos.func_177956_o();
        int z = basePos.func_177952_p();
        switch (facing) {
            case UP: {
                return new Vector3d((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
            }
            case DOWN: {
                return new Vector3d((double)x + 0.5, (double)y, (double)z + 0.5);
            }
            case NORTH: {
                return new Vector3d((double)x + 0.5, (double)y + 0.5, (double)z);
            }
            case SOUTH: {
                return new Vector3d((double)x + 0.5, (double)y + 0.5, (double)(z + 1));
            }
            case WEST: {
                return new Vector3d((double)x, (double)y + 0.5, (double)z);
            }
            case EAST: {
                return new Vector3d((double)(x + 1), (double)y + 0.5, (double)(z + 1));
            }
        }
        return new Vector3d((double)x, (double)y, (double)z);
    }

    public static HitPart getHitPart(Direction originalSide, Direction playerFacingH, BlockPos pos, Vector3d hitVec) {
        Vector3d positions = PositionUtils.getHitPartPositions(originalSide, playerFacingH, pos, hitVec);
        double posH = positions.field_72450_a;
        double posV = positions.field_72448_b;
        double offH = Math.abs(posH - 0.5);
        double offV = Math.abs(posV - 0.5);
        if (offH > 0.25 || offV > 0.25) {
            if (offH > offV) {
                return posH < 0.5 ? HitPart.LEFT : HitPart.RIGHT;
            }
            return posV < 0.5 ? HitPart.BOTTOM : HitPart.TOP;
        }
        return HitPart.CENTER;
    }

    private static Vector3d getHitPartPositions(Direction originalSide, Direction playerFacingH, BlockPos pos, Vector3d hitVec) {
        double x = hitVec.field_72450_a - (double)pos.func_177958_n();
        double y = hitVec.field_72448_b - (double)pos.func_177956_o();
        double z = hitVec.field_72449_c - (double)pos.func_177952_p();
        double posH = 0.0;
        double posV = 0.0;
        switch (originalSide) {
            case UP: 
            case DOWN: {
                switch (playerFacingH) {
                    case NORTH: {
                        posH = x;
                        posV = 1.0 - z;
                        break;
                    }
                    case SOUTH: {
                        posH = 1.0 - x;
                        posV = z;
                        break;
                    }
                    case WEST: {
                        posH = 1.0 - z;
                        posV = 1.0 - x;
                        break;
                    }
                    case EAST: {
                        posH = z;
                        posV = x;
                        break;
                    }
                }
                if (originalSide != Direction.DOWN) break;
                posV = 1.0 - posV;
                break;
            }
            case SOUTH: 
            case NORTH: {
                posH = originalSide.func_176743_c() == Direction.AxisDirection.POSITIVE ? x : 1.0 - x;
                posV = y;
                break;
            }
            case EAST: 
            case WEST: {
                posH = originalSide.func_176743_c() == Direction.AxisDirection.NEGATIVE ? z : 1.0 - z;
                posV = y;
            }
        }
        return new Vector3d(posH, posV, 0.0);
    }

    public static Direction getTargetedDirection(Direction side, Direction playerFacingH, BlockPos pos, Vector3d hitVec) {
        Vector3d positions = PositionUtils.getHitPartPositions(side, playerFacingH, pos, hitVec);
        double posH = positions.field_72450_a;
        double posV = positions.field_72448_b;
        double offH = Math.abs(posH - 0.5);
        double offV = Math.abs(posV - 0.5);
        if (offH > 0.25 || offV > 0.25) {
            if (side.func_176740_k() == Direction.Axis.Y) {
                if (offH > offV) {
                    return posH < 0.5 ? playerFacingH.func_176735_f() : playerFacingH.func_176746_e();
                }
                if (side == Direction.DOWN) {
                    return posV > 0.5 ? playerFacingH.func_176734_d() : playerFacingH;
                }
                return posV < 0.5 ? playerFacingH.func_176734_d() : playerFacingH;
            }
            if (offH > offV) {
                return posH < 0.5 ? side.func_176746_e() : side.func_176735_f();
            }
            return posV < 0.5 ? Direction.DOWN : Direction.UP;
        }
        return side;
    }

    public static enum CoordinateType {
        X,
        Y,
        Z;

    }

    public static enum HitPart {
        CENTER,
        LEFT,
        RIGHT,
        BOTTOM,
        TOP;

    }
}

