/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IngredientBlacklistType;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EditModeConfig
implements IEditModeConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String[] defaultBlacklist = new String[0];
    private final Set<String> blacklist = new LinkedHashSet<String>();
    @Nullable
    private final File blacklistConfigFile;

    public EditModeConfig(@Nullable File jeiConfigurationDir) {
        Collections.addAll(this.blacklist, defaultBlacklist);
        if (jeiConfigurationDir != null) {
            this.blacklistConfigFile = new File(jeiConfigurationDir, "blacklist.cfg");
            this.loadBlacklistConfig();
        } else {
            this.blacklistConfigFile = null;
        }
    }

    private void loadBlacklistConfig() {
        if (this.blacklistConfigFile != null && this.blacklistConfigFile.exists()) {
            try (FileReader reader = new FileReader(this.blacklistConfigFile);){
                List strings = IOUtils.readLines((Reader)reader);
                this.blacklist.clear();
                this.blacklist.addAll(strings);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load blacklist from file {}", (Object)this.blacklistConfigFile, (Object)e);
            }
        }
    }

    private void saveBlacklist() {
        if (this.blacklistConfigFile != null) {
            try {
                if (this.blacklistConfigFile.createNewFile()) {
                    LOGGER.debug("Created blacklist config file: {}", (Object)this.blacklistConfigFile);
                }
                try (FileWriter writer = new FileWriter(this.blacklistConfigFile);){
                    IOUtils.writeLines(this.blacklist, (String)"\n", (Writer)writer);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to save blacklist to file {}", (Object)this.blacklistConfigFile, (Object)e);
            }
        }
    }

    @Override
    public <V> void addIngredientToConfigBlacklist(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        if (this.addIngredientToConfigBlacklistInternal(ingredient, blacklistType, ingredientHelper)) {
            this.saveBlacklist();
        }
    }

    private <V> boolean addIngredientToConfigBlacklistInternal(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String wildcardUid = EditModeConfig.getIngredientUid(ingredient, IngredientBlacklistType.WILDCARD, ingredientHelper);
        if (blacklistType == IngredientBlacklistType.ITEM) {
            String uid = EditModeConfig.getIngredientUid(ingredient, blacklistType, ingredientHelper);
            if (wildcardUid.equals(uid)) {
                return this.blacklist.add(wildcardUid);
            }
            return this.blacklist.add(uid);
        }
        if (blacklistType == IngredientBlacklistType.WILDCARD) {
            return this.blacklist.add(wildcardUid);
        }
        return false;
    }

    @Override
    public <V> void removeIngredientFromConfigBlacklist(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid = EditModeConfig.getIngredientUid(ingredient, blacklistType, ingredientHelper);
        if (this.blacklist.remove(uid)) {
            this.saveBlacklist();
        }
    }

    @Override
    public <V> boolean isIngredientOnConfigBlacklist(V ingredient, IIngredientHelper<V> ingredientHelper) {
        for (IngredientBlacklistType ingredientBlacklistType : IngredientBlacklistType.VALUES) {
            if (!this.isIngredientOnConfigBlacklist(ingredient, ingredientBlacklistType, ingredientHelper)) continue;
            return true;
        }
        return false;
    }

    public <V> boolean isIngredientOnConfigBlacklist(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid = EditModeConfig.getIngredientUid(ingredient, blacklistType, ingredientHelper);
        return this.blacklist.contains(uid);
    }

    private static <V> String getIngredientUid(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        switch (blacklistType) {
            case ITEM: {
                return ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient);
            }
            case WILDCARD: {
                return ingredientHelper.getWildcardId(ingredient);
            }
        }
        throw new IllegalStateException("Unknown blacklist type: " + (Object)((Object)blacklistType));
    }
}

