/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.requirement.AbstractPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class PokeBallRequirement
extends AbstractPokemonRequirement<PokeBall> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"ball", "ba"});
    private PokeBall ball;

    public PokeBallRequirement() {
        super(KEYS);
    }

    public PokeBallRequirement(PokeBall ball) {
        this();
        this.ball = ball;
    }

    @Override
    public List<Requirement<Pokemon, PixelmonEntity, ?>> createSimple(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return Collections.emptyList();
        }
        String[] args = spec.split(key + ":");
        if (args.length == 0) {
            return Collections.singletonList(this.createInstance(PokeBallRegistry.POKE_BALL.orElse((PokeBall)null)));
        }
        return Collections.singletonList(this.createInstance(PokeBallRegistry.getPokeBall(args[1]).orElse((PokeBall)null)));
    }

    @Override
    public Requirement<Pokemon, PixelmonEntity, PokeBall> createInstance(PokeBall value) {
        return new PokeBallRequirement(value);
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return Objects.equals(pixelmon.getBall(), this.ball);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        if (this.ball == null) {
            return;
        }
        pixelmon.setBall(this.ball);
    }

    @Override
    public PokeBall getValue() {
        return this.ball;
    }
}

