/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.requirement.AbstractPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokerusStrain;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Pokerus;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class PokerusRequirement
extends AbstractPokemonRequirement<PokerusStrain> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"pokerus", "pkrs"});
    private PokerusStrain pokerus;

    public PokerusRequirement() {
        super(KEYS);
    }

    public PokerusRequirement(PokerusStrain pokerus) {
        this();
        this.pokerus = pokerus;
    }

    @Override
    public List<Requirement<Pokemon, PixelmonEntity, ?>> createSimple(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return Collections.emptyList();
        }
        String[] args = spec.split(key + ":");
        if (args.length == 0) {
            return Collections.singletonList(this.createInstance(PokerusStrain.UNINFECTED));
        }
        return Collections.singletonList(this.createInstance(PokerusStrain.valueOf(args[1].toUpperCase())));
    }

    @Override
    public Requirement<Pokemon, PixelmonEntity, PokerusStrain> createInstance(PokerusStrain value) {
        return new PokerusRequirement(value);
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return Objects.equals((Object)pixelmon.getPokerus().type, (Object)this.pokerus);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.setPokerus(new Pokerus(this.pokerus));
    }

    @Override
    public PokerusStrain getValue() {
        return this.pokerus;
    }
}

