/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.daycare;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.daycare.DayCareDuration;
import com.pixelmonmod.pixelmon.api.daycare.impl.duration.AdditiveDuration;
import com.pixelmonmod.pixelmon.api.daycare.impl.duration.ConstantDuration;
import com.pixelmonmod.pixelmon.api.daycare.impl.duration.MultiplicativeDuration;
import com.pixelmonmod.pixelmon.api.daycare.impl.duration.NegativeDuration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class DayCareDurationRegistry {
    private static final Map<String, Supplier<DayCareDuration>> REGISTERED_DURATION_TYPES = Maps.newHashMap();

    public static <T extends DayCareDuration> void registerDuration(Supplier<T> t) {
        REGISTERED_DURATION_TYPES.put(((DayCareDuration)t.get()).getId().toLowerCase(Locale.ROOT), t);
    }

    public static <T extends DayCareDuration> Optional<T> getDuration(String id) {
        Supplier<DayCareDuration> durationSupplier = REGISTERED_DURATION_TYPES.get(id.toLowerCase(Locale.ROOT));
        if (durationSupplier == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(durationSupplier.get());
    }

    public static List<Supplier<DayCareDuration>> getAllDurations() {
        return Lists.newArrayList(REGISTERED_DURATION_TYPES.values());
    }

    static {
        DayCareDurationRegistry.registerDuration(AdditiveDuration::new);
        DayCareDurationRegistry.registerDuration(NegativeDuration::new);
        DayCareDurationRegistry.registerDuration(MultiplicativeDuration::new);
        DayCareDurationRegistry.registerDuration(ConstantDuration::new);
    }
}

