/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.drops;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.enums.PositionTriState;
import com.pixelmonmod.pixelmon.api.events.drops.CustomDropsEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.custom.drops.CustomDropsOpenPacket;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CustomDropScreenFactory {
    private static final Map<String, Builder> REGISTERED_BUILDERS = Maps.newHashMap();

    @SubscribeEvent
    public void onDropClick(CustomDropsEvent.ClickDrop event) {
        Builder builder = REGISTERED_BUILDERS.get(event.getMnemonic());
        if (builder == null) {
            return;
        }
        if (builder.dropConsumer != null) {
            builder.dropConsumer.accept(event, builder.items.get(event.getIndex()));
        }
    }

    @SubscribeEvent
    public void onScreenClose(CustomDropsEvent.CloseScreen event) {
        Builder builder = REGISTERED_BUILDERS.remove(event.getMnemonic());
        if (builder == null) {
            return;
        }
        if (builder.closeConsumer != null) {
            builder.closeConsumer.accept(event);
        }
    }

    @SubscribeEvent
    public void onButtonClick(CustomDropsEvent.ClickButton event) {
        Builder builder = REGISTERED_BUILDERS.get(event.getMnemonic());
        if (builder == null) {
            return;
        }
        if (builder.buttonConsumer != null) {
            builder.buttonConsumer.accept(event);
        }
    }

    public static String openDropScreen(ServerPlayerEntity player, ITextComponent title, List<ItemStack> items, ITextComponent ... buttons) {
        return CustomDropScreenFactory.openDropScreen(UUID.randomUUID().toString(), player, title, items, buttons);
    }

    public static String openDropScreen(String mnemonic, ServerPlayerEntity player, ITextComponent title, List<ItemStack> items, ITextComponent ... buttons) {
        Builder builder = CustomDropScreenFactory.builder().setMnemonic(mnemonic).setTitle(title).setItems(items);
        for (int i = 0; i < 3; ++i) {
            PositionTriState position = PositionTriState.naturalOrder()[i];
            if (buttons.length <= i) continue;
            builder.setButtonText(position, buttons[i]);
        }
        return builder.sendTo(player);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ITextComponent title) {
        return new Builder().setTitle(title);
    }

    static {
        Pixelmon.EVENT_BUS.register((Object)new CustomDropScreenFactory());
    }

    public static class Builder {
        protected String mnemonic = UUID.randomUUID().toString();
        protected ITextComponent title = null;
        protected List<ItemStack> items = Lists.newArrayList();
        protected final ITextComponent[] buttons = new ITextComponent[]{StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_};
        protected Consumer<CustomDropsEvent.CloseScreen> closeConsumer = null;
        protected Consumer<CustomDropsEvent.ClickButton> buttonConsumer = null;
        protected BiConsumer<CustomDropsEvent.ClickDrop, ItemStack> dropConsumer = null;
        protected boolean escapeCloses = false;

        public Builder setMnemonic(String mnemonic) {
            this.mnemonic = (String)Preconditions.checkNotNull((Object)mnemonic, (Object)"mnemonic");
            return this;
        }

        public Builder setTitle(ITextComponent title) {
            this.title = (ITextComponent)Preconditions.checkNotNull((Object)title, (Object)"title");
            return this;
        }

        public Builder setItems(List<ItemStack> items) {
            Preconditions.checkNotNull(items, (Object)"items");
            this.items = items;
            return this;
        }

        public Builder setItems(ItemStack ... items) {
            return this.setItems(Lists.newArrayList((Object[])items));
        }

        public Builder addItems(Collection<ItemStack> items) {
            for (ItemStack stack : items) {
                Preconditions.checkNotNull((Object)stack, (Object)"stack");
                Preconditions.checkArgument((!stack.func_190926_b() ? 1 : 0) != 0, (Object)"Item stack cannot be empty");
                this.items.add(stack);
            }
            return this;
        }

        public Builder addItems(ItemStack ... items) {
            for (ItemStack stack : items) {
                Preconditions.checkNotNull((Object)stack, (Object)"stack");
                Preconditions.checkArgument((!stack.func_190926_b() ? 1 : 0) != 0, (Object)"Item stack cannot be empty");
                this.items.add(stack);
            }
            return this;
        }

        @Deprecated
        public Builder addItem(ItemStack ... stack) {
            return this.addItems(stack);
        }

        public Builder setButtonText(PositionTriState position, ITextComponent text) {
            Preconditions.checkNotNull((Object)((Object)position), (Object)"position");
            Preconditions.checkNotNull((Object)text, (Object)"text");
            this.buttons[position.ordinal()] = text;
            return this;
        }

        public Builder closeHandler(Consumer<CustomDropsEvent.CloseScreen> closeConsumer) {
            this.closeConsumer = closeConsumer;
            return this;
        }

        public Builder buttonHandler(Consumer<CustomDropsEvent.ClickButton> buttonConsumer) {
            this.buttonConsumer = buttonConsumer;
            return this;
        }

        public Builder dropHandler(BiConsumer<CustomDropsEvent.ClickDrop, ItemStack> dropConsumer) {
            this.dropConsumer = dropConsumer;
            return this;
        }

        public Builder escapeCloses() {
            this.escapeCloses = true;
            return this;
        }

        public Builder escapeDoesNotClose() {
            this.escapeCloses = false;
            return this;
        }

        public String sendTo(ServerPlayerEntity player) {
            REGISTERED_BUILDERS.put(this.mnemonic, this);
            NetworkHelper.sendPacket(player, new CustomDropsOpenPacket(this.mnemonic, this.escapeCloses, this.title, this.items, this.buttons));
            return this.mnemonic;
        }
    }
}

