/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events.screens;

import com.pixelmonmod.pixelmon.items.BadgeCaseItem;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class BadgeCaseEvent
extends Event {
    private final ServerPlayerEntity player;
    private final boolean wasCustom;

    public BadgeCaseEvent(ServerPlayerEntity player, boolean custom) {
        this.player = player;
        this.wasCustom = custom;
    }

    public ServerPlayerEntity getPlayer() {
        return this.player;
    }

    public boolean isCustom() {
        return this.wasCustom;
    }

    @Cancelable
    public static class Swap
    extends BadgeCaseEvent {
        private final int index1;
        private final int index2;

        public Swap(ServerPlayerEntity player, boolean custom, int index1, int index2) {
            super(player, custom);
            this.index1 = index1;
            this.index2 = index2;
        }

        public int getIndex1() {
            return this.index1;
        }

        public int getIndex2() {
            return this.index2;
        }
    }

    @Cancelable
    public static class Remove
    extends BadgeCaseEvent {
        private final int index;

        public Remove(ServerPlayerEntity player, boolean custom, int index) {
            super(player, custom);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        @Nullable
        public ItemStack getStack() {
            ItemStack hand;
            BadgeCaseItem.BadgeCase badgeCase;
            if (this.isCustom() && this.getPlayer().func_184614_ca().func_77973_b() instanceof BadgeCaseItem && (badgeCase = BadgeCaseItem.BadgeCase.readFromItemStack(hand = this.getPlayer().func_184614_ca())) != null && this.index >= 0 && this.index < badgeCase.badges.size()) {
                ItemStack removed = badgeCase.badges.get(this.index);
                return removed != null ? removed : ItemStack.field_190927_a;
            }
            return null;
        }
    }

    @Cancelable
    public static class Register
    extends BadgeCaseEvent {
        public Register(ServerPlayerEntity player, boolean custom) {
            super(player, custom);
        }
    }
}

