/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MoldBreaker;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MyceliumMight;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.NeutralizingGas;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Teravolt;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Turboblaze;
import com.pixelmonmod.pixelmon.api.util.helpers.ReflectionHelper;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;

public class AbilityRegistry {
    private static final Map<String, AbilityData> REGISTERED_ABILITIES = Maps.newConcurrentMap();
    private static final Set<Class<?>> OBJECT_HOLDERS = Sets.newHashSet();
    public static final Optional<Ability> ADAPTABILITY = Optional.empty();
    public static final Optional<Ability> AERILATE = Optional.empty();
    public static final Optional<Ability> AFTERMATH = Optional.empty();
    public static final Optional<Ability> AIR_LOCK = Optional.empty();
    public static final Optional<Ability> ANALYTIC = Optional.empty();
    public static final Optional<Ability> ANGER_POINT = Optional.empty();
    public static final Optional<Ability> ANGER_SHELL = Optional.empty();
    public static final Optional<Ability> ANTICIPATION = Optional.empty();
    public static final Optional<Ability> ARENA_TRAP = Optional.empty();
    public static final Optional<Ability> ARMOR_TAIL = Optional.empty();
    public static final Optional<Ability> AROMA_VEIL = Optional.empty();
    public static final Optional<Ability> AS_ONE = Optional.empty();
    public static final Optional<Ability> AURA_BREAK = Optional.empty();
    public static final Optional<Ability> BAD_DREAMS = Optional.empty();
    public static final Optional<Ability> BALL_FETCH = Optional.empty();
    public static final Optional<Ability> BATTERY = Optional.empty();
    public static final Optional<Ability> BATTLE_ARMOUR = Optional.empty();
    public static final Optional<Ability> BATTLE_BOND = Optional.empty();
    public static final Optional<Ability> BEADS_OF_RUIN = Optional.empty();
    public static final Optional<Ability> BEAST_BOOST = Optional.empty();
    public static final Optional<Ability> BERSERK = Optional.empty();
    public static final Optional<Ability> BIG_PECKS = Optional.empty();
    public static final Optional<Ability> BLAZE = Optional.empty();
    public static final Optional<Ability> BULLETPROOF = Optional.empty();
    public static final Optional<Ability> CHEEK_POUCH = Optional.empty();
    public static final Optional<Ability> CHILLING_NEIGH = Optional.empty();
    public static final Optional<Ability> CHLOROPHYLL = Optional.empty();
    public static final Optional<Ability> CLEAR_BODY = Optional.empty();
    public static final Optional<Ability> CLOUD_NINE = Optional.empty();
    public static final Optional<Ability> COLOR_CHANGE = Optional.empty();
    public static final Optional<Ability> COMATOSE = Optional.empty();
    public static final Optional<Ability> COMING_SOON = Optional.empty();
    public static final Optional<Ability> COMMANDER = Optional.empty();
    public static final Optional<Ability> COMPETITIVE = Optional.empty();
    public static final Optional<Ability> COMPOUND_EYES = Optional.empty();
    public static final Optional<Ability> CONTRARY = Optional.empty();
    public static final Optional<Ability> CORROSION = Optional.empty();
    public static final Optional<Ability> COSTAR = Optional.empty();
    public static final Optional<Ability> COTTON_DOWN = Optional.empty();
    public static final Optional<Ability> CUD_CHEW = Optional.empty();
    public static final Optional<Ability> CURIOUS_MEDICINE = Optional.empty();
    public static final Optional<Ability> CURSED_BODY = Optional.empty();
    public static final Optional<Ability> CUTE_CHARM = Optional.empty();
    public static final Optional<Ability> DAMP = Optional.empty();
    public static final Optional<Ability> DANCER = Optional.empty();
    public static final Optional<Ability> DARK_AURA = Optional.empty();
    public static final Optional<Ability> DAUNTLESS_SHIELD = Optional.empty();
    public static final Optional<Ability> DAZZLING = Optional.empty();
    public static final Optional<Ability> DEFEATIST = Optional.empty();
    public static final Optional<Ability> DEFIANT = Optional.empty();
    public static final Optional<Ability> DELTA_STREAM = Optional.empty();
    public static final Optional<Ability> DESOLATE_LAND = Optional.empty();
    public static final Optional<Ability> DISGUISE = Optional.empty();
    public static final Optional<Ability> DOWNLOAD = Optional.empty();
    public static final Optional<Ability> DRAGONS_MAW = Optional.empty();
    public static final Optional<Ability> DRIZZLE = Optional.empty();
    public static final Optional<Ability> DROUGHT = Optional.empty();
    public static final Optional<Ability> DRY_SKIN = Optional.empty();
    public static final Optional<Ability> EARLY_BIRD = Optional.empty();
    public static final Optional<Ability> EFFECT_SPORE = Optional.empty();
    public static final Optional<Ability> ELECTRIC_SURGE = Optional.empty();
    public static final Optional<Ability> EMERGENCY_EXIT = Optional.empty();
    public static final Optional<Ability> ERROR = Optional.empty();
    public static final Optional<Ability> FAIRY_AURA = Optional.empty();
    public static final Optional<Ability> FILTER = Optional.empty();
    public static final Optional<Ability> FLAME_BODY = Optional.empty();
    public static final Optional<Ability> FLARE_BOOST = Optional.empty();
    public static final Optional<Ability> FLASH_FIRE = Optional.empty();
    public static final Optional<Ability> FLOWER_GIFT = Optional.empty();
    public static final Optional<Ability> FLOWER_VEIL = Optional.empty();
    public static final Optional<Ability> FLUFFY = Optional.empty();
    public static final Optional<Ability> FORECAST = Optional.empty();
    public static final Optional<Ability> FOREWARN = Optional.empty();
    public static final Optional<Ability> FRIEND_GUARD = Optional.empty();
    public static final Optional<Ability> FRISK = Optional.empty();
    public static final Optional<Ability> FULL_METAL_BODY = Optional.empty();
    public static final Optional<Ability> FUR_COAT = Optional.empty();
    public static final Optional<Ability> GALE_WINGS = Optional.empty();
    public static final Optional<Ability> GALVANIZE = Optional.empty();
    public static final Optional<Ability> GLUTTONY = Optional.empty();
    public static final Optional<Ability> GOOD_AS_GOLD = Optional.empty();
    public static final Optional<Ability> GOOEY = Optional.empty();
    public static final Optional<Ability> GORILLA_TACTICS = Optional.empty();
    public static final Optional<Ability> GRASS_PELT = Optional.empty();
    public static final Optional<Ability> GRASSY_SURGE = Optional.empty();
    public static final Optional<Ability> GRIM_NEIGH = Optional.empty();
    public static final Optional<Ability> GUARD_DOG = Optional.empty();
    public static final Optional<Ability> GULP_MISSILE = Optional.empty();
    public static final Optional<Ability> GUTS = Optional.empty();
    public static final Optional<Ability> HADRON_ENGINE = Optional.empty();
    public static final Optional<Ability> HARVEST = Optional.empty();
    public static final Optional<Ability> HEALER = Optional.empty();
    public static final Optional<Ability> HEATPROOF = Optional.empty();
    public static final Optional<Ability> HEAVY_METAL = Optional.empty();
    public static final Optional<Ability> HONEY_GATHER = Optional.empty();
    public static final Optional<Ability> HOSPITALITY = Optional.empty();
    public static final Optional<Ability> HUGE_POWER = Optional.empty();
    public static final Optional<Ability> HUNGER_SWITCH = Optional.empty();
    public static final Optional<Ability> HUSTLE = Optional.empty();
    public static final Optional<Ability> HYDRATION = Optional.empty();
    public static final Optional<Ability> HYPER_CUTTER = Optional.empty();
    public static final Optional<Ability> ICE_BODY = Optional.empty();
    public static final Optional<Ability> ICE_FACE = Optional.empty();
    public static final Optional<Ability> ICE_SCALES = Optional.empty();
    public static final Optional<Ability> ILLUMINATE = Optional.empty();
    public static final Optional<Ability> ILLUSION = Optional.empty();
    public static final Optional<Ability> IMMUNITY = Optional.empty();
    public static final Optional<Ability> IMPOSTER = Optional.empty();
    public static final Optional<Ability> INFILTRATOR = Optional.empty();
    public static final Optional<Ability> INNARDS_OUT = Optional.empty();
    public static final Optional<Ability> INNER_FOCUS = Optional.empty();
    public static final Optional<Ability> INSOMNIA = Optional.empty();
    public static final Optional<Ability> INTIMIDATE = Optional.empty();
    public static final Optional<Ability> INTREPID_SWORD = Optional.empty();
    public static final Optional<Ability> IRON_BARBS = Optional.empty();
    public static final Optional<Ability> IRON_FIST = Optional.empty();
    public static final Optional<Ability> JUSTIFIED = Optional.empty();
    public static final Optional<Ability> KEEN_EYE = Optional.empty();
    public static final Optional<Ability> KLUTZ = Optional.empty();
    public static final Optional<Ability> LEAF_GUARD = Optional.empty();
    public static final Optional<Ability> LEVITATE = Optional.empty();
    public static final Optional<Ability> LIBERO = Optional.empty();
    public static final Optional<Ability> LIGHT_METAL = Optional.empty();
    public static final Optional<Ability> LIGHTNING_ROD = Optional.empty();
    public static final Optional<Ability> LIMBER = Optional.empty();
    public static final Optional<Ability> LINGERING_AROMA = Optional.empty();
    public static final Optional<Ability> LIQUID_OOZE = Optional.empty();
    public static final Optional<Ability> LIQUID_VOICE = Optional.empty();
    public static final Optional<Ability> LONG_REACH = Optional.empty();
    public static final Optional<Ability> MAGIC_BOUNCE = Optional.empty();
    public static final Optional<Ability> MAGIC_GUARD = Optional.empty();
    public static final Optional<Ability> MAGICIAN = Optional.empty();
    public static final Optional<Ability> MAGMA_ARMOR = Optional.empty();
    public static final Optional<Ability> MAGNET_PULL = Optional.empty();
    public static final Optional<Ability> MARVEL_SCALE = Optional.empty();
    public static final Optional<Ability> MEGA_LAUNCHER = Optional.empty();
    public static final Optional<Ability> MERCILESS = Optional.empty();
    public static final Optional<Ability> MIMICRY = Optional.empty();
    public static final Optional<Ability> MINUS = Optional.empty();
    public static final Optional<Ability> MINDS_EYE = Optional.empty();
    public static final Optional<Ability> MIRROR_ARMOR = Optional.empty();
    public static final Optional<Ability> MISTY_SURGE = Optional.empty();
    public static final Optional<Ability> MOLD_BREAKER = Optional.empty();
    public static final Optional<Ability> MOODY = Optional.empty();
    public static final Optional<Ability> MOTOR_DRIVE = Optional.empty();
    public static final Optional<Ability> MOXIE = Optional.empty();
    public static final Optional<Ability> MULTISCALE = Optional.empty();
    public static final Optional<Ability> MULTITYPE = Optional.empty();
    public static final Optional<Ability> MUMMY = Optional.empty();
    public static final Optional<Ability> MYCELIUM_MIGHT = Optional.empty();
    public static final Optional<Ability> NATURAL_CURE = Optional.empty();
    public static final Optional<Ability> NEUROFORCE = Optional.empty();
    public static final Optional<Ability> NEUTRALIZING_GAS = Optional.empty();
    public static final Optional<Ability> NO_GUARD = Optional.empty();
    public static final Optional<Ability> NORMALIZE = Optional.empty();
    public static final Optional<Ability> OBLIVIOUS = Optional.empty();
    public static final Optional<Ability> OPPORTUNIST = Optional.empty();
    public static final Optional<Ability> ORICHALCUM_PULSE = Optional.empty();
    public static final Optional<Ability> OVERCOAT = Optional.empty();
    public static final Optional<Ability> OVERGROW = Optional.empty();
    public static final Optional<Ability> OWN_TEMPO = Optional.empty();
    public static final Optional<Ability> PARENTAL_BOND = Optional.empty();
    public static final Optional<Ability> PASTEL_VEIL = Optional.empty();
    public static final Optional<Ability> PERISH_BODY = Optional.empty();
    public static final Optional<Ability> PICKPOCKET = Optional.empty();
    public static final Optional<Ability> PICKUP = Optional.empty();
    public static final Optional<Ability> PIXILATE = Optional.empty();
    public static final Optional<Ability> PLUS = Optional.empty();
    public static final Optional<Ability> POISON_HEAL = Optional.empty();
    public static final Optional<Ability> POISON_POINT = Optional.empty();
    public static final Optional<Ability> POISON_TOUCH = Optional.empty();
    public static final Optional<Ability> POWER_CONSTRUCT = Optional.empty();
    public static final Optional<Ability> POWER_OF_ALCHEMY = Optional.empty();
    public static final Optional<Ability> POWER_SPOT = Optional.empty();
    public static final Optional<Ability> PRANKSTER = Optional.empty();
    public static final Optional<Ability> PRESSURE = Optional.empty();
    public static final Optional<Ability> PRIMORDIAL_SEA = Optional.empty();
    public static final Optional<Ability> PRISM_ARMOR = Optional.empty();
    public static final Optional<Ability> PROPELLER_TAIL = Optional.empty();
    public static final Optional<Ability> PROTOSYNTHESIS = Optional.empty();
    public static final Optional<Ability> PROTEAN = Optional.empty();
    public static final Optional<Ability> PSYCHIC_SURGE = Optional.empty();
    public static final Optional<Ability> PUNK_ROCK = Optional.empty();
    public static final Optional<Ability> PURE_POWER = Optional.empty();
    public static final Optional<Ability> QUARK_DRIVE = Optional.empty();
    public static final Optional<Ability> PURIFYING_SALT = Optional.empty();
    public static final Optional<Ability> QUEENLY_MAJESTY = Optional.empty();
    public static final Optional<Ability> QUICK_DRAW = Optional.empty();
    public static final Optional<Ability> QUICK_FEET = Optional.empty();
    public static final Optional<Ability> RAIN_DISH = Optional.empty();
    public static final Optional<Ability> RATTLED = Optional.empty();
    public static final Optional<Ability> RECEIVER = Optional.empty();
    public static final Optional<Ability> RECKLESS = Optional.empty();
    public static final Optional<Ability> REFRIGERATE = Optional.empty();
    public static final Optional<Ability> REGENERATOR = Optional.empty();
    public static final Optional<Ability> RIPEN = Optional.empty();
    public static final Optional<Ability> RIVALRY = Optional.empty();
    public static final Optional<Ability> R_K_S_SYSTEM = Optional.empty();
    public static final Optional<Ability> ROCK_HEAD = Optional.empty();
    public static final Optional<Ability> ROCKY_PAYLOAD = Optional.empty();
    public static final Optional<Ability> ROUGH_SKIN = Optional.empty();
    public static final Optional<Ability> RUN_AWAY = Optional.empty();
    public static final Optional<Ability> SAND_FORCE = Optional.empty();
    public static final Optional<Ability> SAND_RUSH = Optional.empty();
    public static final Optional<Ability> SAND_SPIT = Optional.empty();
    public static final Optional<Ability> SAND_STREAM = Optional.empty();
    public static final Optional<Ability> SAND_VEIL = Optional.empty();
    public static final Optional<Ability> SAP_SIPPER = Optional.empty();
    public static final Optional<Ability> SCHOOLING = Optional.empty();
    public static final Optional<Ability> SCRAPPY = Optional.empty();
    public static final Optional<Ability> SCREEN_CLEANER = Optional.empty();
    public static final Optional<Ability> SERENE_GRACE = Optional.empty();
    public static final Optional<Ability> SEED_SOWER = Optional.empty();
    public static final Optional<Ability> SHADOW_SHIELD = Optional.empty();
    public static final Optional<Ability> SHADOW_TAG = Optional.empty();
    public static final Optional<Ability> SHARPNESS = Optional.empty();
    public static final Optional<Ability> SHED_SKIN = Optional.empty();
    public static final Optional<Ability> SHEER_FORCE = Optional.empty();
    public static final Optional<Ability> SHELL_ARMOUR = Optional.empty();
    public static final Optional<Ability> SHIELD_DUST = Optional.empty();
    public static final Optional<Ability> SHIELDS_DOWN = Optional.empty();
    public static final Optional<Ability> SIMPLE = Optional.empty();
    public static final Optional<Ability> SKILL_LINK = Optional.empty();
    public static final Optional<Ability> SLOW_START = Optional.empty();
    public static final Optional<Ability> SLUSH_RUSH = Optional.empty();
    public static final Optional<Ability> SNIPER = Optional.empty();
    public static final Optional<Ability> SNOW_CLOAK = Optional.empty();
    public static final Optional<Ability> SNOW_WARNING = Optional.empty();
    public static final Optional<Ability> SOLAR_POWER = Optional.empty();
    public static final Optional<Ability> SOLID_ROCK = Optional.empty();
    public static final Optional<Ability> SOUL_HEART = Optional.empty();
    public static final Optional<Ability> SOUNDPROOF = Optional.empty();
    public static final Optional<Ability> SPEED_BOOST = Optional.empty();
    public static final Optional<Ability> STAKEOUT = Optional.empty();
    public static final Optional<Ability> STALL = Optional.empty();
    public static final Optional<Ability> STALWART = Optional.empty();
    public static final Optional<Ability> STAMINA = Optional.empty();
    public static final Optional<Ability> STANCE_CHANGE = Optional.empty();
    public static final Optional<Ability> STATIC = Optional.empty();
    public static final Optional<Ability> STEADFAST = Optional.empty();
    public static final Optional<Ability> STEAM_ENGINE = Optional.empty();
    public static final Optional<Ability> STEELWORKER = Optional.empty();
    public static final Optional<Ability> STEELY_SPIRIT = Optional.empty();
    public static final Optional<Ability> STENCH = Optional.empty();
    public static final Optional<Ability> STICKY_HOLD = Optional.empty();
    public static final Optional<Ability> STORM_DRAIN = Optional.empty();
    public static final Optional<Ability> STRONG_JAW = Optional.empty();
    public static final Optional<Ability> STURDY = Optional.empty();
    public static final Optional<Ability> SUCTION_CUPS = Optional.empty();
    public static final Optional<Ability> SUPER_LUCK = Optional.empty();
    public static final Optional<Ability> SUPERSWEET_SYRUP = Optional.empty();
    public static final Optional<Ability> SUPREME_OVERLORD = Optional.empty();
    public static final Optional<Ability> SURGE_SURFER = Optional.empty();
    public static final Optional<Ability> SWARM = Optional.empty();
    public static final Optional<Ability> SWEET_VEIL = Optional.empty();
    public static final Optional<Ability> SWIFT_SWIM = Optional.empty();
    public static final Optional<Ability> SWORD_OF_RUIN = Optional.empty();
    public static final Optional<Ability> SYMBIOSIS = Optional.empty();
    public static final Optional<Ability> SYNCHRONIZE = Optional.empty();
    public static final Optional<Ability> TABLETS_OF_RUIN = Optional.empty();
    public static final Optional<Ability> TANGLED_FEET = Optional.empty();
    public static final Optional<Ability> TANGLING_HAIR = Optional.empty();
    public static final Optional<Ability> TECHNICIAN = Optional.empty();
    public static final Optional<Ability> TELEPATHY = Optional.empty();
    public static final Optional<Ability> TERAVOLT = Optional.empty();
    public static final Optional<Ability> THICK_FAT = Optional.empty();
    public static final Optional<Ability> TINTED_LENS = Optional.empty();
    public static final Optional<Ability> TORRENT = Optional.empty();
    public static final Optional<Ability> TOUGH_CLAWS = Optional.empty();
    public static final Optional<Ability> TOXIC_BOOST = Optional.empty();
    public static final Optional<Ability> TOXIC_CHAIN = Optional.empty();
    public static final Optional<Ability> TOXIC_DEBRIS = Optional.empty();
    public static final Optional<Ability> TRACE = Optional.empty();
    public static final Optional<Ability> TRANSISTOR = Optional.empty();
    public static final Optional<Ability> TRIAGE = Optional.empty();
    public static final Optional<Ability> TRUANT = Optional.empty();
    public static final Optional<Ability> TURBOBLAZE = Optional.empty();
    public static final Optional<Ability> UNAWARE = Optional.empty();
    public static final Optional<Ability> UNBURDEN = Optional.empty();
    public static final Optional<Ability> UNNERVE = Optional.empty();
    public static final Optional<Ability> UNSEEN_FIST = Optional.empty();
    public static final Optional<Ability> VESSEL_OF_RUIN = Optional.empty();
    public static final Optional<Ability> VICTORY_STAR = Optional.empty();
    public static final Optional<Ability> VITAL_SPIRIT = Optional.empty();
    public static final Optional<Ability> VOLT_ABSORB = Optional.empty();
    public static final Optional<Ability> WANDERING_SPIRIT = Optional.empty();
    public static final Optional<Ability> WATER_ABSORB = Optional.empty();
    public static final Optional<Ability> WATER_BUBBLE = Optional.empty();
    public static final Optional<Ability> WATER_COMPACTION = Optional.empty();
    public static final Optional<Ability> WATER_VEIL = Optional.empty();
    public static final Optional<Ability> WEAK_ARMOR = Optional.empty();
    public static final Optional<Ability> WELL_BAKED_BODY = Optional.empty();
    public static final Optional<Ability> WHITE_SMOKE = Optional.empty();
    public static final Optional<Ability> WIMP_OUT = Optional.empty();
    public static final Optional<Ability> WIND_RIDER = Optional.empty();
    public static final Optional<Ability> WIND_POWER = Optional.empty();
    public static final Optional<Ability> WONDER_GUARD = Optional.empty();
    public static final Optional<Ability> WONDER_SKIN = Optional.empty();
    public static final Optional<Ability> ZEN_MODE = Optional.empty();
    public static final Optional<Ability> REVENANT = Optional.empty();

    public static void registerNewObjectHolder(Class<?> clazz) {
        OBJECT_HOLDERS.add(clazz);
    }

    public static void register(String className) {
        try {
            Class<?> clazz = Class.forName(className, true, Pixelmon.class.getClassLoader());
            if (!Ability.class.isAssignableFrom(clazz)) {
                Pixelmon.LOGGER.error("Failed to load ability at `" + className + "`. This class doesn't extend Ability interface");
                return;
            }
            Supplier<Ability> constructor = AbilityRegistry.findConstructor(className, clazz);
            if (constructor == null) {
                return;
            }
            Ability defaultInstance = constructor.get();
            REGISTERED_ABILITIES.put(defaultInstance.getName().toLowerCase(Locale.ROOT), new AbilityData(defaultInstance.getName(), className, constructor, defaultInstance));
            String fieldName = AbilityRegistry.createFieldName(className);
            for (Class<?> objectHolder : OBJECT_HOLDERS) {
                try {
                    Field field = objectHolder.getField(fieldName);
                    field.setAccessible(true);
                    ReflectionHelper.flipVariableFinality(field);
                    field.set(null, Optional.of(defaultInstance));
                    ReflectionHelper.flipVariableFinality(field);
                }
                catch (Exception exception) {}
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            Pixelmon.LOGGER.error("Failed to load ability at `" + className + "`. Skipping load for error:");
            e.printStackTrace();
        }
    }

    private static Supplier<Ability> findConstructor(String className, Class<?> clazz) throws NoSuchMethodException {
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        if (constructor == null) {
            Pixelmon.LOGGER.error("Failed to load ability at `" + className + "`. This class doesn't have an empty constructor!");
            return null;
        }
        return () -> {
            try {
                return (Ability)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                Pixelmon.LOGGER.error("There was an error during construction of " + className);
                e.printStackTrace();
                return null;
            }
        };
    }

    private static String createFieldName(String className) {
        StringBuilder nameBuilder = new StringBuilder();
        String[] split = className.split("\\.");
        char[] chars = split[split.length - 1].toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (i == 0) {
                nameBuilder.append(chars[i]);
                continue;
            }
            char c = chars[i];
            if (Character.isUpperCase(c)) {
                nameBuilder.append("_");
            }
            nameBuilder.append(c);
        }
        return nameBuilder.toString().toUpperCase();
    }

    public static Optional<Ability> getAbility(String name) {
        if (!REGISTERED_ABILITIES.containsKey(name.toLowerCase(Locale.ROOT))) {
            return Optional.empty();
        }
        return Optional.ofNullable(REGISTERED_ABILITIES.get(name.toLowerCase(Locale.ROOT)).getInstance());
    }

    public static Optional<Ability> getNewAbility(String name) {
        AbilityData instance = REGISTERED_ABILITIES.get(name.toLowerCase(Locale.ROOT));
        if (instance == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(instance.getConstructor().get());
    }

    public static boolean ignoreAbility(PixelmonWrapper pokemon, BattleController bc) {
        if (pokemon == null) {
            return false;
        }
        if (bc == null) {
            return pokemon.hasStatus(StatusType.GastroAcid);
        }
        Optional<Ability> optionalNeutralizingGas = bc.getAbilityIfPresent(NeutralizingGas.class);
        if (optionalNeutralizingGas.isPresent() && NeutralizingGas.isAbilityDisabled(pokemon.getBattleAbility(false))) {
            return true;
        }
        return pokemon.hasStatus(StatusType.GastroAcid);
    }

    public static boolean ignoreAbility(PixelmonWrapper user, PixelmonWrapper opponent) {
        if (AbilityRegistry.ignoreAbility(opponent, opponent.bc)) {
            return true;
        }
        if (opponent.getBattleAbility(false) != null && !opponent.getBattleAbility(false).canBeIgnored()) {
            return false;
        }
        if (user == null) {
            return false;
        }
        Ability userAbility = user.getBattleAbility();
        if (user.attack != null && user.attack.getMove().getIgnoresAbilities() && user != opponent) {
            return true;
        }
        return userAbility instanceof MoldBreaker || userAbility instanceof Teravolt || userAbility instanceof Turboblaze || userAbility instanceof MyceliumMight && user.attack != null && user.attack.getAttackCategory().equals((Object)AttackCategory.STATUS);
    }

    public static void writeToBuffer(PacketBuffer buf) {
        buf.writeInt(REGISTERED_ABILITIES.size());
        for (AbilityData ability : REGISTERED_ABILITIES.values()) {
            ability.writeToBuffer(buf);
        }
    }

    public static void readFromBuffer(PacketBuffer buf) {
        AbilityRegistry.reset();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            AbilityRegistry.register(buf.func_218666_n());
        }
    }

    private static void reset() {
        REGISTERED_ABILITIES.clear();
    }

    static {
        AbilityRegistry.registerNewObjectHolder(AbilityRegistry.class);
    }

    public static final class AbilityData {
        private final String name;
        private final String classPath;
        private final Supplier<Ability> constructor;
        private final Ability instance;

        public AbilityData(String name, String classPath, Supplier<Ability> constructor, Ability instance) {
            this.name = name;
            this.classPath = classPath;
            this.constructor = constructor;
            this.instance = instance;
        }

        public String getName() {
            return this.name;
        }

        public Supplier<Ability> getConstructor() {
            return this.constructor;
        }

        public Ability getInstance() {
            return this.instance;
        }

        public void writeToBuffer(PacketBuffer buffer) {
            buffer.func_180714_a(this.classPath);
        }
    }
}

