/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.api.pokemon.requirement.impl.FormRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Sunny;
import com.pixelmonmod.pixelmon.items.HeldItem;

public class Harvest
extends AbstractAbility {
    @Override
    public void applyRepeatedEffect(PixelmonWrapper pokemon) {
        HeldItem consumedItem = pokemon.getConsumedItem();
        if (consumedItem.isBerry() && !pokemon.hasHeldItem() && (pokemon.bc.globalStatusController.getWeather() instanceof Sunny || RandomHelper.getRandomChance(0.5f))) {
            pokemon.setHeldItem(consumedItem);
            pokemon.setConsumedItem(null);
            pokemon.bc.sendToAll("pixelmon.abilities.harvest", pokemon.getNickname(), consumedItem.getLocalizedName());
        }
    }

    @Override
    public float getMultiplier(AbstractSpawner spawner, SpawnInfo spawnInfo, float sum, float rarity) {
        String form;
        Stats stats;
        if (!(spawnInfo instanceof SpawnInfoPokemon)) {
            return 1.0f;
        }
        SpawnInfoPokemon spawnInfoPokemon = (SpawnInfoPokemon)spawnInfo;
        RegistryValue specSpecies = spawnInfoPokemon.getPokemonSpec().getValue(SpeciesRequirement.class).orElse(null);
        if (spawnInfoPokemon.getPokemonSpec() == null || specSpecies == null || !specSpecies.isInitialized()) {
            return 1.0f;
        }
        Species species = spawnInfoPokemon.getSpecies();
        if (species != null && (stats = species.getForm(form = spawnInfoPokemon.getPokemonSpec().getValue(FormRequirement.class).orElse(""))) != null && stats.getTypes().contains(Element.GRASS)) {
            return 5.0f;
        }
        return 1.0f;
    }
}

