/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.Tailwind;
import java.util.Set;

public class WindRider
extends AbstractAbility {
    private Set<String> WIND_ATTACKS = Sets.newHashSet((Object[])new String[]{"Air Cutter", "Bleakwind Storm", "Blizzard", "Fairy Wind", "Gust", "Heat Wave", "Hurricane", "Icy Wind", "Petal Blizzard", "Sandsear Storm", "Sandstorm", "Springtide Storm", "Tailwind", "Twister", "Whirlwind", "Wildbolt Storm"});

    @Override
    public boolean allowsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user, Attack a) {
        if (this.WIND_ATTACKS.contains(a.getMove().getAttackName()) && !a.isAttack(AttackRegistry.TAILWIND) && !a.isAttack(AttackRegistry.SANDSTORM)) {
            pokemon.getBattleStats().increaseStat(1, BattleStatsType.ATTACK, pokemon, false);
            return false;
        }
        return true;
    }

    @Override
    public void onStatusAdded(StatusBase status, PixelmonWrapper user, PixelmonWrapper opponent) {
        if (status instanceof Tailwind) {
            user.getBattleStats().increaseStat(1, BattleStatsType.ATTACK, user, false);
        }
    }
}

