/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.item.pokeball;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.util.ResourceWithFallback;
import java.lang.reflect.Type;

public class PokeBallTypeAdapter
implements JsonSerializer<PokeBall>,
JsonDeserializer<PokeBall> {
    public PokeBall deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        String name = object.get("name").getAsString();
        String model = object.get("model").getAsString();
        ResourceWithFallback texture = (ResourceWithFallback)context.deserialize(object.get("texture"), ResourceWithFallback.class);
        ResourceWithFallback flashingTexture = object.has("flashingTexture") ? (ResourceWithFallback)context.deserialize(object.get("flashingTexture"), ResourceWithFallback.class) : texture;
        ResourceWithFallback ballSprite = (ResourceWithFallback)context.deserialize(object.get("ballSprite"), ResourceWithFallback.class);
        ResourceWithFallback guiSprite = (ResourceWithFallback)context.deserialize(object.get("guiSprite"), ResourceWithFallback.class);
        String logic = object.get("logic").getAsString();
        JsonArray ja = object.getAsJsonArray("bases");
        String[] bases = new String[ja.size()];
        for (int i = 0; i < ja.size(); ++i) {
            bases[i] = ja.get(i).getAsString();
        }
        String captureMethod = object.get("captureMethod").getAsString();
        double catchBonus = object.get("catchBonus").getAsDouble();
        double breakChance = object.get("breakChance").getAsDouble();
        double velocityModifier = object.get("velocityModifier").getAsDouble();
        double gravityModifier = object.get("gravityModifier").getAsDouble();
        boolean particles = object.get("particles").getAsBoolean();
        boolean hasLid = !object.has("hasLid") || object.get("hasLid").getAsBoolean();
        ResourceWithFallback lidSprite = null;
        if (hasLid) {
            lidSprite = (ResourceWithFallback)context.deserialize(object.get("lidSprite"), ResourceWithFallback.class);
        }
        return new PokeBall(name, model, texture, flashingTexture, ballSprite, lidSprite, guiSprite, logic, bases, captureMethod, catchBonus, breakChance, velocityModifier, gravityModifier, particles, hasLid, json.toString());
    }

    public JsonElement serialize(PokeBall pokeball, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("name", pokeball.getName());
        object.addProperty("model", pokeball.getModel());
        object.add("texture", context.serialize((Object)pokeball.getModelTexture()));
        object.add("flashingTexture", context.serialize((Object)pokeball.getFlashingTexture()));
        object.add("ballSprite", context.serialize((Object)pokeball.getBallSprite()));
        object.add("lidSprite", context.serialize((Object)pokeball.getLidSprite()));
        object.add("guiSprite", context.serialize((Object)pokeball.getGUISprite()));
        object.addProperty("logic", pokeball.getLogicPath());
        JsonArray ja = new JsonArray();
        for (String base : pokeball.getBases()) {
            ja.add(base);
        }
        object.add("bases", (JsonElement)ja);
        object.addProperty("captureMethod", pokeball.getCaptureMethodID());
        object.addProperty("catchBonus", (Number)pokeball.getCatchBonus());
        object.addProperty("breakChance", (Number)pokeball.getBreakChance());
        object.addProperty("velocityModifier", (Number)pokeball.getVelocityModifier());
        object.addProperty("gravityModifier", (Number)pokeball.getGravityModifier());
        object.addProperty("particles", Boolean.valueOf(pokeball.hasParticles()));
        object.addProperty("hasLid", Boolean.valueOf(pokeball.hasLid()));
        return object;
    }
}

