/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexEntry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Pokedex {
    public static final Map<Integer, PokedexEntry> FULL_POKEDEX = new HashMap<Integer, PokedexEntry>();
    public static int pokedexSize;
    public static Species[] actualPokedex;

    public static void resetPokedex() {
        FULL_POKEDEX.clear();
        pokedexSize = 0;
        actualPokedex = null;
        int pokeDexSize = 0;
        ArrayList species = Lists.newArrayList();
        for (Species pokemon : PixelmonSpecies.getAll()) {
            if (pokemon.hasFlaggedForm(false, "undexable") || !PixelmonConfigProxy.getSpawning().isGenerationEnabled(pokemon.getGeneration()) || pokemon.is(PixelmonSpecies.MISSINGNO)) continue;
            ++pokeDexSize;
            species.add(pokemon);
        }
        pokedexSize = pokeDexSize;
        actualPokedex = species.toArray(new Species[0]);
    }

    public static void loadPokedex() {
        for (Species pokemon : PixelmonSpecies.getAll()) {
            if (pokemon.hasFlaggedForm(false, "undexable")) continue;
            Stats bs = pokemon.getDefaultForm();
            if (!PixelmonConfigProxy.getSpawning().isGenerationEnabled(pokemon.getGeneration())) continue;
            if (bs == null) {
                Pixelmon.LOGGER.error("Null stats! " + pokemon.getName());
                continue;
            }
            FULL_POKEDEX.put(pokemon.getDex(), new PokedexEntry(pokemon.getDex(), pokemon.getLocalizedName(), bs.getWeight(), (float)bs.getDimensions().getHeight()));
        }
        PixelmonSpecies.MISSINGNO.ifInitialized(species -> FULL_POKEDEX.remove(species.getDex()));
    }

    public static int nameToID(String name) {
        RegistryValue<Species> optional = PixelmonSpecies.fromName(name);
        return optional.map(Species::getDex).orElse(0);
    }

    public static boolean isEntryEmpty(int i) {
        if (!FULL_POKEDEX.containsKey(i)) {
            return true;
        }
        String checkName = FULL_POKEDEX.get(i).getName();
        return checkName.equals("???") || !PixelmonSpecies.fromName(checkName).isInitialized();
    }
}

