/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ExperienceGroup;
import com.pixelmonmod.pixelmon.api.pokemon.egg.EggGroup;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.abilities.Abilities;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.AggressionChances;
import com.pixelmonmod.pixelmon.api.pokemon.species.dimensions.Dimensions;
import com.pixelmonmod.pixelmon.api.pokemon.species.evs.EVYields;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.gimmick.Gigantamax;
import com.pixelmonmod.pixelmon.api.pokemon.species.moves.Moves;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.Movement;
import com.pixelmonmod.pixelmon.api.pokemon.species.spawn.SpawnData;
import com.pixelmonmod.pixelmon.api.pokemon.species.stat.ImmutableBattleStats;
import com.pixelmonmod.pixelmon.api.pokemon.species.tags.FormTags;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.LevelCondition;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;

public class Stats
implements ITranslatable,
Cloneable {
    private transient Species parent;
    protected String name;
    protected String translationKey = "";
    protected ExperienceGroup experienceGroup;
    protected Dimensions dimensions;
    protected Moves moves;
    protected Abilities abilities;
    protected Movement movement;
    protected AggressionChances aggression;
    protected ImmutableBattleStats battleStats;
    protected FormTags tags;
    protected SpawnData spawn;
    protected EVYields evYields = new EVYields();
    protected ImmutableList<Gender> possibleGenders;
    protected ImmutableList<GenderProperties> genderProperties;
    protected ImmutableList<EggGroup> eggGroups;
    protected ImmutableList<Element> types;
    protected ImmutableList<Evolution> evolutions;
    protected ImmutableList<RegistryValue<Species>> preEvolutions;
    protected String defaultBaseForm;
    protected ImmutableList<String> megaItems;
    protected ImmutableList<String> megas;
    protected Gigantamax gigantamax;
    protected int eggCycles;
    protected float weight;
    protected int catchRate;
    protected float malePercentage;
    public transient int minLevel = 1;
    public transient int maxLevel = PixelmonServerConfig.maxLevel;

    public Stats clone() {
        try {
            Stats stats = (Stats)super.clone();
            stats.name = this.name;
            stats.translationKey = this.translationKey;
            stats.experienceGroup = this.experienceGroup;
            stats.dimensions = this.dimensions;
            stats.moves = this.moves;
            stats.abilities = this.abilities;
            stats.movement = this.movement;
            stats.aggression = this.aggression;
            stats.battleStats = this.battleStats;
            stats.tags = this.tags;
            stats.spawn = this.spawn;
            stats.evYields = this.evYields;
            stats.possibleGenders = this.possibleGenders;
            stats.genderProperties = this.genderProperties;
            stats.eggGroups = this.eggGroups;
            stats.types = this.types;
            stats.preEvolutions = this.preEvolutions;
            stats.defaultBaseForm = this.defaultBaseForm;
            stats.megaItems = this.megaItems;
            stats.megas = this.megas;
            stats.eggCycles = this.eggCycles;
            stats.weight = this.weight;
            stats.catchRate = this.catchRate;
            stats.malePercentage = this.malePercentage;
            return stats;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isForm(String ... forms) {
        for (String form : forms) {
            if (!this.getName().equalsIgnoreCase(form) && (!this.getName().isEmpty() || !form.equalsIgnoreCase("base"))) continue;
            return true;
        }
        return false;
    }

    public GenderProperties getGenderProperties(Gender gender) {
        GenderProperties noneProperty = null;
        for (GenderProperties genderProperty : this.genderProperties) {
            if (Objects.equals(gender, genderProperty.getGender())) {
                return genderProperty;
            }
            if (!Objects.equals(genderProperty.getGender(), Gender.NONE)) continue;
            noneProperty = genderProperty;
        }
        return noneProperty;
    }

    public List<Gender> getPossibleGenders() {
        return this.possibleGenders;
    }

    public boolean isPossibleGender(Gender gender) {
        for (Gender possibleGender : this.possibleGenders) {
            if (!Objects.equals(possibleGender, gender)) continue;
            return true;
        }
        return false;
    }

    public boolean isTemporary() {
        return this.tags.isTemporary();
    }

    public ImmutableBattleStats getBattleStats() {
        return this.battleStats;
    }

    public ExperienceGroup getExperienceGroup() {
        return this.experienceGroup;
    }

    public void calculateMinMaxLevels() {
        this.maxLevel = this.getHighestFeasibleLevel();
        if (this.maxLevel == -1) {
            this.maxLevel = PixelmonServerConfig.maxLevel;
        }
        this.minLevel = 1;
        if (this.preEvolutions != null && this.preEvolutions.size() > 0) {
            for (RegistryValue preEvo : this.preEvolutions) {
                if (!preEvo.getValue().isPresent()) {
                    System.out.println("Error with pre evo: " + preEvo.getKey());
                    continue;
                }
                int level = ((Species)preEvo.getValueUnsafe()).getDefaultForm().getHighestFeasibleLevel();
                if (level <= this.minLevel) continue;
                this.minLevel = level;
            }
        }
        if (this.maxLevel < this.minLevel) {
            this.minLevel = this.maxLevel;
        }
    }

    public int getHighestFeasibleLevel() {
        int maxLevel = -1;
        if (!this.getEvolutions().isEmpty()) {
            for (Evolution evolution : this.getEvolutions()) {
                int level;
                if (evolution == null) continue;
                if (evolution instanceof LevelingEvolution && (level = ((LevelingEvolution)evolution).getPokemonLevel()) > maxLevel) {
                    maxLevel = level;
                }
                for (LevelCondition condition : evolution.getConditionsOfType(LevelCondition.class)) {
                    if (condition.level <= maxLevel) continue;
                    maxLevel = condition.level;
                }
            }
        }
        return maxLevel;
    }

    public Moves getMoves() {
        return this.moves;
    }

    public FormTags getTags() {
        return this.tags;
    }

    public List<Element> getTypes() {
        return this.types;
    }

    public boolean hasType(Element ... types) {
        for (Element type : types) {
            if (!this.types.contains((Object)type)) continue;
            return true;
        }
        return false;
    }

    public Gigantamax getGigantamax() {
        return this.gigantamax;
    }

    public boolean hasMegaForm() {
        return !this.megas.isEmpty();
    }

    public boolean hasGigantamaxForm() {
        return this.gigantamax.canGigantamax();
    }

    public List<Item> getMegaItems() {
        ArrayList items = Lists.newArrayList();
        for (String s : this.megaItems) {
            items.add(s.isEmpty() ? null : (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)s)));
        }
        return items;
    }

    public Optional<Stats> getMegaForm(Item item) {
        int index = 0;
        for (Item i : this.getMegaItems()) {
            if (i == null || i == item) {
                return Optional.of(this.getMegaForms().get(index));
            }
            ++index;
        }
        return Optional.empty();
    }

    public List<Stats> getMegaForms() {
        ArrayList stats = Lists.newArrayList();
        for (String s : this.megas) {
            stats.add(this.parent.getForm(s));
        }
        return stats;
    }

    public Optional<Stats> getGigantamaxForm() {
        return Optional.ofNullable(this.gigantamax.canGigantamax() ? this.parent.getForm(this.gigantamax.getForm()) : null);
    }

    public Stats getRandomMegaForm() {
        return this.parent.getForm(RandomHelper.getRandomElementFromCollection(this.megas));
    }

    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public Abilities getAbilities() {
        return this.abilities;
    }

    public float getWeight() {
        return this.weight;
    }

    public List<EggGroup> getEggGroups() {
        return this.eggGroups;
    }

    @Override
    public String getTranslationKey() {
        if (!this.translationKey.isEmpty()) {
            return this.translationKey;
        }
        if (this.isTemporary() || this.isForm("alolan", "galarian", "hisuian", "paldean")) {
            return "pixelmon.generic.form." + this.name;
        }
        if (this.name.isEmpty()) {
            return "pixelmon.generic.form.noform";
        }
        return "pixelmon." + this.parent.getName().toLowerCase(Locale.ROOT) + ".form." + this.name;
    }

    @Override
    public String getLocalizedName() {
        String string = new TranslationTextComponent(this.getTranslationKey()).getString();
        if (string.isEmpty()) {
            return "Default";
        }
        return string;
    }

    @Override
    public TranslationTextComponent getTranslatedName() {
        return ITranslatable.super.getTranslatedName();
    }

    protected void setParentSpecies(Species parent) {
        this.parent = parent;
    }

    public Species getParentSpecies() {
        return this.parent;
    }

    public boolean is(String ... names) {
        for (String s : names) {
            if (!this.name.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public boolean is(Stats ... forms) {
        return this.is(false, forms);
    }

    public boolean is(boolean speciesEquality, Stats ... forms) {
        for (Stats form : forms) {
            if (speciesEquality && !this.getParentSpecies().is(form.getParentSpecies()) || !this.name.equalsIgnoreCase(form.name)) continue;
            return true;
        }
        return false;
    }

    public List<Evolution> getEvolutions() {
        if (this.evolutions == null) {
            this.evolutions = ImmutableList.of();
        }
        return this.evolutions;
    }

    public <T extends EvoCondition> Optional<T> getFirstEvolutionConditionOfType(Class<T> type) {
        for (Evolution evolution : this.getEvolutions()) {
            for (EvoCondition condition : evolution.conditions) {
                if (!type.isInstance(condition)) continue;
                return Optional.of(condition);
            }
        }
        return Optional.empty();
    }

    public void registerModels() {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            return;
        }
        for (GenderProperties gp : this.genderProperties) {
            for (PaletteProperties pp : gp.getPalettes()) {
                if (pp == null) {
                    Pixelmon.LOGGER.error("PaletteProperties null in stats file! " + this.parent.getName() + ", form " + (this.getName().isEmpty() ? "base" : this.getName()));
                    continue;
                }
                if (pp.getModelLocators() == null || pp.getModelLocators().length == 0) {
                    Pixelmon.LOGGER.error("ModelLocator null in stats file! " + this.parent.getName() + ", form " + (this.getName().isEmpty() ? "base" : this.getName()));
                    continue;
                }
                pp.initModels();
            }
        }
    }

    public boolean isDefault() {
        return this.getParentSpecies().isDefaultForm(this);
    }

    public Movement getMovement() {
        return this.movement;
    }

    public AggressionChances getAggression() {
        return this.aggression;
    }

    public SpawnData getSpawn() {
        return this.spawn;
    }

    public int getEggCycles() {
        return this.eggCycles;
    }

    public float getHoverHeight() {
        return this.dimensions.getHoverHeight();
    }

    public int getCatchRate() {
        return this.catchRate;
    }

    public float getMalePercentage() {
        return this.malePercentage;
    }

    public boolean isFemaleOnly() {
        return this.malePercentage == 0.0f;
    }

    public boolean isMaleOnly() {
        return this.malePercentage == 100.0f;
    }

    public boolean isGenderless() {
        return this.malePercentage < 0.0f;
    }

    public String getDefaultBaseForm() {
        return this.defaultBaseForm;
    }

    public EVYields getEVYields() {
        return this.evYields.copy();
    }

    public Gender getDefaultGender() {
        return Gender.getRandomGender(this);
    }

    public GenderProperties getDefaultGenderProperties() {
        return this.getGenderProperties(this.getDefaultGender());
    }

    public Gender getFirstGender() {
        return this.possibleGenders.isEmpty() ? Gender.NONE : (Gender)this.possibleGenders.get(0);
    }

    public GenderProperties getFirstGenderProperties() {
        return (GenderProperties)this.genderProperties.get(0);
    }

    public List<GenderProperties> getGenderProperties() {
        return this.genderProperties;
    }

    public Species getBaseEvolution() {
        if (this.preEvolutions == null || this.preEvolutions.isEmpty()) {
            return this.parent;
        }
        RegistryValue<Species> preEvolution = CollectionHelper.getRandomElement(this.preEvolutions);
        while (preEvolution.getValueUnsafe().getDefaultForm().preEvolutions != null && !preEvolution.getValueUnsafe().getDefaultForm().preEvolutions.isEmpty()) {
            preEvolution = CollectionHelper.getRandomElement(preEvolution.getValueUnsafe().getDefaultForm().preEvolutions);
        }
        return preEvolution.getValueUnsafe();
    }

    public List<Species> getPreEvolutions() {
        ArrayList species = Lists.newArrayList();
        for (RegistryValue preEvolution : this.preEvolutions) {
            preEvolution.getValue().ifPresent(species::add);
        }
        return species;
    }

    public boolean isRegional() {
        return this.isGalarian() || this.isAlolan() || this.isHisuian() || this.isPaldean();
    }

    public boolean isGalarian() {
        return this.tags.isGalarian();
    }

    public boolean isAlolan() {
        return this.tags.isAlolan();
    }

    public boolean isHisuian() {
        return this.tags.isHisuian();
    }

    public boolean isPaldean() {
        return this.tags.isPaldean();
    }

    public String getRegionalTag() {
        return this.tags.getRegionalTag();
    }

    public boolean hasTag(String ... tags) {
        return this.tags.hasTags(tags);
    }

    public boolean hasChild(Species species) {
        if (this.getParentSpecies().is(species)) {
            return true;
        }
        for (Species preEvolution : this.getPreEvolutions()) {
            if (!preEvolution.is(species)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Stats)) {
            return false;
        }
        return ((Stats)obj).name.equals(this.name);
    }

    public String toString() {
        return "Stats@" + Integer.toHexString(this.hashCode()) + "{name=" + this.name + ",parent=" + this.getParentSpecies() + "}";
    }
}

