/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.tags;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;

public class FormTags {
    private final Set<String> tags;
    private final Set<String> regionalTags = Sets.newHashSet((Object[])new String[]{"alolan", "galarian", "hisuian", "paldean"});

    public FormTags(Set<String> tags) {
        this.tags = tags;
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public String getRegionalTag() {
        for (String tag : this.regionalTags) {
            if (!this.hasTag(tag)) continue;
            return tag;
        }
        return null;
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public boolean hasTags(String ... tags) {
        for (String tag : tags) {
            if (!this.hasTag(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean isLegendary() {
        return this.isLegendary(false);
    }

    public boolean isLegendary(boolean excludeMythicals) {
        return this.tags.contains("legendary") || !excludeMythicals && this.isMythical();
    }

    public boolean isMythical() {
        return this.tags.contains("mythical");
    }

    public boolean isUltraBeast() {
        return this.tags.contains("ultrabeast");
    }

    public boolean isAlolan() {
        return this.tags.contains("alolan");
    }

    public boolean isGalarian() {
        return this.tags.contains("galarian");
    }

    public boolean isHisuian() {
        return this.tags.contains("hisuian");
    }

    public boolean isPaldean() {
        return this.tags.contains("paldean");
    }

    public boolean isTemporary() {
        return this.tags.contains("temp");
    }
}

