/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.ControlledMovementLogic;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.Movement;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.RidingOffsets;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.flying.FlyingParameters;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.swimming.SwimmingParameters;
import java.lang.reflect.Type;

public class MovementTypeAdapter
implements JsonSerializer<Movement>,
JsonDeserializer<Movement> {
    public Movement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        boolean rideable = object.get("rideable").getAsBoolean();
        boolean canFly = object.get("canFly").getAsBoolean();
        boolean canSurf = object.get("canSurf").getAsBoolean();
        boolean canRideShoulder = object.get("canRideShoulder").getAsBoolean();
        RidingOffsets ridingOffsets = (RidingOffsets)context.deserialize(object.get("ridingOffsets"), RidingOffsets.class);
        SwimmingParameters swimmingParameters = (SwimmingParameters)context.deserialize(object.get("swimmingParameters"), SwimmingParameters.class);
        FlyingParameters flyingParameters = (FlyingParameters)context.deserialize(object.get("flyingParameters"), FlyingParameters.class);
        ControlledMovementLogic flyingMovementLogic = null;
        if (object.has("mountedFlyingParameters")) {
            DataResult mountedFlyingParameters = ControlledMovementLogic.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("mountedFlyingParameters"));
            ControlledMovementLogic result = mountedFlyingParameters.result().orElse(null);
            if (result != null) {
                flyingMovementLogic = result;
            } else {
                Pixelmon.LOGGER.error("There was an error reading flying movement logic: " + ((DataResult.PartialResult)mountedFlyingParameters.error().get()).message());
            }
        }
        return new Movement(rideable, canFly, canSurf, canRideShoulder, ridingOffsets, swimmingParameters, flyingParameters, flyingMovementLogic);
    }

    public JsonElement serialize(Movement src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("rideable", Boolean.valueOf(src.isRideable()));
        object.addProperty("canFly", Boolean.valueOf(src.canFly()));
        object.addProperty("canSurf", Boolean.valueOf(src.canSurf()));
        object.addProperty("canRideShoulder", Boolean.valueOf(src.canRideShoulder()));
        object.add("ridingOffsets", context.serialize((Object)src.getRidingOffsets()));
        object.add("swimmingParameters", context.serialize((Object)src.getSwimmingParameters()));
        object.add("flyingParameters", context.serialize((Object)src.getFlyingParameters()));
        object.add("mountedFlyingParameters", context.serialize((Object)src.getMountedFlyingParameters()));
        return object;
    }
}

