/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.api.pokemon.species.spawn.SpawnData;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class SpawnDataTypeAdapter
implements JsonSerializer<SpawnData>,
JsonDeserializer<SpawnData> {
    public SpawnData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        int baseExp = jsonObject.get("baseExp").getAsInt();
        int baseFriendship = jsonObject.get("baseFriendship").getAsInt();
        int spawnLevel = jsonObject.get("spawnLevel").getAsInt();
        int spawnLevelRange = jsonObject.get("spawnLevelRange").getAsInt();
        ArrayList spawnLocations = Lists.newArrayList();
        for (JsonElement element : jsonObject.get("spawnLocations").getAsJsonArray()) {
            spawnLocations.add(SpawnLocationType.valueOf(element.getAsString()));
        }
        return new SpawnData(baseExp, baseFriendship, spawnLevel, spawnLevelRange, spawnLocations.toArray(new SpawnLocationType[0]));
    }

    public JsonElement serialize(SpawnData src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("baseExp", (Number)src.getBaseExp());
        jsonObject.addProperty("baseFriendship", (Number)src.getBaseFriendship());
        jsonObject.addProperty("spawnLevel", (Number)src.getSpawnLevel());
        jsonObject.addProperty("spawnLevelRange", (Number)src.getSpawnLevelRange());
        JsonArray array = new JsonArray();
        for (SpawnLocationType spawnLocation : src.getSpawnLocations()) {
            array.add(spawnLocation.name());
        }
        jsonObject.add("spawnLocations", (JsonElement)array);
        return jsonObject;
    }
}

