/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.replacement;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.replacement.SpawnDetectionLogic;
import com.pixelmonmod.pixelmon.api.replacement.detection.SimpleDetectionLogic;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class ReplacementDetectionRegistry {
    public static final Map<String, Supplier<SpawnDetectionLogic>> REPLACEMENT_DETECTION_LOGIC = Maps.newHashMap();

    public static <T extends SpawnDetectionLogic> Optional<T> get(String type) {
        Supplier<SpawnDetectionLogic> supplier = REPLACEMENT_DETECTION_LOGIC.get(type.toLowerCase());
        if (supplier == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(supplier.get());
    }

    public static void register(Supplier<? extends SpawnDetectionLogic> detectionLogic) {
        REPLACEMENT_DETECTION_LOGIC.put(detectionLogic.get().getId().toLowerCase(), detectionLogic);
    }

    static {
        ReplacementDetectionRegistry.register(SimpleDetectionLogic::new);
    }
}

