/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns;

import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.calculators.CheckSpawns;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.entities.projectiles.HookEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class FishingCheckSpawns
implements CheckSpawns {
    @Override
    public String getPermissionNode() {
        return "pixelmon.checkspawns.fishing";
    }

    @Override
    public void checkSpawns(AbstractSpawner spawner, CommandSource sender, List<String> arguments) {
        ServerPlayerEntity target = null;
        if (!(sender.func_197022_f() instanceof ServerPlayerEntity)) {
            PlayerList playerList = ServerLifecycleHooks.getCurrentServer().func_184103_al();
            for (String argument : arguments) {
                if (!spawner.name.equals(argument) && (target = playerList.func_152612_a(argument)) != null) break;
            }
            if (target == null) {
                sender.func_197030_a((ITextComponent)TextHelper.translate(TextFormatting.RED, "spawning.error.mustbeplayer"), false);
                return;
            }
        }
        if (target == null) {
            target = (ServerPlayerEntity)sender.func_197022_f();
        }
        if (!(target.field_71104_cf instanceof HookEntity)) {
            sender.func_197030_a((ITextComponent)TextHelper.translate(TextFormatting.RED, "spawning.error.notfishing", target.func_200200_C_()), false);
            return;
        }
        SpawnLocation spawnLocation = ((HookEntity)target.field_71104_cf).createSpawnLocation();
        ServerLifecycleHooks.getCurrentServer().execute(() -> {
            List<SpawnInfo> spawns = spawner.getSuitableSpawns(spawnLocation);
            if (spawnLocation.diameter == 0) {
                spawns.clear();
            }
            HashMap<SpawnLocation, List<SpawnInfo>> possibleSpawns = new HashMap<SpawnLocation, List<SpawnInfo>>();
            possibleSpawns.put(spawnLocation, spawns);
            Map<String, Double> percentages = spawner.selectionAlgorithm.getPercentages(spawner, possibleSpawns);
            List<IFormattableTextComponent> messages = this.generateMessages(percentages, arguments);
            messages.add(0, TextHelper.translate(TextFormatting.AQUA, "spawning.checkspawns.possiblespawns"));
            for (IFormattableTextComponent message : messages) {
                sender.func_197030_a((ITextComponent)message, false);
            }
        });
    }
}

