/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.calculators.CheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.util.SpatialData;
import com.pixelmonmod.pixelmon.api.spawning.util.SpawningHeightmap;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.WorldHelper;
import com.pixelmonmod.pixelmon.api.world.MutableLocation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class RayTraceCheckSpawns
implements CheckSpawns {
    public String node;
    public LocationType locationType;
    public Predicate<BlockState> isValidBlock;

    public RayTraceCheckSpawns(LocationType locationType, Predicate<BlockState> isValidBlock, String node) {
        this.locationType = locationType;
        this.isValidBlock = isValidBlock;
        this.node = node;
    }

    @Override
    public String getPermissionNode() {
        return this.node;
    }

    @Override
    public void checkSpawns(AbstractSpawner spawner, CommandSource sender, List<String> arguments) {
        RayTraceResult result;
        ServerPlayerEntity target = null;
        if (!(sender.func_197022_f() instanceof ServerPlayerEntity)) {
            PlayerList playerList = ServerLifecycleHooks.getCurrentServer().func_184103_al();
            for (String argument : arguments) {
                if (!spawner.name.equals(argument) && (target = playerList.func_152612_a(argument)) != null) break;
            }
            if (target == null) {
                sender.func_197030_a((ITextComponent)TextHelper.translate(TextFormatting.RED, "spawning.error.mustbeplayer"), false);
                return;
            }
        }
        if (target == null) {
            target = (ServerPlayerEntity)sender.func_197022_f();
        }
        if ((result = WorldHelper.rayTraceEyes(target, 5.0)) == null || result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            sender.func_197030_a((ITextComponent)TextHelper.translate(TextFormatting.RED, "spawning.error.notlookingatblock", target.func_200200_C_()), false);
            return;
        }
        BlockPos hitPos = new BlockPos(result.func_216347_e());
        if (this.isValidBlock != null && !this.isValidBlock.test(target.func_71121_q().func_180495_p(hitPos))) {
            sender.func_197030_a((ITextComponent)TextHelper.translate(TextFormatting.RED, "spawning.error.invalidblock"), false);
            return;
        }
        SpatialData data = spawner.calculateSpatialData((World)target.func_71121_q(), hitPos, 10, true, b -> true);
        SpawnLocation spawnLocation = new SpawnLocation((Entity)target, new MutableLocation((World)target.func_71121_q(), hitPos), Sets.newHashSet((Object[])new LocationType[]{this.locationType}), data.baseBlock, data.uniqueSurroundingBlocks, target.func_71121_q().func_226691_t_(hitPos), SpawningHeightmap.canSeeSky(hitPos, (World)target.func_71121_q()), 6, 0);
        sender.func_197028_i().execute(() -> {
            List<SpawnInfo> spawns = spawner.getSuitableSpawns(spawnLocation);
            HashMap<SpawnLocation, List<SpawnInfo>> possibleSpawns = new HashMap<SpawnLocation, List<SpawnInfo>>();
            possibleSpawns.put(spawnLocation, spawns);
            Map<String, Double> percentages = spawner.selectionAlgorithm.getPercentages(spawner, possibleSpawns);
            List<IFormattableTextComponent> messages = this.generateMessages(percentages, arguments);
            messages.add(0, TextHelper.translate(TextFormatting.AQUA, "spawning.checkspawns.possiblespawns"));
            messages.forEach(msg -> sender.func_197030_a((ITextComponent)msg, false));
        });
    }
}

