/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.requirement.impl.AbilityRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.HiddenAbilityRequirement;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.spawning.LegendarySpawnEvent;
import com.pixelmonmod.pixelmon.api.item.JsonItemStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SuperLuck;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BonusStats;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.group.GroupSpawnSettings;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.group.GroupSpawningFactory;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.BiomeHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.LureItem;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class SpawnActionPokemon
extends SpawnAction<PixelmonEntity> {
    public Pokemon pokemon;
    public BossTier bossTier;

    public SpawnActionPokemon(SpawnInfoPokemon spawnInfo, SpawnLocation spawnLocation, Pokemon pokemon, BossTier bossTier) {
        super(spawnInfo, spawnLocation);
        this.pokemon = pokemon;
        this.bossTier = bossTier;
    }

    @Override
    protected PixelmonEntity createEntity() {
        SpawnInfoPokemon spawnInfo = (SpawnInfoPokemon)this.spawnInfo;
        try {
            PokemonSpecification spec;
            double haMultiplier = 1.0;
            if (this.spawnLocation.cause instanceof ServerPlayerEntity) {
                PlayerPartyStorage party = StorageProxy.getParty(this.spawnLocation.cause.func_110124_au());
                List<Pokemon> team = party.getTeam();
                if (team.size() > 0 && team.get(0).getHeldItemAsItemHeld().getHeldItemType() == EnumHeldItems.cleanseTag && RandomHelper.getRandomChance(0.33333334f)) {
                    return null;
                }
                if (party.getLure() != null && party.getLure().type == LureItem.LureType.HA) {
                    haMultiplier *= Math.sqrt(party.getLure().strength.multiplier);
                }
            }
            if (!(spec = spawnInfo.getPokemonSpec()).getValue(AbilityRequirement.class).isPresent() && !spec.getValue(HiddenAbilityRequirement.class).isPresent()) {
                boolean shouldHaveHiddenAbility = RandomHelper.getRandomChance(haMultiplier / (double)PixelmonConfigProxy.getSpawning().getHiddenAbilityRate((RegistryKey<World>)this.spawnLocation.location.world.func_234923_W_()));
                if (shouldHaveHiddenAbility && this.pokemon.getForm().getAbilities().hasHiddenAbilities()) {
                    this.pokemon.setAbility(this.pokemon.getForm().getAbilities().getRandomHiddenAbility());
                } else {
                    this.pokemon.setAbility(this.pokemon.getForm().getAbilities().getRandomAbility());
                }
                this.pokemon.overrideAbilitySlot();
            }
            PixelmonEntity pixelmon = new PixelmonEntity(this.spawnLocation.location.world, this.pokemon);
            pixelmon.setBossTier(this.bossTier);
            if (spawnInfo.locationTypes.contains(LocationType.AIR)) {
                pixelmon.setSpawnLocation(SpawnLocationType.AIR_PERSISTENT);
            } else if (CollectionHelper.anyMatch(this.spawnLocation.types, Arrays.asList(LocationType.WATER, LocationType.UNDERGROUND_WATER, LocationType.SURFACE_WATER, LocationType.SEAFLOOR, LocationType.LAVA, LocationType.SURFACE_LAVA, LocationType.UNDERGROUND_LAVA, LocationType.OLD_ROD_LAVA, LocationType.GOOD_ROD_LAVA, LocationType.SUPER_ROD_LAVA, LocationType.OLD_ROD, LocationType.GOOD_ROD, LocationType.SUPER_ROD, LocationType.OAS_ROD))) {
                pixelmon.setSpawnLocation(SpawnLocationType.WATER);
            } else {
                pixelmon.setSpawnLocation(SpawnLocationType.LAND);
            }
            pixelmon.resetAI();
            if (spawnInfo.heldItems != null && !spawnInfo.heldItems.isEmpty()) {
                PlayerPartyStorage party;
                ItemStack heldItem = JsonItemStack.choose(spawnInfo.heldItems);
                if (heldItem == null && this.spawnLocation.cause instanceof ServerPlayerEntity && (party = StorageProxy.getParty(this.spawnLocation.cause.func_110124_au())).getTeam().size() > 0 && party.getTeam().get(0).getAbility() instanceof SuperLuck) {
                    heldItem = JsonItemStack.choose(spawnInfo.heldItems);
                }
                if (heldItem != null) {
                    pixelmon.getPokemon().setHeldItem(heldItem);
                }
            }
            return pixelmon;
        }
        catch (Exception e) {
            Pixelmon.LOGGER.error("There was a problem spawning a " + this.pokemon.toString());
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public PixelmonEntity doSpawn(AbstractSpawner spawner) {
        PixelmonEntity pokemon = (PixelmonEntity)this.getOrCreateEntity();
        if (pokemon == null) {
            return null;
        }
        pokemon.field_70177_z = RandomHelper.getRandomNumberBetween(-180.0f, 180.0f);
        if (pokemon.isLegendary() && !pokemon.isBossPokemon() && Pixelmon.EVENT_BUS.post((Event)new LegendarySpawnEvent.DoSpawn(spawner, this))) {
            return null;
        }
        if (super.doSpawn(spawner) == null) {
            return null;
        }
        if (this.spawnInfo.groupSpawnSettings != null) {
            int flockId = GroupSpawningFactory.getNewGroupId();
            for (GroupSpawnSettings groupSpawnSetting : this.spawnInfo.groupSpawnSettings) {
                if (!groupSpawnSetting.shouldSpawn()) continue;
                for (int i = 0; i < groupSpawnSetting.getRandomAmount(); ++i) {
                    groupSpawnSetting.spawnPokemon(((PixelmonEntity)this.entity).field_70170_p, ((PixelmonEntity)this.entity).func_233580_cy_(), ((PixelmonEntity)this.entity).getSpawnLocation(), flockId);
                }
            }
        }
        if (PixelmonConfigProxy.getSpawning().isDisplayLegendaryGlobalMessage() && pokemon.isLegendary() && !pokemon.isBossPokemon()) {
            TranslationTextComponent translatePoke = new TranslationTextComponent("pixelmon." + pokemon.getSpecies().getName().toLowerCase(Locale.ROOT) + "");
            translatePoke.func_240699_a_(TextFormatting.GREEN);
            TranslationTextComponent translateMessage = new TranslationTextComponent("spawn.legendarymessage", new Object[]{translatePoke, BiomeHelper.getLocalizedBiomeName(this.spawnLocation.biome)});
            translateMessage.func_240699_a_(TextFormatting.GREEN);
            ServerLifecycleHooks.getCurrentServer().func_184103_al().func_232641_a_((ITextComponent)new TranslationTextComponent("chat.type.announcement", new Object[]{TextFormatting.LIGHT_PURPLE + "Pixelmon" + TextFormatting.RESET + TextFormatting.GREEN, translateMessage}), ChatType.CHAT, Util.field_240973_b_);
            BlockPos.Mutable pos = this.spawnLocation.location.pos;
            ServerLifecycleHooks.getCurrentServer().func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Spawned " + pokemon.getPokemonName() + " at: " + this.spawnLocation.location.world.func_72827_u() + " x:" + pos.func_177958_n() + ", y:" + pos.func_177956_o() + ", z:" + pos.func_177952_p()), Util.field_240973_b_);
            ((PixelmonEntity)this.entity).legendaryTicks = PixelmonConfigProxy.getSpawning().getLegendaryDespawnTicks();
        }
        ((PixelmonEntity)this.entity).resetDataWatchers();
        ((PixelmonEntity)this.entity).func_110148_a(Attributes.field_233818_a_).func_111128_a((double)pokemon.getPokemon().getMaxHealth());
        ((PixelmonEntity)this.entity).func_70606_j(pokemon.getPokemon().getHealth());
        ((PixelmonEntity)this.entity).getPokemon().setBonusStats(new BonusStats(((PixelmonEntity)this.entity).getSpecies()));
        return (PixelmonEntity)this.entity;
    }

    public static int getPokemonLevelBasedOnDistance(SpawnLocation spawnLocation) {
        BlockPos spawnPos = ((ServerWorld)spawnLocation.location.world).func_241135_u_();
        double distanceFromSpawn = Math.sqrt(spawnPos.func_218140_a((double)spawnLocation.location.pos.func_177958_n(), (double)spawnLocation.location.pos.func_177956_o(), (double)spawnLocation.location.pos.func_177952_p(), true));
        int levelBase = (int)(distanceFromSpawn / (double)PixelmonConfigProxy.getSpawning().getLevelDistance().getDistancePerLevel()) + 1;
        if (levelBase > PixelmonConfigProxy.getSpawning().getLevelDistance().getMaxLevelByDistance()) {
            levelBase = PixelmonConfigProxy.getSpawning().getLevelDistance().getMaxLevelByDistance();
        }
        return levelBase;
    }
}

