/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.notexamples;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.battles.BattleTickEvent;
import com.pixelmonmod.pixelmon.api.events.battles.TurnEndEvent;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.api.test.UnitTest;
import com.pixelmonmod.pixelmon.battles.api.BattleBuilder;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.NoOpAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class DancerTest {
    @UnitTest(value="dancer_copies_damage_dealing_dance_moves")
    public static CompletableFuture<TestResult> testDancerCopiesDanceMoves() {
        ArrayList testResults = Lists.newArrayList();
        Attack aquaStep = AttackRegistry.AQUA_STEP.get().ofMutable();
        Attack fieryDance = AttackRegistry.FIERY_DANCE.get().ofMutable();
        Attack petalDance = AttackRegistry.PETAL_DANCE.get().ofMutable();
        Attack revelationDance = AttackRegistry.REVELATION_DANCE.get().ofMutable();
        CompletableFuture[] completableFutureArray = new CompletableFuture[4];
        completableFutureArray[0] = DancerTest.testDancerCopiesDamageDealingMove(aquaStep).thenApply(testResults::add);
        completableFutureArray[1] = DancerTest.testDancerCopiesDamageDealingMove(fieryDance).thenApply(testResults::add);
        completableFutureArray[2] = DancerTest.testDancerCopiesDamageDealingMove(petalDance).thenApply(testResults::add);
        completableFutureArray[3] = DancerTest.testDancerCopiesDamageDealingMove(revelationDance).thenApply(testResults::add);
        return CompletableFuture.allOf(completableFutureArray).thenApply(unused -> {
            for (TestResult testResult : testResults) {
                if (testResult.isSuccess()) continue;
                return TestResult.failure("One of them failed.");
            }
            return TestResult.success();
        });
    }

    public static CompletableFuture<TestResult> testDancerCopiesDamageDealingMove(Attack dancingMove) {
        WildPixelmonParticipant oricorioOne = DancerTest.createOricorio();
        WildPixelmonParticipant oricorioTwo = DancerTest.createOricorio();
        return ((CompletableFuture)BattleBuilder.builder().frozen().rules(new BattleRules(BattleType.SINGLE).set(BattleRuleRegistry.GEN_MODE, (Object)EnumOldGenMode.Both)).teamOne(oricorioOne).teamTwo(oricorioTwo).start().thenCompose(controller -> {
            System.out.println("Running Dancer test for Attack " + dancingMove);
            oricorioOne.asWrapper().setAttack(dancingMove, (List<PixelmonWrapper>)Lists.newArrayList((Object[])new PixelmonWrapper[]{oricorioTwo.asWrapper()}), false);
            System.out.println("Set attack finished. Now doing useAttack()");
            oricorioOne.asWrapper().useAttack();
            System.out.println("UseAttack() finished.");
            controller.addTaskAtEvent(BattleTickEvent.Pre.class, (pre, bc) -> controller.endTurn());
            System.out.println("finished.");
            return controller.addFunctionAtEvent(TurnEndEvent.class, (turnEndEvent, bc) -> bc);
        })).thenApply(controller -> {
            if ((double)oricorioOne.asWrapper().pokemon.getHealthPercentage() == 100.0) {
                return TestResult.failure("The dancer ability did not activate.");
            }
            if ((double)oricorioTwo.asWrapper().pokemon.getHealthPercentage() == 100.0) {
                return TestResult.failure("The attacking Oricorio did not deal damage.");
            }
            return TestResult.success();
        });
    }

    private static WildPixelmonParticipant createOricorio() {
        WildPixelmonParticipant participant = new WildPixelmonParticipant(PokemonBuilder.builder().species(PixelmonSpecies.ORICORIO.getValue()).form("baile").heldItem(PixelmonItems.focus_sash).level(100).build());
        participant.setBattleAI(new NoOpAI(participant));
        return participant;
    }
}

