/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util;

import com.google.common.collect.MapMaker;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ResourceWithFallback {
    private static final Set<ResourceWithFallback> INSTANCES = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private ResourceLocation resource;
    private ResourceLocation fallback;
    private transient boolean checkedBefore = false;
    private transient boolean cacheExists = false;

    public static ResourceWithFallback from(ResourceLocation resource) {
        return new ResourceWithFallback(resource, resource);
    }

    public static ResourceWithFallback from(ResourceLocation resource, ResourceLocation fallback) {
        return new ResourceWithFallback(resource, fallback);
    }

    public static void resetAll() {
        Iterator<ResourceWithFallback> iterator = INSTANCES.iterator();
        while (iterator.hasNext()) {
            iterator.next().reset();
            iterator.remove();
        }
    }

    private ResourceWithFallback(ResourceLocation resource, ResourceLocation fallback) {
        this.resource = resource;
        this.fallback = fallback;
    }

    public ResourceLocation get() {
        if (Dist.CLIENT == FMLEnvironment.dist) {
            return this.clientGet();
        }
        return this.resource;
    }

    @OnlyIn(value=Dist.CLIENT)
    private ResourceLocation clientGet() {
        if (!this.checkedBefore) {
            this.cacheExists = ClientProxy.resourceLocationExists(this.resource);
            this.checkedBefore = true;
            INSTANCES.add(this);
        }
        if (this.cacheExists) {
            return this.resource;
        }
        return this.fallback;
    }

    public ResourceWithFallback ensureTexture() {
        this.resource = ResourceLocationHelper.ofTexture(this.resource);
        this.fallback = ResourceLocationHelper.ofTexture(this.fallback);
        return this;
    }

    public void reset() {
        this.checkedBefore = false;
        this.cacheExists = false;
    }

    public ResourceLocation getResource() {
        return this.resource;
    }

    public ResourceLocation getFallback() {
        return this.fallback;
    }

    public boolean usingFallback() {
        if (this.checkedBefore) {
            return !this.cacheExists;
        }
        this.clientGet();
        return !this.cacheExists;
    }
}

