/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.ParentalBond;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.ArrayList;
import java.util.List;

public abstract class DamageReflect
extends SpecialAttackBase {
    public float multiplier;
    private transient boolean inProgress;

    public DamageReflect(float multiplier) {
        this.multiplier = multiplier;
    }

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.inProgress) {
            this.inProgress = false;
            return AttackResult.proceed;
        }
        if (user.bc.simulateMode) {
            return AttackResult.hit;
        }
        ArrayList<PixelmonWrapper> opponents = user.getOpponentPokemon();
        if (user.lastDirectDamage >= 0 && this.isCorrectCategory(user.lastDirectCategory) && !opponents.isEmpty()) {
            if (opponents.size() <= user.lastDirectPosition) {
                user.lastDirectPosition = 0;
            }
            target = (PixelmonWrapper)opponents.get(user.lastDirectPosition);
            if (user.attack.getMove().isAttack(AttackRegistry.MIRROR_COAT) && target.hasType(Element.DARK)) {
                user.bc.sendToAll("pixelmon.effect.effectfailed", user.getNickname());
                return AttackResult.failed;
            }
            if (user.attack.getMove().isAttack(AttackRegistry.COUNTER) && target.hasType(Element.GHOST)) {
                user.bc.sendToAll("pixelmon.effect.effectfailed", user.getNickname());
                return AttackResult.failed;
            }
            if (user.lastDirectDamage == 0) {
                user.attack.setOverridePower(1);
                this.inProgress = true;
                user.useAttackOnly();
                return AttackResult.proceed;
            }
            float damage = (float)user.lastDirectDamage * this.multiplier;
            target.doBattleDamage(user, damage, DamageTypeEnum.ATTACKFIXED);
            if (target.isAlive() && user.isAlive() && user.getBattleAbility() instanceof ParentalBond) {
                target.doBattleDamage(user, damage, DamageTypeEnum.ATTACKFIXED);
                user.bc.sendToAll("multiplehit.times", user.getNickname(), 2);
            }
            return AttackResult.hit;
        }
        user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        return AttackResult.failed;
    }

    public abstract boolean isCorrectCategory(AttackCategory var1);

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        MoveChoice reflectChoice = null;
        for (MoveChoice opponentChoice : bestOpponentChoices) {
            if (!opponentChoice.isOffensiveMove() || !this.isCorrectCategory(opponentChoice.attack.getAttackCategory()) || !opponentChoice.targets.contains(pw) || !MoveChoice.canOutspeed(opponentChoice.createList(), pw, userChoice.createList())) continue;
            reflectChoice = opponentChoice;
            break;
        }
        if (reflectChoice != null) {
            for (PixelmonWrapper target : userChoice.targets) {
                float reflectDamage = (float)(Math.floor(reflectChoice.result.damage / reflectChoice.targets.size()) * (double)this.multiplier);
                userChoice.raiseWeightLimited(target.getHealthPercent(reflectDamage));
            }
        }
        if (userChoice.isMiddleTier() && RandomHelper.getRandomChance()) {
            userChoice.setWeight(1.0f);
        }
    }
}

