/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.log.MoveResults;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.ArrayList;

public class DragonDarts
extends SpecialAttackBase {
    public int minHits = 2;
    public int maxHits = 2;
    private transient int count = 0;
    private transient int targetCount = 2;
    private transient boolean inProgress = false;
    private transient int limit = 0;
    private transient boolean hasSecondTarget = false;
    private transient PixelmonWrapper firstTarget;

    public boolean repeatsAttack() {
        if (this.maxHits == 0) {
            if (this.count >= this.minHits) {
                return false;
            }
            ++this.count;
            return true;
        }
        if (this.count >= this.targetCount) {
            return false;
        }
        ++this.count;
        return true;
    }

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.limit++ <= 2 && this.inProgress) {
            return AttackResult.proceed;
        }
        user.inMultipleHit = true;
        this.inProgress = true;
        this.limit = 0;
        if (this.maxHits != 0) {
            this.targetCount = 2;
        }
        this.count = 0;
        int initAccuracy = user.attack.getMove().getAccuracy();
        boolean hasSubstitute = false;
        while (user.isAlive() && this.repeatsAttack()) {
            MoveResults[] results;
            hasSubstitute = target.hasStatus(StatusType.Substitute);
            for (MoveResults result : results = user.useAttackOnly()) {
                user.attack.moveResult.damage += result.damage;
                user.attack.moveResult.fullDamage += result.fullDamage;
            }
            if (target.isAlly(user) || this.hasSecondTarget) continue;
            this.firstTarget = target;
            PixelmonWrapper newTarget = this.selectDragonDartsTarget(user, target);
            user.targets.remove(0);
            user.targets.add(newTarget);
            this.hasSecondTarget = true;
        }
        user.attack.setMoveAccuracy(initAccuracy);
        user.inMultipleHit = false;
        this.inProgress = false;
        this.hasSecondTarget = false;
        user.attack.sendEffectiveChat(user, target);
        user.bc.sendToAll("multiplehit.times", user.getNickname(), this.count);
        Attack.postProcessAttackAllHits(user, target, user.attack, user.attack.moveResult.damage, DamageTypeEnum.ATTACK, hasSubstitute);
        return AttackResult.hit;
    }

    @Override
    public void applyMissEffect(PixelmonWrapper user, PixelmonWrapper target) {
        PixelmonWrapper newTarget = this.selectDragonDartsTarget(user, target);
        if (newTarget != target) {
            MoveResults[] results;
            PixelmonWrapper previousTarget = user.targets.remove(0);
            if (!this.hasSecondTarget) {
                this.firstTarget = previousTarget;
            }
            if (this.hasSecondTarget) {
                if (previousTarget == this.firstTarget) {
                    return;
                }
                user.targets.add(this.firstTarget);
            } else {
                user.targets.add(newTarget);
            }
            this.hasSecondTarget = true;
            for (MoveResults result : results = user.useAttackOnly()) {
                user.attack.moveResult.damage += result.damage;
                user.attack.moveResult.fullDamage += result.fullDamage;
                user.attack.moveResult.accuracy = result.accuracy;
            }
        }
    }

    private PixelmonWrapper selectDragonDartsTarget(PixelmonWrapper user, PixelmonWrapper target) {
        PixelmonWrapper newTarget = target;
        if (user.bc.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) != BattleType.SINGLE) {
            ArrayList<PixelmonWrapper> targetTeam = target.getTeamPokemon();
            if (user.bc.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.DOUBLE) {
                for (PixelmonWrapper pw : targetTeam) {
                    if (pw == target) continue;
                    newTarget = pw;
                    break;
                }
            }
            if (user.bc.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.TRIPLE) {
                int newTargetPosition = target.battlePosition;
                if (user.battlePosition == 1) {
                    boolean leftRightTarget = RandomHelper.getRandomChance();
                    newTargetPosition = leftRightTarget ? (target.battlePosition + 1) % 3 : (target.battlePosition + 2) % 3;
                }
                for (PixelmonWrapper pw : targetTeam) {
                    if (user.battlePosition == 0) {
                        if (pw == target || pw.battlePosition == 2) continue;
                        newTarget = pw;
                        break;
                    }
                    if (user.battlePosition == 2) {
                        if (pw == target || pw.battlePosition == 0) continue;
                        newTarget = pw;
                        break;
                    }
                    if (pw == target) continue;
                    if (target.getTeamPokemon().size() < 3) {
                        newTarget = pw;
                        continue;
                    }
                    if (pw.battlePosition != newTargetPosition) continue;
                    newTarget = pw;
                    break;
                }
            }
        }
        return newTarget;
    }
}

