/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;

public class FoulPlay
extends SpecialAttackBase {
    private int startingReplaceModifier;
    private double oldAttackModifier;
    private int oldAttack;

    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        this.oldAttackModifier = user.getBattleStats().getAttackModifier();
        this.oldAttack = user.getBattleStats().attackStat;
        if (user.attack.isAttack(AttackRegistry.FOUL_PLAY)) {
            this.startingReplaceModifier = (int)target.getBattleStats().getAttackModifier();
            user.getBattleStats().changeStat(BattleStatsType.ATTACK, this.startingReplaceModifier);
            int[] targetStats = target.getBattleStats().getBaseBattleStats();
            user.getBattleStats().attackStat = targetStats[BattleStatsType.ATTACK.getStatIndex()];
        } else if (user.attack.isAttack(AttackRegistry.BODY_PRESS)) {
            this.startingReplaceModifier = user.getBattleStats().getDefenseModifier();
            user.getBattleStats().changeStat(BattleStatsType.ATTACK, this.startingReplaceModifier);
            int[] userBaseStats = user.getBattleStats().getBaseBattleStats();
            user.getBattleStats().attackStat = userBaseStats[BattleStatsType.DEFENSE.getStatIndex()];
        }
        int[] userStats = user.getBattleStats().getBattleStats();
        user.bc.modifyStats(user, userStats);
        return AttackResult.proceed;
    }

    @Override
    public void applyEffectAfterAllTargets(PixelmonWrapper user) {
        int modifierChange = (int)user.getBattleStats().getAttackModifier() - this.startingReplaceModifier;
        this.oldAttackModifier += (double)modifierChange;
        user.getBattleStats().changeStat(BattleStatsType.ATTACK, (int)this.oldAttackModifier);
        user.getBattleStats().attackStat = this.oldAttack;
    }
}

