/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.battles.HiddenPowerCalculateEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IVStore;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.eventbus.api.Event;

public class HiddenPower
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        user.attack.overrideType(HiddenPower.getHiddenPowerType((PlayerEntity)user.getPlayerOwner(), user.pokemon, user.getStats().getIVs(), "Battle"));
        return AttackResult.proceed;
    }

    public static Element getHiddenPowerType(PlayerEntity playerEntity, Pokemon pokemon, IVStore ivs, String reason) {
        int a = ivs.getStat(BattleStatsType.HP) % 2;
        int b = ivs.getStat(BattleStatsType.ATTACK) % 2;
        int c = ivs.getStat(BattleStatsType.DEFENSE) % 2;
        int d = ivs.getStat(BattleStatsType.SPEED) % 2;
        int e = ivs.getStat(BattleStatsType.SPECIAL_ATTACK) % 2;
        int f = ivs.getStat(BattleStatsType.SPECIAL_DEFENSE) % 2;
        double fedbca = 32 * f + 16 * e + 8 * d + 4 * c + 2 * b + a;
        int type = (int)Math.floor(fedbca * 15.0 / 63.0);
        Element element = null;
        element = type == 0 ? Element.FIGHTING : (type == 1 ? Element.FLYING : (type == 2 ? Element.POISON : (type == 3 ? Element.GROUND : (type == 4 ? Element.ROCK : (type == 5 ? Element.BUG : (type == 6 ? Element.GHOST : (type == 7 ? Element.STEEL : (type == 8 ? Element.FIRE : (type == 9 ? Element.WATER : (type == 10 ? Element.GRASS : (type == 11 ? Element.ELECTRIC : (type == 12 ? Element.PSYCHIC : (type == 13 ? Element.ICE : (type == 14 ? Element.DRAGON : Element.DARK))))))))))))));
        HiddenPowerCalculateEvent event = new HiddenPowerCalculateEvent(reason, pokemon, playerEntity, element);
        Pixelmon.EVENT_BUS.post((Event)event);
        return event.getCalculatedValue();
    }

    public static IVStore getOptimalIVs(Element type) {
        int[] arr = new int[]{31, 31, 31, 31, 31, 31};
        switch (type) {
            case BUG: {
                arr[1] = 30;
                arr[2] = 30;
                arr[4] = 30;
                break;
            }
            case DARK: {
                break;
            }
            case DRAGON: {
                arr[1] = 30;
                break;
            }
            case ELECTRIC: {
                arr[3] = 30;
                break;
            }
            case FIGHTING: {
                arr[2] = 30;
                arr[3] = 30;
                arr[4] = 30;
                arr[5] = 30;
                break;
            }
            case FIRE: {
                arr[1] = 30;
                arr[3] = 30;
                arr[5] = 30;
                break;
            }
            case FLYING: {
                arr[0] = 30;
                arr[1] = 30;
                arr[2] = 30;
                arr[3] = 30;
                arr[4] = 30;
                break;
            }
            case GHOST: {
                arr[1] = 30;
                arr[4] = 30;
                break;
            }
            case GRASS: {
                arr[1] = 30;
                arr[3] = 30;
                break;
            }
            case GROUND: {
                arr[3] = 30;
                arr[4] = 30;
                break;
            }
            case ICE: {
                arr[1] = 30;
                arr[2] = 30;
                break;
            }
            case POISON: {
                arr[2] = 30;
                arr[3] = 30;
                arr[4] = 30;
                break;
            }
            case PSYCHIC: {
                arr[1] = 30;
                arr[5] = 30;
                break;
            }
            case ROCK: {
                arr[2] = 30;
                arr[4] = 30;
                arr[5] = 30;
                break;
            }
            case STEEL: {
                arr[4] = 30;
                break;
            }
            case WATER: {
                arr[1] = 30;
                arr[2] = 30;
                arr[3] = 30;
                break;
            }
        }
        return new IVStore(arr);
    }
}

