/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.log;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.export.PokemonConverterFactory;
import com.pixelmonmod.pixelmon.api.util.PokePasteHelper;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.log.action.BattleAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.PokemonRelatedBattleAction;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;

public class BattleLog {
    protected final BattleController bc;
    protected final Instant battleStart = Instant.now();
    protected final Map<Integer, BattleTurnLog> logs = new LinkedHashMap<Integer, BattleTurnLog>();
    protected BattleTurnLog currentTurnLog;

    public BattleLog(BattleController bc) {
        this.bc = bc;
        this.turnTick(0);
    }

    public void logEvent(BattleAction event) {
        this.currentTurnLog.logAction(event);
    }

    @Nullable
    public BattleAction getActionForPokemon(int turn, PixelmonWrapper pw) {
        BattleTurnLog log = this.logs.get(turn);
        if (log == null) {
            return null;
        }
        return log.getBattleActionFor(pw);
    }

    public void turnTick(int turn) {
        this.currentTurnLog = new BattleTurnLog();
        this.logs.put(turn, this.currentTurnLog);
    }

    public void onCrash(Exception exc, String error) {
        if (PixelmonConfigProxy.getGeneral().getDebug().isPrintErrors()) {
            Pixelmon.LOGGER.error(error, (Throwable)exc);
        }
        if (PixelmonConfigProxy.getGeneral().getDebug().isPrintErrors()) {
            Pixelmon.LOGGER.error("===Too many errors detected in battle, force-ending===");
            this.bc.participants.stream().filter(PlayerParticipant.class::isInstance).forEach(participant -> ChatHandler.sendChat((Entity)participant.getEntity(), "pixelmon.general.battleerror", new Object[0]));
        }
        this.bc.endBattle(BattleEndCause.FORCE);
        try {
            this.exportLogFile(error, exc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<BattleAction> getAllActions() {
        return this.logs.values().stream().map(it -> ((BattleTurnLog)it).actions).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public CompletableFuture<File> exportLogFile(String message, Exception exception) throws Exception {
        File file = this.getLogFile();
        StringBuilder sb = new StringBuilder("Pixelmon Version ").append(Pixelmon.getVersion()).append("\n").append("Battle data ").append(this.battleStart.toString()).append("\n").append("\n");
        CompletionStage waiting = null;
        for (BattleParticipant participant : this.bc.participants) {
            String export = PokemonConverterFactory.getFormattedExportedText(Arrays.stream(participant.allPokemon).map(wrapper -> wrapper.pokemon).collect(Collectors.toList()));
            if (waiting == null) {
                sb.append("Team #").append(participant.team).append(" ").append(participant.getType().toString()).append(" ").append(participant.getDisplayName()).append(" ").append((Object)(participant.getEntity() == null || participant.getEntity().field_70170_p == null ? "N/A" : participant.getEntity().field_70170_p.func_234923_W_().func_240901_a_())).append(" ").append((Object)(participant.getEntity() == null ? "N/A" : participant.getEntity().func_213303_ch())).append("\n");
                waiting = PokePasteHelper.upload(export, participant.getDisplayName() + "'s team", participant.getDisplayName()).whenComplete((s, throwable) -> {
                    for (PixelmonWrapper pw : participant.allPokemon) {
                        CompoundNBT tag = pw.pokemon.writeToNBT(new CompoundNBT());
                        sb.append("\t").append(pw.getPokemonName()).append(" ").append(tag.toString()).append(System.lineSeparator());
                    }
                    sb.append(" URL: ").append(s.map(url -> "https://pokepast.es/" + url).get()).append("\n").append("\n");
                });
                continue;
            }
            waiting = ((CompletableFuture)waiting.thenCompose(o -> PokePasteHelper.upload(export, participant.getDisplayName() + "'s team", participant.getDisplayName()))).whenComplete((s, throwable2) -> {
                sb.append("Team #").append(participant.team).append(" ").append(participant.getType().toString()).append(" ").append(participant.getDisplayName()).append(" ").append((Object)(participant.getEntity() == null || participant.getEntity().field_70170_p == null ? "N/A" : participant.getEntity().field_70170_p.func_234923_W_().func_240901_a_())).append(" ").append((Object)(participant.getEntity() == null ? "N/A" : participant.getEntity().func_213303_ch())).append("\n");
                for (PixelmonWrapper pw : participant.allPokemon) {
                    CompoundNBT tag = pw.pokemon.writeToNBT(new CompoundNBT());
                    sb.append("\t").append(pw.getPokemonName()).append(" ").append(tag.toString()).append(System.lineSeparator());
                }
                sb.append(" URL: ").append(s.map(url -> "https://pokepast.es/" + url).get()).append("\n");
            });
        }
        return waiting.thenApply(unused -> {
            sb.append("\n");
            for (BattleTurnLog log : this.logs.values()) {
                sb.append(log.toString());
            }
            if (exception != null) {
                sb.append(message).append('\n');
                sb.append(exception.getMessage()).append('\n');
                for (StackTraceElement element : exception.getStackTrace()) {
                    sb.append(element.toString()).append('\n');
                }
            }
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
                Files.write(file.toPath(), sb.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return file;
        });
    }

    private File getLogFile() {
        File file = new File("./logs/battle/", this.getFilename() + ".log");
        int count = 0;
        while (file.exists()) {
            file = new File("./logs/battle/", this.getFilename() + "_" + count++ + ".log");
        }
        return file;
    }

    public String getFilename() {
        return "battle-" + this.battleStart.getEpochSecond();
    }

    public static class BattleTurnLog {
        private final List<BattleAction> actions = new ArrayList<BattleAction>();

        public void logAction(BattleAction action) {
            this.actions.add(action);
        }

        public BattleAction getBattleActionFor(PixelmonWrapper wrapper) {
            for (BattleAction action : this.actions) {
                if (!(action instanceof PokemonRelatedBattleAction) || ((PokemonRelatedBattleAction)action).getPokemon() == null || !Objects.equals(((PokemonRelatedBattleAction)action).getPokemon().getPokemonUUID(), wrapper.getPokemonUUID())) continue;
                return action;
            }
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (BattleAction action : this.actions) {
                if (!action.appendLog(sb)) continue;
                sb.append('\n');
            }
            return sb.toString();
        }
    }
}

