/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MarvelScale;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.QuickFeet;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Synchronize;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.WakeUp;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TranslationTextComponent;

public class Drowsy
extends StatusPersist {
    private static final transient float AI_WEIGHT = 25.0f;

    public Drowsy() {
        super(StatusType.Drowsy);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.checkChance()) {
            Drowsy.drowsy(user, target, user.attack, true);
        }
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        for (int i = 0; i < a.getMove().effects.size(); ++i) {
            EffectBase e = a.getMove().effects.get(i);
            if (!(e instanceof WakeUp)) continue;
            user.removeStatus(this);
            return true;
        }
        user.bc.sendToAll("pixelmon.status.drowsy", user.getNickname());
        if (RandomHelper.getRandomChance(user.bc.globalStatusController.hasStatus(StatusType.Hail) ? 0.5f : 0.33f)) {
            user.bc.sendToAll("pixelmon.status.drowsymiss", user.getNickname());
            return false;
        }
        return true;
    }

    public static boolean drowsy(PixelmonWrapper user, PixelmonWrapper target, Attack attack, boolean showMessage) {
        boolean result;
        boolean isStatusMove;
        boolean bl = isStatusMove = attack != null && attack.getAttackCategory() == AttackCategory.STATUS;
        if (target.hasNonVolatileStatus()) {
            if (showMessage && isStatusMove) {
                user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                user.setAttackFailed();
            }
            return false;
        }
        TranslationTextComponent message = null;
        if (showMessage) {
            message = ChatHandler.getMessage("pixelmon.effect.drowsy", target.getNickname());
        }
        if (!(result = target.addStatus(new Drowsy(), user, message)) && isStatusMove) {
            user.setAttackFailed();
        }
        return result;
    }

    @Override
    public StatusPersist restoreFromNBT(CompoundNBT nbt) {
        return new Drowsy();
    }

    @Override
    public int[] modifyPowerAndAccuracyTarget(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        return new int[]{(int)Math.ceil((float)power / 0.75f), accuracy};
    }

    @Override
    public String getCureMessage() {
        return "pixelmon.status.drowsycure";
    }

    @Override
    public String getCureMessageItem() {
        return "pixelmon.status.drowsycureitem";
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        boolean offensive = userChoice.isOffensiveMove();
        float weight = this.getWeightWithChance(25.0f);
        if (!offensive || userChoice.isMiddleTier()) {
            boolean hitsAlly = userChoice.hitsAlly();
            if (offensive && hitsAlly) {
                return;
            }
            ArrayList<PixelmonWrapper> opponents = pw.getOpponentPokemon();
            for (PixelmonWrapper target : userChoice.targets) {
                boolean beneficial;
                if (offensive && !Drowsy.drowsy(pw, target, userChoice.attack, false)) continue;
                Ability ability = target.getBattleAbility();
                boolean bl = beneficial = ability instanceof MarvelScale || ability instanceof QuickFeet;
                if (beneficial ^ hitsAlly) {
                    userChoice.raiseWeight(-weight);
                    continue;
                }
                if (ability instanceof Synchronize) continue;
                pw.getBattleAI().weightStatusOpponentOptions(pw, userChoice, target, new Drowsy(), opponents, bestOpponentChoices);
                userChoice.raiseWeight(weight);
            }
        }
    }
}

