/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.ProtectVariation;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class Endure
extends ProtectVariation {
    public Endure() {
        super(StatusType.Endure);
    }

    @Override
    protected boolean addStatus(PixelmonWrapper user) {
        return user.addStatus(new Endure(), user);
    }

    @Override
    protected void displayMessage(PixelmonWrapper user) {
        user.bc.sendToAll("pixelmon.status.endure", user.getNickname());
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        return false;
    }

    @Override
    public int modifyDamageIncludeFixed(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a, DamageTypeEnum damageType) {
        float targetHealth = target.getHealth();
        if ((float)damage >= targetHealth) {
            target.bc.sendToAll("pixelmon.status.endurehit", target.getNickname());
            return (int)targetHealth - 1;
        }
        return damage;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        pw.removeStatus(this);
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (pw.getHealth() > 1 && pw.getMoveset().hasAttack(AttackRegistry.FLAIL, AttackRegistry.REVERSAL) && MoveChoice.canOHKO(bestOpponentChoices, pw)) {
            userChoice.raiseWeight(100 / (1 << pw.protectsInARow));
        }
    }
}

