/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.Effectiveness;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class Foresight
extends StatusBase {
    transient Element ignoredType;

    public Foresight() {
        super(StatusType.Foresight);
    }

    public Foresight(Element ignoredType) {
        super(StatusType.Foresight);
        this.ignoredType = ignoredType;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (!target.hasStatus(StatusType.Foresight)) {
            target.bc.sendToAll("pixelmon.status.foresight", target.getNickname());
            Element type = this.getIgnoredType(user.attack);
            target.addStatus(new Foresight(type), user);
        } else {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        }
    }

    private Element getIgnoredType(Attack attack) {
        return attack.isAttack(AttackRegistry.MIRACLE_EYE) ? Element.DARK : Element.GHOST;
    }

    @Override
    public List<Element> getEffectiveTypes(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.attack != null && Element.getEffectiveness(user.attack.getType(), this.ignoredType) == Effectiveness.None) {
            return Element.ignoreType(target.type, this.ignoredType);
        }
        return target.type;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly()) {
            return;
        }
        for (PixelmonWrapper target : userChoice.targets) {
            Element ignoredType;
            int evasion = target.getBattleStats().getStage(BattleStatsType.EVASION);
            if (evasion > 0) {
                userChoice.raiseWeight(10 * evasion);
            }
            if (!target.hasType(ignoredType = this.getIgnoredType(userChoice.attack))) continue;
            Moveset moveset = pw.getMoveset();
            if ((ignoredType != Element.GHOST || !moveset.hasOffensiveAttackType(Element.NORMAL, Element.FIGHTING)) && (ignoredType != Element.DARK || !moveset.hasOffensiveAttackType(Element.PSYCHIC))) continue;
            userChoice.raiseWeight(25.0f);
        }
    }
}

