/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;

public class ParadoxBoost
extends StatusBase {
    public boolean itemBased = false;
    public BattleStatsType boostedStat = BattleStatsType.NONE;

    public ParadoxBoost() {
        super(StatusType.ParadoxBoost);
    }

    public ParadoxBoost(PixelmonWrapper pw, boolean extended) {
        super(StatusType.ParadoxBoost);
        this.itemBased = extended;
        this.findBoostedStat(pw);
    }

    private void findBoostedStat(PixelmonWrapper pw) {
        int maxStat = 0;
        BattleStats stats = pw.getBattleStats();
        stats.setBattleStatsForCurrentForm();
        for (BattleStatsType type : BattleStatsType.UNIQUE_BATTLE_STATS) {
            int newStat = pw.getBattleStats().getStatWithMod(type);
            if (newStat <= maxStat) continue;
            maxStat = newStat;
            this.boostedStat = type;
        }
    }

    @Override
    public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        double amount = 1.3;
        if (this.boostedStat == BattleStatsType.SPEED) {
            amount = 1.5;
        } else if (this.boostedStat == BattleStatsType.NONE) {
            return stats;
        }
        int n = this.boostedStat.getStatIndex();
        stats[n] = (int)((double)stats[n] * amount);
        return stats;
    }
}

