/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.furniture;

import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.enums.GymSignType;
import com.pixelmonmod.pixelmon.blocks.tileentity.GymSignTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.init.registry.BlockRegistration;
import com.pixelmonmod.pixelmon.items.GymSignItem;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GymSignBlock
extends GenericRotatableModelBlock
implements IBlockHasOwner {
    public static final VoxelShape HANGING_SHAPE_NORTH = Block.func_208617_a((double)1.0, (double)1.0, (double)6.0, (double)15.0, (double)16.0, (double)10.0);
    public static final VoxelShape HANGING_SHAPE_SOUTH = Block.func_208617_a((double)1.0, (double)1.0, (double)6.0, (double)15.0, (double)16.0, (double)10.0);
    public static final VoxelShape HANGING_SHAPE_EAST = Block.func_208617_a((double)6.0, (double)1.0, (double)1.0, (double)10.0, (double)16.0, (double)15.0);
    public static final VoxelShape HANGING_SHAPE_WEST = Block.func_208617_a((double)6.0, (double)1.0, (double)1.0, (double)10.0, (double)16.0, (double)15.0);
    public static final VoxelShape WALL_SHAPE_NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape WALL_SHAPE_SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    public static final VoxelShape WALL_SHAPE_EAST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
    public static final VoxelShape WALL_SHAPE_WEST = Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final GymSignType gymSignType;

    public GymSignBlock(GymSignType gymSignType) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(1.0f).func_200947_a(SoundType.field_185852_e));
        this.gymSignType = gymSignType;
        this.func_180632_j((BlockState)this.field_176227_L.func_177621_b());
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        DyeColor color = ((GymSignItem)context.func_195996_i().func_77973_b()).getDyeColor();
        BlockState potentialBlockstate = super.func_196258_a(context);
        Direction direction = (Direction)potentialBlockstate.func_177229_b((Property)FACING);
        if (context.func_196000_l() == Direction.DOWN) {
            potentialBlockstate = (BlockState)((Block)BlockRegistration.HANGING_GYM_SIGNS.get(color.func_176762_d().toLowerCase(Locale.ROOT)).get()).func_176223_P().func_206870_a((Property)FACING, (Comparable)direction);
        } else if (context.func_196000_l() == Direction.UP) {
            potentialBlockstate = (BlockState)((Block)BlockRegistration.FLOOR_GYM_SIGNS.get(color.func_176762_d().toLowerCase(Locale.ROOT)).get()).func_176223_P().func_206870_a((Property)FACING, (Comparable)direction);
        } else {
            direction = context.func_196000_l();
            potentialBlockstate = (BlockState)((Block)BlockRegistration.WALL_GYM_SIGNS.get(color.func_176762_d().toLowerCase(Locale.ROOT)).get()).func_176223_P().func_206870_a((Property)FACING, (Comparable)direction);
        }
        World iworldreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        BlockState chosenBlockstate = null;
        if (potentialBlockstate.func_196955_c((IWorldReader)iworldreader, blockpos)) {
            chosenBlockstate = potentialBlockstate;
        }
        return chosenBlockstate != null && iworldreader.func_226663_a_(chosenBlockstate, blockpos, ISelectionContext.func_216377_a()) ? chosenBlockstate : null;
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new GymSignTileEntity(this.gymSignType);
    }

    @Override
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        if (this.gymSignType == GymSignType.HANGING) {
            switch (direction) {
                default: {
                    return HANGING_SHAPE_NORTH;
                }
                case SOUTH: {
                    return HANGING_SHAPE_SOUTH;
                }
                case EAST: {
                    return HANGING_SHAPE_EAST;
                }
                case WEST: 
            }
            return HANGING_SHAPE_WEST;
        }
        if (this.gymSignType == GymSignType.WALL) {
            switch (direction) {
                default: {
                    return WALL_SHAPE_NORTH;
                }
                case SOUTH: {
                    return WALL_SHAPE_SOUTH;
                }
                case EAST: {
                    return WALL_SHAPE_EAST;
                }
                case WEST: 
            }
            return WALL_SHAPE_WEST;
        }
        return super.func_220053_a(state, p_220053_2_, p_220053_3_, p_220053_4_);
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (placer instanceof PlayerEntity && !worldIn.field_72995_K) {
            this.setOwner(pos, (PlayerEntity)placer);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.func_201670_d() || hand == Hand.OFF_HAND) {
            return ActionResultType.SUCCESS;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        GymSignTileEntity gymSign = BlockHelper.getTileEntity(GymSignTileEntity.class, (IBlockReader)world, pos);
        if (gymSign == null) {
            return ActionResultType.SUCCESS;
        }
        if (!player.func_110124_au().equals(gymSign.getOwnerUUID())) {
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.gymsign.ownership", new Object[0]);
            return ActionResultType.SUCCESS;
        }
        Item playerItem = null;
        if (!heldItem.func_190926_b()) {
            playerItem = heldItem.func_77973_b();
        }
        boolean itemUsed = false;
        if (playerItem instanceof DyeItem) {
            String dyeName;
            DyeColor dyeColor = DyeColor.getColor((ItemStack)heldItem);
            String currentColour = gymSign.getColour();
            if (!currentColour.equals(dyeName = dyeColor.func_176610_l())) {
                gymSign.setColour(dyeName);
                ((ServerWorld)world).func_72863_F().func_217217_a(pos);
                if (!player.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
                itemUsed = true;
            }
        }
        if (!itemUsed) {
            ItemStack signStack = gymSign.getItemInSign();
            ItemStack putting = null;
            if (!heldItem.func_190926_b() && signStack != null && heldItem.func_77973_b() == signStack.func_77973_b()) {
                putting = null;
            }
            if (!heldItem.func_190926_b()) {
                putting = heldItem.func_77946_l();
                putting.func_190920_e(1);
                if (!player.func_184812_l_()) {
                    heldItem.func_77979_a(1);
                }
            }
            if (signStack != null && signStack != ItemStack.field_190927_a && !player.func_184812_l_()) {
                DropItemHelper.giveItemStack((ServerPlayerEntity)player, signStack, false);
            }
            gymSign.setItemInSign(putting);
            ((ServerWorld)world).func_72863_F().func_217217_a(pos);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (!player.func_184812_l_()) {
            GymSignTileEntity tile = BlockHelper.getTileEntity(GymSignTileEntity.class, (IBlockReader)world, pos);
            this.func_176206_d((IWorld)world, pos, world.func_180495_p(pos));
            if (tile != null && tile.getItemInSign() != null && tile.isDroppable()) {
                InventoryHelper.func_219961_a((World)world, (BlockPos)pos, tile.getContents());
                tile.setItemInSign(null);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_196243_a(BlockState newState, World world, BlockPos pos, BlockState oldState, boolean p_196243_5_) {
        if (!newState.func_203425_a(oldState.func_177230_c())) {
            GymSignTileEntity tile = BlockHelper.getTileEntity(GymSignTileEntity.class, (IBlockReader)world, pos);
            if (tile != null && tile.getItemInSign() != null && tile.isDroppable()) {
                InventoryHelper.func_219961_a((World)world, (BlockPos)pos, tile.getContents());
                tile.setItemInSign(null);
            }
            super.func_196243_a(newState, world, pos, oldState, p_196243_5_);
        }
    }

    @Override
    public void setOwner(BlockPos pos, PlayerEntity playerIn) {
        GymSignTileEntity gymSign = BlockHelper.getTileEntity(GymSignTileEntity.class, (IBlockReader)playerIn.func_130014_f_(), pos);
        gymSign.setOwner(playerIn.func_110124_au());
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState p_220080_1_, IBlockReader p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState state, IBlockReader level, BlockPos pos) {
        return true;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return 1;
    }
}

