/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.CloningMachineTileEntity;
import java.util.Optional;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CloningMachineBlock
extends MultiBlock {
    public CloningMachineBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(1.0f).func_226896_b_(), 5, 3.0, 1);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.func_201670_d() || hand == Hand.OFF_HAND) {
            return ActionResultType.SUCCESS;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        BlockPos loc = this.findBaseBlock((IBlockReader)world, pos.func_239590_i_(), state);
        CloningMachineTileEntity te = BlockHelper.getTileEntity(CloningMachineTileEntity.class, (IBlockReader)world, loc);
        if (te != null) {
            te.activate(player, heldItem);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    protected Optional<TileEntity> getTileEntity(IBlockReader world, BlockState state) {
        return Optional.of(new CloningMachineTileEntity());
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        CloningMachineTileEntity ranchBlock = (CloningMachineTileEntity)world.func_175625_s(pos);
        if (ranchBlock == null || ranchBlock.owner == null || player.func_110124_au().equals(ranchBlock.owner) || player.func_184812_l_()) {
            return super.func_180647_a(state, player, world, pos);
        }
        return -1.0f;
    }

    @Override
    public void func_196243_a(BlockState blockState, World level, BlockPos pos, BlockState newState, boolean p_196243_5_) {
        if (!blockState.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = level.func_175625_s(pos);
            if (tileentity instanceof CloningMachineTileEntity) {
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                ((CloningMachineTileEntity)tileentity).onDestroy();
                if (((CloningMachineTileEntity)tileentity).isBroken) {
                    itemEntity.func_92058_a(new ItemStack((IItemProvider)PixelmonItems.aluminium_ingot.func_199767_j(), 1));
                } else {
                    itemEntity.func_92058_a(new ItemStack((IItemProvider)PixelmonBlocks.cloning_machine.func_199767_j(), 1));
                }
                level.func_217376_c((Entity)itemEntity);
            }
            super.func_196243_a(blockState, level, pos, newState, p_196243_5_);
        }
    }
}

