/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.enums.GymSignType;
import com.pixelmonmod.pixelmon.blocks.tileentity.ISpecialTexture;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;

public class GymSignTileEntity
extends TileEntity
implements ISpecialTexture {
    private ItemStack itemInSign = null;
    private UUID owner = null;
    private String colour = "red";
    private ResourceLocation texture = ResourceLocationHelper.of("pixelmon:textures/block/gymsign/red.png");
    private boolean itemDrops = true;
    private final GymSignType gymSignType;

    public GymSignTileEntity(GymSignType gymSignType) {
        super((TileEntityType)TileEntityRegistration.GYM_SIGN.get());
        this.gymSignType = gymSignType;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.itemInSign = nbt.func_74764_b("ItemIn") ? ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("ItemIn")) : null;
        if (nbt.func_74764_b("ItemDrops")) {
            this.itemDrops = nbt.func_74767_n("ItemDrops");
        }
        if (nbt.func_74764_b("owner")) {
            this.owner = UUID.fromString(nbt.func_74779_i("owner"));
            this.colour = nbt.func_74779_i("colour");
            this.refreshTexture();
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (this.itemInSign == null) {
            nbt.func_82580_o("ItemIn");
        } else {
            CompoundNBT itemTag = new CompoundNBT();
            this.itemInSign.func_77955_b(itemTag);
            nbt.func_218657_a("ItemIn", (INBT)itemTag);
        }
        nbt.func_74757_a("ItemDrops", this.itemDrops);
        if (this.owner != null) {
            nbt.func_74778_a("colour", this.colour);
            nbt.func_74778_a("owner", this.owner.toString());
        }
        return nbt;
    }

    private void refreshTexture() {
        this.texture = ResourceLocationHelper.of("pixelmon:textures/block/gymsign/texture_" + this.colour.toLowerCase(Locale.ROOT) + ".png");
    }

    public String getColour() {
        return this.colour;
    }

    public void setColour(String colour) {
        this.colour = colour;
        this.sendChanges();
        this.func_70296_d();
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void sendChanges() {
        if (this.func_145830_o() && this.func_145831_w() instanceof ServerWorld) {
            this.field_145850_b.func_225319_b(this.field_174879_c, this.func_195044_w(), this.func_195044_w());
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("colour", this.colour);
        this.func_189515_b(nbt);
        return nbt;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        CompoundNBT data = pkt.func_148857_g();
        this.colour = data.func_74779_i("colour");
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.func_70296_d();
    }

    public ItemStack getItemInSign() {
        return this.itemInSign;
    }

    public NonNullList<ItemStack> getContents() {
        return NonNullList.func_191197_a((int)1, (Object)this.getItemInSign());
    }

    public void setItemInSign(ItemStack item) {
        this.itemInSign = item;
        this.func_70296_d();
    }

    public void setDroppable(boolean b) {
        this.itemDrops = false;
    }

    public boolean isDroppable() {
        return this.itemDrops;
    }

    public GymSignType getGymSignType() {
        return this.gymSignType;
    }
}

