/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.blocks.MysteryBoxEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.MysteryBoxBlock;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.Event;

public class MysteryBoxTileEntity
extends TileEntity
implements ITickableTileEntity {
    private long lastOpenTime;
    private long nextOpenTime;
    private long openUntil;
    private int scrapsTotal;
    private int scrapsLeft;
    private transient float animTicker = 0.0f;
    private transient float rotation = 0.0f;
    private transient float velocity = 0.0f;
    private transient long previousTick = -1L;
    private transient boolean open = false;
    private transient int lastPower = -1;

    public MysteryBoxTileEntity() {
        super((TileEntityType)TileEntityRegistration.MYSTERY_BOX.get());
        this.resetValues();
    }

    public void resetValues() {
        this.openUntil = -1L;
        this.nextOpenTime = -1L;
        this.lastOpenTime = -1L;
        this.scrapsTotal = this.scrapsLeft = PixelmonConfigProxy.getSpawning().getMeltanBoxInitialScrapsCount();
    }

    public boolean isOpen() {
        return this.openUntil > System.currentTimeMillis();
    }

    public boolean canOpen() {
        return this.scrapsLeft <= 0 && !this.isOpen() && !this.isOnCooldown();
    }

    public boolean isOnCooldown() {
        return this.nextOpenTime > System.currentTimeMillis();
    }

    public void removeCooldown() {
        this.nextOpenTime = -1L;
    }

    public boolean tryOpen(PlayerEntity player, BlockState state, ItemStack item) {
        MysteryBoxEvent.Open.Pre pre = new MysteryBoxEvent.Open.Pre(this, player, state, item, this.canOpen());
        if (!Pixelmon.EVENT_BUS.post((Event)pre) && pre.canOpen()) {
            this.lastOpenTime = System.currentTimeMillis();
            this.openUntil = this.lastOpenTime + PixelmonConfigProxy.getSpawning().getMeltanBoxOpenDurationMillis();
            this.nextOpenTime = this.openUntil + PixelmonConfigProxy.getSpawning().getMeltanBoxCooldownDurationMillis();
            this.scrapsLeft = this.scrapsTotal = (int)((double)this.scrapsTotal * PixelmonConfigProxy.getSpawning().getMeltanBoxScrapsMultiplier());
            MysteryBoxEvent.Open.Post post = new MysteryBoxEvent.Open.Post(this, player, state, item, this.lastOpenTime, this.openUntil, this.nextOpenTime, this.scrapsTotal, this.scrapsLeft);
            Pixelmon.EVENT_BUS.post((Event)post);
            this.lastOpenTime = post.getLastOpenTime();
            this.openUntil = post.getOpenUntil();
            this.nextOpenTime = post.getNextOpenTime();
            this.scrapsTotal = post.getScrapsTotal();
            this.scrapsLeft = post.getScrapsLeft();
            this.func_70296_d();
            player.field_70170_p.func_184133_a(null, this.func_174877_v(), (SoundEvent)SoundRegistration.MYSTERY_BOX_OPEN.get(), SoundCategory.BLOCKS, 0.5f, 0.5f);
            return true;
        }
        return false;
    }

    public boolean feedScrap(PlayerEntity player, BlockState state, ItemStack item) {
        MysteryBoxEvent.Feed event;
        if (this.scrapsLeft > 0 && !Pixelmon.EVENT_BUS.post((Event)(event = new MysteryBoxEvent.Feed(this, player, state, item, this.scrapsLeft)))) {
            this.scrapsLeft = event.getScrapsLeft();
            --this.scrapsLeft;
            return true;
        }
        return false;
    }

    public int getPower() {
        if (!this.open) {
            return 0;
        }
        int power = this.isOpen() ? Math.max(1, (int)(15.0f * (float)(this.openUntil - System.currentTimeMillis()) / (float)(this.openUntil - this.lastOpenTime)) + 1) : 0;
        MysteryBoxEvent.ComparatorPower event = new MysteryBoxEvent.ComparatorPower(this, this.func_195044_w(), power);
        Pixelmon.EVENT_BUS.post((Event)event);
        return event.getPower();
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74772_a("LastOpenTime", this.lastOpenTime);
        nbt.func_74772_a("NextOpenTime", this.nextOpenTime);
        nbt.func_74772_a("OpenUntil", this.openUntil);
        nbt.func_74768_a("ScrapsTotal", this.scrapsTotal);
        nbt.func_74768_a("ScrapsLeft", this.scrapsLeft);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.lastOpenTime = nbt.func_74764_b("LastOpenTime") ? nbt.func_74763_f("LastOpenTime") : -1L;
        this.nextOpenTime = nbt.func_74764_b("NextOpenTime") ? nbt.func_74763_f("NextOpenTime") : -1L;
        this.openUntil = nbt.func_74764_b("OpenUntil") ? nbt.func_74763_f("OpenUntil") : -1L;
        this.scrapsTotal = nbt.func_74764_b("ScrapsTotal") ? nbt.func_74762_e("ScrapsTotal") : PixelmonConfigProxy.getSpawning().getMeltanBoxInitialScrapsCount();
        this.scrapsLeft = nbt.func_74764_b("ScrapsLeft") ? nbt.func_74762_e("ScrapsLeft") : PixelmonConfigProxy.getSpawning().getMeltanBoxInitialScrapsCount();
    }

    public void func_73660_a() {
        World level;
        if (this.isOpen() && !Pixelmon.EVENT_BUS.post((Event)new MysteryBoxEvent.Tick.Start(this, this.func_195044_w())) && (level = this.func_145831_w()) != null) {
            boolean nearlyClosed;
            long untilClose = this.openUntil - System.currentTimeMillis();
            boolean bl = nearlyClosed = untilClose <= 6000L;
            if (!nearlyClosed) {
                this.open = true;
                if (this.func_145831_w().func_201670_d()) {
                    if (System.currentTimeMillis() - this.lastOpenTime > 5000L && RandomHelper.getRandomChance(100)) {
                        level.func_195594_a((IParticleData)ParticleTypes.field_197598_I, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.9, (double)this.func_174877_v().func_177952_p() + 0.5, (RandomHelper.getRandom().nextDouble() - 0.5) * 0.75, 0.0, (RandomHelper.getRandom().nextDouble() - 0.5) * 0.75);
                    }
                } else {
                    MysteryBoxEvent.Tick.TrySpawn trySpawn = new MysteryBoxEvent.Tick.TrySpawn(this, this.func_195044_w(), PixelmonConfigProxy.getSpawning().getMeltanBoxSpawnRate());
                    if (!Pixelmon.EVENT_BUS.post((Event)trySpawn) && trySpawn.rollChance()) {
                        int r = PixelmonConfigProxy.getSpawning().getMeltanBoxSpawnRadius();
                        BlockPos initialPos = this.func_174877_v().func_177982_a(RandomHelper.getRandom().nextInt(r * 2) - r, 0, RandomHelper.getRandom().nextInt(r * 2) - r);
                        BlockPos pos = this.findYSpawnOffset(level, initialPos, r);
                        if (pos != null) {
                            PixelmonSpecies.MELTAN.getValue().ifPresent(meltan -> {
                                Pokemon toSpawn = PokemonFactory.create(meltan);
                                boolean shiny = PixelmonConfigProxy.getSpawning().getShinyRate((RegistryKey<World>)level.func_234923_W_()) > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getSpawning().getShinyRate((RegistryKey<World>)level.func_234923_W_()));
                                toSpawn.setShiny(shiny);
                                PixelmonEntity entity = toSpawn.getOrCreatePixelmon(level, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                                entity.setAggression(Aggression.TIMID);
                                if (!Pixelmon.EVENT_BUS.post((Event)new MysteryBoxEvent.Tick.DoSpawn(this, this.func_195044_w(), entity))) {
                                    level.func_217376_c((Entity)entity);
                                    level.func_184133_a(null, this.func_174877_v(), (SoundEvent)SoundRegistration.MYSTERY_BOX_SPAWN.get(), SoundCategory.BLOCKS, 1.0f, RandomHelper.getRandom().nextFloat());
                                    ((ServerWorld)level).func_195598_a((IParticleData)ParticleTypes.field_197598_I, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 15, (RandomHelper.getRandom().nextDouble() - 0.5) * 0.01, RandomHelper.getRandom().nextDouble() * 0.01, (RandomHelper.getRandom().nextDouble() - 0.5) * 0.01, 0.1);
                                }
                            });
                        }
                    }
                }
            } else if (this.open && !Pixelmon.EVENT_BUS.post((Event)new MysteryBoxEvent.Tick.AboutToClose(this, this.func_195044_w()))) {
                level.func_184133_a(null, this.func_174877_v(), (SoundEvent)SoundRegistration.MYSTERY_BOX_CLOSE.get(), SoundCategory.BLOCKS, 0.2f, 0.5f);
                this.open = false;
            }
        }
        this.updateSignal();
    }

    private BlockPos findYSpawnOffset(World level, BlockPos initialPos, int maxOffset) {
        if (this.isValidSpawn(level, initialPos)) {
            return initialPos;
        }
        BlockPos.Mutable offsetPos = initialPos.func_239590_i_();
        for (int offset = 1; offset < maxOffset; ++offset) {
            offsetPos.func_185336_p(initialPos.func_177956_o() + offset);
            if (this.isValidSpawn(level, (BlockPos)offsetPos)) {
                return offsetPos;
            }
            offsetPos.func_185336_p(initialPos.func_177956_o() - offset);
            if (!this.isValidSpawn(level, (BlockPos)offsetPos)) continue;
            return offsetPos;
        }
        return null;
    }

    private boolean isValidSpawn(World level, BlockPos pos) {
        boolean topIsAir = level.func_180495_p(pos).func_203425_a(Blocks.field_150350_a);
        boolean bottomIsNotAir = !level.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_150350_a);
        return topIsAir && bottomIsNotAir;
    }

    public float[] getOpenness() {
        long now = System.currentTimeMillis();
        if (this.isOpen()) {
            long openWindow = 5000L;
            long sinceOpen = this.previousTick - this.lastOpenTime;
            long untilClose = this.openUntil - now;
            float normalization = now - this.previousTick;
            if (sinceOpen < 5000L) {
                this.animTicker = 0.0f;
                this.previousTick = now;
                return new float[]{Math.min(1.0f, (float)sinceOpen / 5000.0f), 0.0f};
            }
            if (untilClose < 5000L) {
                this.animTicker = Math.max(0.0f, this.animTicker - 0.01f);
                this.velocity = 0.0f;
                this.rotation = (float)((double)this.rotation + Math.min((double)0.01f, (Math.PI * 2 - (double)this.rotation % (Math.PI * 2)) / 100.0) * (double)normalization);
                this.previousTick = now;
                return new float[]{Math.min(1.0f, (float)untilClose / 5000.0f) + this.animTicker, this.rotation};
            }
            this.animTicker += 0.004f;
            if (this.animTicker >= 1.8f) {
                this.animTicker = -1.8f;
            }
            this.velocity = Math.min(0.01f, this.velocity + 1.0E-6f * normalization);
            this.rotation += this.velocity * normalization;
            this.previousTick = now;
            return new float[]{1.0f + Math.abs(this.animTicker), this.rotation};
        }
        this.animTicker = 0.0f;
        this.rotation = 0.0f;
        this.velocity = 0.0f;
        this.previousTick = now;
        return new float[]{0.0f, 0.0f};
    }

    public void activate(PlayerEntity player, BlockState state, ItemStack item) {
        MysteryBoxEvent.Activate event = new MysteryBoxEvent.Activate(this, player, state, item, Items.field_234760_kn_);
        if (!Pixelmon.EVENT_BUS.post((Event)event)) {
            if (this.tryOpen(player, state, item)) {
                return;
            }
            if (this.isOnCooldown()) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("block.pixelmon.mystery_box.cooldown"), Util.field_240973_b_);
            } else if (item.func_77973_b() == event.getAcceptedItem()) {
                if (this.feedScrap(player, state, item)) {
                    if (!player.func_184812_l_()) {
                        item.func_190918_g(1);
                    }
                    player.field_70170_p.func_184133_a(null, this.func_174877_v(), this.scrapsLeft <= 0 ? (SoundEvent)SoundRegistration.MYSTERY_BOX_ADD_DONE.get() : (SoundEvent)SoundRegistration.MYSTERY_BOX_ADD.get(), SoundCategory.BLOCKS, 1.0f, 0.5f + RandomHelper.getRandom().nextFloat());
                }
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("block.pixelmon.mystery_box.scraps"), Util.field_240973_b_);
            }
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
        super.func_70296_d();
    }

    public void prepareForDrop() {
        this.openUntil = -1L;
    }

    protected void updateSignal() {
        Block block;
        int power = this.getPower();
        if (this.lastPower != power && (block = this.func_195044_w().func_177230_c()) instanceof MysteryBoxBlock) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, power);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
        this.lastPower = power;
    }
}

