/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.camera.movement;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.camera.CameraEntity;
import com.pixelmonmod.pixelmon.client.camera.CameraTarget;
import com.pixelmonmod.pixelmon.client.camera.movement.CameraMovement;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.tools.Matrix4f;
import com.pixelmonmod.pixelmon.tools.Vector4f;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class PositionedMovement
extends CameraMovement {
    int ticksToChange = 0;
    int currentPos = 0;
    ArrayList<BlockPos> cameraPositionList = new ArrayList();
    boolean initPokePos = false;
    boolean initDiagonals = false;

    public PositionedMovement(World worldObj, CameraEntity camera) {
        super(worldObj, camera);
    }

    @Override
    public void onLivingUpdate() {
        if ((this.initDiagonals || this.initPokePos) && this.camera.func_70089_S() && ClientProxy.battleManager.getViewEntity() != this.camera) {
            ClientProxy.battleManager.setViewEntity((Entity)this.camera);
            ClientProxy.camera = this.camera;
        }
        if (!PixelmonConfigProxy.getGraphics().isPlayerControlCamera() && this.cameraPositionList.size() > this.currentPos) {
            BlockPos cameraPosition = this.cameraPositionList.get(this.currentPos);
            if (!this.camera.func_233580_cy_().equals((Object)cameraPosition)) {
                this.camera.func_70107_b(cameraPosition.func_177958_n(), cameraPosition.func_177956_o(), cameraPosition.func_177952_p());
            }
        }
        if (!this.initPokePos && ClientProxy.battleManager.getUserPokemon(this.camera.mode) != null) {
            this.generateCameraPositionsForPokemon();
        }
        if (!this.initDiagonals && ClientProxy.battleManager.getUserPokemon(this.camera.mode) != null) {
            this.generateCameraDiagonalsForPlayer();
        }
        --this.ticksToChange;
        int positionListSize = this.cameraPositionList.size();
        if (this.ticksToChange <= 0 && positionListSize > 0) {
            Random random = this.world.field_73012_v;
            this.currentPos = random.nextInt(positionListSize);
            this.ticksToChange = random.nextInt(40) + 70;
        }
    }

    @Override
    public void generatePositions() {
        this.cameraPositionList.clear();
        this.initPokePos = false;
        this.initDiagonals = false;
        this.currentPos = 0;
        this.ticksToChange = this.world.field_73012_v.nextInt(100) + 80;
        if (ClientProxy.battleManager.getUserPokemon(this.camera.mode) != null) {
            if (!this.initPokePos) {
                this.generateCameraPositionsForPokemon();
            }
            if (!this.initDiagonals) {
                this.generateCameraDiagonalsForPlayer();
            }
        }
    }

    private void generateCameraPositionsForPokemon() {
        this.initPokePos = true;
        PixelmonEntity pix = ClientProxy.battleManager.getUserPokemon(this.camera.mode);
        if (pix != null) {
            BlockPos pokemonPos = pix.func_233580_cy_();
            PlayerEntity player = ClientProxy.battleManager.getViewPlayer();
            BlockPos playerPos = player.func_233580_cy_();
            for (int i = 0; i < 8; ++i) {
                BlockPos basePos = this.getRandomCameraPositionForPokemon(pokemonPos);
                Material mat = this.world.func_180495_p(basePos).func_185904_a();
                if (mat != Material.field_151579_a && mat != Material.field_151586_h || !this.canPosSee(basePos, playerPos)) continue;
                this.cameraPositionList.add(basePos);
            }
        }
        ClientProxy.battleManager.setViewEntity((Entity)this.camera);
    }

    private BlockPos getRandomCameraPositionForPokemon(BlockPos pokemonPos) {
        Random random = this.world.field_73012_v;
        int x = pokemonPos.func_177958_n() + random.nextInt(10) - 5;
        int y = pokemonPos.func_177956_o() + random.nextInt(7) + 1;
        int z = pokemonPos.func_177952_p() + random.nextInt(10) - 5;
        return new BlockPos(x, y, z);
    }

    private void generateCameraDiagonalsForPlayer() {
        PixelmonEntity pix = ClientProxy.battleManager.getUserPokemon(this.camera.mode);
        if (pix != null) {
            BlockPos pokemonPos = pix.func_233580_cy_();
            Vector3f pokemonVec = new Vector3f((float)pokemonPos.func_177958_n(), (float)pokemonPos.func_177956_o(), (float)pokemonPos.func_177952_p());
            pokemonVec.setY(pokemonVec.func_195900_b() + pix.func_70047_e());
            if (!this.checkDiagonals(pokemonVec)) {
                return;
            }
        }
        this.initDiagonals = true;
    }

    private boolean checkDiagonals(Vector3f pokemonVec) {
        PlayerEntity player = ClientProxy.battleManager.getViewPlayer();
        BlockPos playerPos = player.func_233580_cy_();
        Vector4f playerVec = new Vector4f(playerPos.func_177958_n(), playerPos.func_177956_o(), playerPos.func_177952_p(), 0.0f);
        playerVec.setY(playerVec.getY() + player.func_70047_e());
        Vector4f distanceVec = new Vector4f();
        Vector4f.sub(new Vector4f(playerVec), new Vector4f(pokemonVec), distanceVec);
        distanceVec.setY(0.0f);
        if (distanceVec.length() == 0.0f) {
            return false;
        }
        Vector4f firstDiag = distanceVec.copy().normalise(null);
        float angle = 0.3926991f;
        Vector4f perp = new Vector4f();
        Vector4f.cross(firstDiag, new Vector4f(0.0f, 1.0f, 0.0f, 0.0f), perp);
        Vector4f rotated = this.rotateRoundGround(firstDiag, perp, angle);
        perp = perp.normalise(null);
        for (int i = 0; i < 6; ++i) {
            this.generateDiagonalPos(playerPos, playerVec, rotated, perp);
        }
        return true;
    }

    private void generateDiagonalPos(BlockPos playerPos, Vector4f playerVec, Vector4f rotated, Vector4f perp) {
        Vector4f newPos = new Vector4f();
        Random random = this.world.field_73012_v;
        float scale = random.nextInt(2) + 3;
        Vector4f rotatedScaled = rotated.copy();
        rotatedScaled.mul(scale);
        scale = random.nextInt(9) - 4;
        Vector4f perpScaled = perp.copy();
        perpScaled.mul(scale);
        Vector4f.add(playerVec, rotatedScaled, newPos);
        Vector4f.add(newPos, perpScaled, newPos);
        BlockPos basePos = new BlockPos((double)newPos.getX(), (double)newPos.getY(), (double)newPos.getZ());
        Material mat = this.world.func_180495_p(basePos).func_185904_a();
        if ((mat == Material.field_151579_a || mat == Material.field_151586_h) && this.canPosSee(basePos, playerPos)) {
            this.cameraPositionList.add(basePos);
        }
    }

    private Vector4f rotateRoundGround(Vector4f vector, Vector4f rotateVector, float angle) {
        Matrix4f matrix = new Matrix4f();
        matrix.m03 = vector.x;
        matrix.m13 = vector.y;
        matrix.m23 = vector.z;
        Matrix4f.rotate(angle, rotateVector.to3f(), matrix, matrix);
        if (matrix.m13 < 0.0f) {
            return this.rotateRoundGround(vector, rotateVector, -1.0f * angle);
        }
        return new Vector4f(matrix.m03, matrix.m13, matrix.m23, 0.0f);
    }

    @Override
    public void setRandomPosition(CameraTarget t) {
        BlockPos randomPos = this.getRandomCameraPositionForPokemon(new BlockPos(t.getX(), t.getY(), t.getZ()));
        this.camera.func_70107_b(randomPos.func_177958_n(), randomPos.func_177956_o(), randomPos.func_177952_p());
    }

    @Override
    public void updatePositionAndRotation() {
        this.camera.field_70142_S = this.camera.func_226277_ct_();
        this.camera.field_70137_T = this.camera.func_226278_cu_() + this.camera.func_70033_W();
        this.camera.field_70136_U = this.camera.func_226281_cx_();
    }
}

