/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.badgecase;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.badgecase.BadgeCaseActionPacket;
import com.pixelmonmod.pixelmon.enums.items.EnumBadgeCase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class BadgeCaseScreen
extends Screen {
    private static final int[] X_VALUE = new int[]{50, 92, 133, 174};
    private ResourceLocation upTexture;
    private ResourceLocation downTexture;
    private ResourceLocation registerTexture;
    private ResourceLocation badgeCaseTexture;
    private Button buttonUp;
    private Button buttonRegister;
    private Button buttonDown;
    private final Button[] badgeButtons = new Button[8];
    private int page = 0;
    private int selectedBadge = -1;
    private String owner;
    boolean allowChanges;
    EnumBadgeCase color;
    List<ItemStack> badges;
    public Pokemon[] party = new Pokemon[6];
    private boolean custom;
    private static final int SPRITE_HEIGHT = 40;
    private static final int SPRITE_WIDTH = 40;
    private static final int POKEBALL_HEIGHT = 43;
    private static final int POKEBALL_WIDTH = 44;

    public BadgeCaseScreen(String owner, boolean allowChanges, boolean custom, EnumBadgeCase color, List<ItemStack> badges, Pokemon[] party) {
        super(StringTextComponent.field_240750_d_);
        this.updateBadgeCase(owner, allowChanges, custom, color, badges, party);
    }

    public void func_231160_c_() {
        int buttonID = 0;
        int xOffset = (this.field_230708_k_ - 252) / 2;
        int yOffset = 2;
        this.buttonUp = new IndexedButton(buttonID++, xOffset + 37, yOffset + 208, 42, 20, StringTextComponent.field_240750_d_, p_onPress_1_ -> {});
        this.buttonDown = new IndexedButton(buttonID++, xOffset + 79, yOffset + 208, 42, 20, StringTextComponent.field_240750_d_, button -> {});
        this.buttonRegister = new IndexedButton(buttonID++, xOffset + 37, yOffset + 7, 80, 20, StringTextComponent.field_240750_d_, button -> {});
        for (int i = 0; i < 4; ++i) {
            this.badgeButtons[i] = new IndexedButton(buttonID, xOffset + X_VALUE[i], yOffset + 135, 33, 23, StringTextComponent.field_240750_d_, button -> {});
            this.badgeButtons[i + 4] = new IndexedButton(buttonID + 4, xOffset + X_VALUE[i], yOffset + 168, 33, 23, StringTextComponent.field_240750_d_, button -> {});
        }
        this.func_230480_a_((Widget)this.buttonUp);
        this.func_230480_a_((Widget)this.buttonDown);
        this.func_230480_a_((Widget)this.buttonRegister);
        for (Button badgeButton : this.badgeButtons) {
            this.func_230480_a_((Widget)badgeButton);
        }
        if (!this.allowChanges) {
            this.buttonRegister.field_230693_o_ = false;
            Arrays.stream(this.badgeButtons).forEach(badge -> {
                badge.field_230693_o_ = false;
            });
        }
        if (this.owner != null && !this.owner.isEmpty()) {
            this.buttonRegister.field_230693_o_ = false;
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int i;
        int textColor;
        if (this.field_230706_i_ == null) {
            return;
        }
        int guiWidth = 210;
        int guiHeight = 235;
        int xOffset = (this.field_230708_k_ - 205) / 2;
        int yOffset = 2;
        this.field_230706_i_.func_110434_K().func_110577_a(this.badgeCaseTexture);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)xOffset, (int)yOffset, (float)0.0f, (float)0.0f, (int)210, (int)235, (int)210, (int)235);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.upTexture);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(xOffset + 17), (int)(yOffset + 208), (float)0.0f, (float)0.0f, (int)40, (int)14, (int)40, (int)14);
        this.field_230706_i_.func_110434_K().func_110577_a(this.downTexture);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(xOffset + 59), (int)(yOffset + 208), (float)0.0f, (float)0.0f, (int)40, (int)14, (int)40, (int)14);
        if (this.buttonRegister.field_230693_o_) {
            this.field_230706_i_.func_110434_K().func_110577_a(this.registerTexture);
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(xOffset + 16), (int)(yOffset + 10), (float)0.0f, (float)0.0f, (int)80, (int)14, (int)80, (int)14);
        }
        switch (this.color) {
            case Black: {
                textColor = 0x919191;
                break;
            }
            case Blue: {
                if (this.buttonRegister.field_230693_o_) {
                    textColor = 0x1919FF;
                    break;
                }
                textColor = 35020;
                break;
            }
            case Green: {
                textColor = 13064;
                break;
            }
            case Pink: {
                if (!this.buttonRegister.field_230693_o_) {
                    textColor = 0xFF99FF;
                    break;
                }
                textColor = 0xE600E6;
                break;
            }
            case Red: {
                if (this.buttonRegister.field_230693_o_) {
                    textColor = 0xB30000;
                    break;
                }
                textColor = 0xFF4D4D;
                break;
            }
            case White: 
            case Yellow: {
                textColor = 0;
                break;
            }
            default: {
                textColor = 1048575;
            }
        }
        if (this.buttonRegister.field_230693_o_) {
            BadgeCaseScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.badgecase.register", (Object[])new Object[0]), (int)(xOffset + 55), (int)(yOffset + 13), (int)textColor);
        } else {
            BadgeCaseScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)this.owner, (int)(xOffset + 55), (int)(yOffset + 13), (int)textColor);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int firstRowHeight = 32;
        int secondRowHeight = 64;
        int collum = 17;
        int offset = 27;
        this.drawPokemon(matrix, this.party[0], xOffset, yOffset, collum, firstRowHeight, collum + 2, firstRowHeight + 2);
        this.drawPokemon(matrix, this.party[3], xOffset, yOffset, collum += offset, secondRowHeight, collum + 2, secondRowHeight + 2);
        this.drawPokemon(matrix, this.party[1], xOffset, yOffset, collum += offset, firstRowHeight, collum + 2, firstRowHeight + 2);
        this.drawPokemon(matrix, this.party[4], xOffset, yOffset, collum += offset, secondRowHeight, collum + 2, secondRowHeight + 2);
        this.drawPokemon(matrix, this.party[2], xOffset, yOffset, collum += offset, firstRowHeight, collum + 2, firstRowHeight + 2);
        this.drawPokemon(matrix, this.party[5], xOffset, yOffset, collum += offset, secondRowHeight, collum + 2, secondRowHeight + 2);
        int count = 0;
        for (Button button : this.badgeButtons) {
            if (this.selectedBadge == this.page * 8 + count) {
                ScreenHelper.drawGradientRect(matrix, button.field_230690_l_, button.field_230691_m_, 1.0f, button.field_230690_l_ + button.func_230998_h_(), button.field_230691_m_ + button.func_238483_d_(), 0x46FFFFFF, 0x46FFFFFF);
            }
            if (this.page * 8 + count < this.badges.size() && button.func_231047_b_((double)mouseX, (double)mouseY)) {
                AbstractGui.func_238467_a_((MatrixStack)matrix, (int)button.field_230690_l_, (int)button.field_230691_m_, (int)(button.field_230690_l_ + button.func_230998_h_()), (int)(button.field_230691_m_ + button.func_238483_d_()), (int)0x32FFFFFF);
            }
            ++count;
        }
        for (i = 0; i < 8 && this.page * 8 + i != this.badges.size(); ++i) {
            int rowX = 34;
            int rowY = i < 4 ? 137 : 170;
            int rowOffset = 42;
            this.field_230706_i_.func_175599_af().func_180450_b(this.badges.get(this.page * 8 + i), xOffset + rowX + (i + 1 <= 4 ? i * rowOffset : (i - 4) * rowOffset), yOffset + rowY);
        }
        for (i = 0; i < 8; ++i) {
            ListNBT loreList;
            if (this.page * 8 + i >= this.badges.size() || !this.badgeButtons[i].func_231047_b_((double)mouseX, (double)mouseY)) continue;
            ItemStack badge = this.badges.get(this.page * 8 + i);
            ArrayList lore = Lists.newArrayList();
            if (badge.func_82837_s()) {
                lore.add(badge.func_200301_q());
            }
            if (badge.func_179543_a("display") != null && badge.func_179543_a("display").func_150297_b("Lore", 9) && !(loreList = badge.func_179543_a("display").func_150295_c("Lore", 8)).isEmpty()) {
                for (int l1 = 0; l1 < loreList.size(); ++l1) {
                    lore.add(ITextComponent.Serializer.func_240643_a_((String)loreList.func_150307_f(l1)));
                }
            }
            if (lore.isEmpty()) continue;
            this.func_243308_b(matrix, lore, mouseX, mouseY);
        }
    }

    protected void actionPerformed(Button button, int mouseButton) {
        if (button == this.buttonUp) {
            this.pageUp();
            return;
        }
        if (button == this.buttonDown) {
            this.pageDown();
            return;
        }
        if (!this.allowChanges) {
            return;
        }
        if (button == this.buttonRegister) {
            if (this.buttonRegister.field_230693_o_) {
                NetworkHelper.sendToServer(new BadgeCaseActionPacket(BadgeCaseActionPacket.Action.REGISTER, this.custom));
                this.buttonRegister.field_230693_o_ = false;
            }
        } else {
            for (int i = 0; i < this.badgeButtons.length; ++i) {
                if (button != this.badgeButtons[i] || this.badges.size() < this.page * 8 + 1) continue;
                if (mouseButton == 0) {
                    if (this.selectedBadge == -1) {
                        this.selectedBadge = this.page * 8 + i;
                        continue;
                    }
                    NetworkHelper.sendToServer(new BadgeCaseActionPacket(this.selectedBadge, this.page * 8 + i, this.custom));
                    this.selectedBadge = -1;
                    continue;
                }
                if (mouseButton != 1) continue;
                NetworkHelper.sendToServer(new BadgeCaseActionPacket(this.page * 8 + i, this.custom));
                this.selectedBadge = -1;
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        for (Widget widget : this.field_230710_m_) {
            if (!(widget instanceof Button) || !widget.func_231047_b_(mouseX, mouseY)) continue;
            Button button = (Button)widget;
            GuiScreenEvent.MouseClickedEvent.Pre event = new GuiScreenEvent.MouseClickedEvent.Pre((Screen)this, mouseX, mouseY, mouseButton);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
            widget.func_230988_a_(this.field_230706_i_.func_147118_V());
            this.actionPerformed(button, mouseButton);
            if (((Object)((Object)this)).equals(this.field_230706_i_.field_71462_r)) {
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.MouseClickedEvent.Post((Screen)this, mouseX, mouseY, mouseButton));
            }
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_151445_Q.isActiveAndMatches(InputMappings.func_197954_a((int)keyCode, (int)scanCode))) {
            mc.func_147108_a(null);
            if (mc.field_71462_r == null) {
                mc.func_213228_a(true);
                return true;
            }
        } else {
            return super.func_231046_a_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void pageDown() {
        if ((this.page + 1) * 8 >= this.badges.size()) {
            return;
        }
        ++this.page;
    }

    private void pageUp() {
        if (this.page == 0) {
            return;
        }
        --this.page;
    }

    private void drawPokemon(MatrixStack stack, Pokemon pokemon, int xOffset, int yOffset, int ballX, int ballY, int pokeX, int pokeY) {
        if (pokemon != null) {
            this.field_230706_i_.func_110434_K().func_110577_a(pokemon.getBall().getGUISprite());
            AbstractGui.func_238466_a_((MatrixStack)stack, (int)(xOffset + ballX), (int)(yOffset + ballY), (int)0, (int)0, (float)44.0f, (float)43.0f, (int)36, (int)36, (int)44, (int)43);
            ScreenHelper.bindPokemonSprite(pokemon, Minecraft.func_71410_x());
            AbstractGui.func_238466_a_((MatrixStack)stack, (int)(xOffset + pokeX), (int)(yOffset + pokeY - 3), (int)0, (int)0, (float)40.0f, (float)40.0f, (int)36, (int)36, (int)40, (int)40);
        }
    }

    public void updateBadgeCase(String owner, boolean allowChanges, boolean custom, EnumBadgeCase color, List<ItemStack> badges, Pokemon[] party) {
        this.owner = owner;
        this.allowChanges = allowChanges;
        this.custom = custom;
        this.color = color;
        this.badges = badges;
        if (party.length == 6) {
            this.party = party;
        }
        this.badgeCaseTexture = ResourceLocationHelper.of(Resources.prefix + "gui/badgecases/badgecase_" + color.toString().toLowerCase(Locale.ROOT) + ".png");
        this.upTexture = ResourceLocationHelper.of(Resources.prefix + "gui/badgecases/up_button_" + color.toString().toLowerCase(Locale.ROOT) + ".png");
        this.downTexture = ResourceLocationHelper.of(Resources.prefix + "gui/badgecases/down_button_" + color.toString().toLowerCase(Locale.ROOT) + ".png");
        this.registerTexture = ResourceLocationHelper.of(Resources.prefix + "gui/badgecases/register_" + color.toString().toLowerCase(Locale.ROOT) + ".png");
    }
}

