/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BagSection;
import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.enums.TriBoolean;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.CursorHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClauseRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.tasks.BattleMessagePacket;
import com.pixelmonmod.pixelmon.battles.tasks.BattleTaskPacket;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.camera.CameraEntity;
import com.pixelmonmod.pixelmon.client.camera.CameraMode;
import com.pixelmonmod.pixelmon.client.camera.CameraTarget;
import com.pixelmonmod.pixelmon.client.camera.CameraTargetEntity;
import com.pixelmonmod.pixelmon.client.gui.EvolveScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.AttackData;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.EvoInfo;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.battles.tasks.AFKTask;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.LevelUpPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ChooseAttackPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EnforcedRevivePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.FleePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ParticipantReadyPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SwitchPokemonPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.ItemData;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.tools.Quadstate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ClientBattleManager {
    public static final Timer TIMER = new Timer("ClientBattleTimer");
    public int battleControllerIndex = -1;
    protected AtomicReference<BattleMode> mode = new AtomicReference();
    protected BattleMode oldMode;
    public BagSection bagSection;
    public boolean battleEnded = true;
    public boolean isSpectating = false;
    @Nonnull
    private TriBoolean isProcessingTask = TriBoolean.NULL;
    private final Deque<BattleTaskPacket> battleTasks = new ArrayDeque<BattleTaskPacket>();
    private final List<BattleTaskPacket> parallelTasks = new ArrayList<BattleTaskPacket>();
    public UUID[] teamPokemon;
    public PixelmonClientData[] displayedEnemyPokemon;
    public PixelmonClientData[] displayedOurPokemon;
    public PixelmonClientData[] displayedAllyPokemon;
    public List<PixelmonClientData> fullOurPokemon;
    public ArrayList<LevelUpPacket> levelUpList = new ArrayList(6);
    public ArrayList<AttackData> newAttackList = new ArrayList();
    public int startIndex = 0;
    public ItemData itemToUse;
    public Pair<BagSection, ItemData> lastItem;
    public Map<BagSection, List<ItemData>> sections = Maps.newHashMap();
    public AbstractPixelmonPacket sendPacket;
    public BattleMode yesNoOrigin;
    public List<EvoInfo> evolveList = new ArrayList<EvoInfo>(6);
    public boolean isHealing = false;
    public boolean enforcedFleeFailed = false;
    public boolean preventFleeOnSwitch = false;
    public int healAmount = 0;
    public int selectedAttack = -1;
    public int currentPokemon = -1;
    public boolean[][] targetted = new boolean[2][];
    public boolean choosingPokemon;
    public int battleTurn;
    public StatusType weather;
    public StatusType terrain;
    public int catchCombo;
    public ArrayList<AbstractPixelmonPacket> selectedActions = new ArrayList();
    public BattleType battleType;
    public boolean afkOn;
    public boolean afkActive;
    public int afkActivate;
    public int afkTurn;
    public int afkTime;
    private AFKTask afkTask;
    public boolean waitingText;
    public boolean megaEvolving;
    public boolean dynamaxing;
    public UUID megaEvolution = null;
    public UUID ultraBurst = null;
    public UUID dynamax = null;
    public boolean hasUltraBurst = false;
    public boolean hasDynamaxed = false;
    public int dynamaxTurnsLeft = 0;
    public boolean dynamaxDisabled = false;
    public boolean gigantamax = false;
    public boolean showZMoves = false;
    public boolean usedZMove = false;
    private int pokeballEntityId = -1;
    public Quadstate oldGen = Quadstate.NO;
    public BattleRules rules = new BattleRules();
    public boolean canSwitch = true;
    public boolean canFlee = true;
    public ParticipantType[][] battleSetup;
    public boolean healFinished = false;
    int ticksSincePicked = 0;
    public ArrayList<UUID> pokemonToChoose;
    private List<Boolean> canSwitchList;
    public UUID spectatingUUID;
    private PlayerEntity spectating;
    private PointOfView pov = PointOfView.FIRST_PERSON;

    public boolean isBattling() {
        return this.battleControllerIndex != -1 && !this.battleEnded && !this.isSpectating;
    }

    public void addMessage(String s) {
        this.battleTasks.add(new BattleMessagePacket((ITextComponent)new StringTextComponent(s)));
    }

    public void addMessage(String key, Object ... arguments) {
        this.battleTasks.add(new BattleMessagePacket((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)key, (Object[])arguments))));
    }

    @Nullable
    public BattleTaskPacket getNextBattleTask() {
        return this.battleTasks.peek();
    }

    public void removeBattleTask() {
        this.battleTasks.poll();
        this.isProcessingTask = TriBoolean.NULL;
        this.checkClearedMessages();
    }

    public boolean hasMoreMessages() {
        return this.battleTasks.stream().anyMatch(it -> it instanceof BattleMessagePacket);
    }

    public boolean hasMoreTasks() {
        return !this.battleTasks.isEmpty();
    }

    public void addBattleMessage(BattleTaskPacket message) {
        this.battleTasks.add(message);
    }

    public void processBattleTasks() {
        this.parallelTasks.removeIf(it -> !it.process(this));
        if (this.isProcessingTask == TriBoolean.FALSE) {
            return;
        }
        this.isProcessingTask = TriBoolean.TRUE;
        if (this.getNextBattleTask() != null) {
            BattleTaskPacket task = this.getNextBattleTask();
            if (!task.shouldRunParallel()) {
                BattleTaskPacket next;
                boolean shouldContinue = task.process(this);
                boolean removed = false;
                if (!shouldContinue) {
                    this.isProcessingTask = TriBoolean.FALSE;
                    if (!(task instanceof BattleMessagePacket) || ((BattleMessagePacket)task).isRead()) {
                        this.removeBattleTask();
                        removed = true;
                    }
                }
                Iterator<BattleTaskPacket> i = this.battleTasks.iterator();
                if (!removed) {
                    i.next();
                }
                while (i.hasNext() && (next = i.next()).shouldRunParallel()) {
                    if (!this.parallelTasks.stream().noneMatch(it -> Objects.equals(it.getPokemonID(), next.getPokemonID()))) continue;
                    this.parallelTasks.add(next);
                    i.remove();
                }
            } else if (this.parallelTasks.stream().noneMatch(it -> Objects.equals(it.getPokemonID(), task.getPokemonID()))) {
                this.parallelTasks.add(task);
                task.process(this);
                this.isProcessingTask = TriBoolean.FALSE;
                if (!(this.getNextBattleTask() instanceof BattleMessagePacket)) {
                    this.removeBattleTask();
                }
            }
        }
    }

    public boolean isProcessingTask() {
        return !this.battleTasks.isEmpty() && this.isProcessingTask == TriBoolean.TRUE;
    }

    public void sendParticipantReady() {
        if (!this.isSpectating && !this.hasMoreMessages() && this.battleTasks.isEmpty()) {
            NetworkHelper.sendToServer(new ParticipantReadyPacket(this.battleControllerIndex, Minecraft.func_71410_x().field_71439_g.func_110124_au()));
        }
    }

    public void checkClearedMessages() {
        if (this.isProcessingTask == TriBoolean.FALSE) {
            this.removeBattleTask();
        }
        if (!(this.hasMoreTasks() || !this.parallelTasks.isEmpty() || this.getMode() != BattleMode.WAITING && this.getMode() != BattleMode.MAIN_MENU || this.choosingPokemon || this.hasLevelUps())) {
            this.sendParticipantReady();
            if (this.afkOn) {
                this.resetAFKTime();
            }
        }
    }

    public PixelmonClientData getCurrentPokemon() {
        if (this.currentPokemon != -1) {
            if (this.battleControllerIndex == -1 && ClientStorageManager.party.get(this.currentPokemon) != null) {
                return new PixelmonClientData(ClientStorageManager.party.get(this.currentPokemon));
            }
            if (this.fullOurPokemon == null) {
                return null;
            }
            if (this.teamPokemon != null) {
                if (this.currentPokemon < this.teamPokemon.length) {
                    for (PixelmonClientData pig : this.fullOurPokemon) {
                        if (!this.teamPokemon[this.currentPokemon].equals(pig.pokemonUUID)) continue;
                        return pig;
                    }
                }
            } else {
                return this.fullOurPokemon.get(this.currentPokemon);
            }
        }
        return null;
    }

    public PixelmonEntity getUserPokemon() {
        return this.getUserPokemon(CameraMode.Battle);
    }

    public PixelmonEntity getUserPokemon(CameraMode mode) {
        if (mode == CameraMode.Battle) {
            if ((this.currentPokemon != -1 || this.isSpectating) && this.teamPokemon != null && this.teamPokemon.length > 0) {
                if (this.currentPokemon == -1) {
                    this.currentPokemon = 0;
                }
                int pokemonIndex = Math.min(this.currentPokemon, this.teamPokemon.length - 1);
                return this.getEntity(this.teamPokemon[pokemonIndex]);
            }
        } else if (mode == CameraMode.Evolution) {
            return EvolveScreen.currentPokemon;
        }
        return null;
    }

    public PixelmonEntity getEntity(UUID uuid) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            for (Entity e : mc.field_71441_e.func_217416_b()) {
                PixelmonEntity pokemon;
                if (!(e instanceof PixelmonEntity) || !(pokemon = (PixelmonEntity)e).getPokemon().getUUID().equals(uuid)) continue;
                return pokemon;
            }
        }
        return null;
    }

    public boolean hasLevelUps() {
        return !this.levelUpList.isEmpty();
    }

    public boolean hasNewAttacks() {
        return !this.newAttackList.isEmpty();
    }

    public void startBattle(int battleControllerIndex, ParticipantType[][] battleSetup, int afkActivate, int afkTurn, BattleRules rules) {
        Minecraft.func_71410_x().field_71439_g.field_70144_Y = 1.0f;
        this.battleControllerIndex = battleControllerIndex;
        this.battleSetup = battleSetup;
        this.rules = rules;
        this.displayedOurPokemon = null;
        this.displayedEnemyPokemon = null;
        this.displayedAllyPokemon = null;
        this.fullOurPokemon = null;
        this.teamPokemon = null;
        this.targetted = new boolean[2][];
        this.setMode(BattleMode.WAITING);
        this.canSwitch = true;
        this.canFlee = true;
        this.battleEnded = false;
        this.megaEvolution = null;
        this.megaEvolving = false;
        this.dynamaxing = false;
        this.dynamax = null;
        this.hasDynamaxed = false;
        this.gigantamax = false;
        this.hasUltraBurst = false;
        this.ultraBurst = null;
        this.showZMoves = false;
        this.usedZMove = false;
        if (afkActivate == -1) {
            this.afkOn = false;
        } else {
            this.afkOn = true;
            this.afkActivate = afkActivate;
            this.afkTurn = afkTurn;
            this.afkActive = false;
            this.resetAFKTime();
        }
        this.battleTasks.clear();
        this.isProcessingTask = TriBoolean.NULL;
    }

    public void startSpectate(BattleType battleType) {
        Minecraft.func_71410_x().field_71439_g.field_70144_Y = 1.0f;
        ClientProxy.battleManager.isSpectating = true;
        ClientProxy.battleManager.battleType = battleType;
        this.spectating = null;
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147108_a((Screen)new BattleScreen());
    }

    public void endSpectate() {
        if (ClientProxy.battleManager.isSpectating) {
            Minecraft.func_71410_x().field_71439_g.field_70144_Y = 0.0f;
            ClientProxy.battleManager.isSpectating = false;
            ClientProxy.battleManager.battleEnded = true;
            this.spectating = null;
            this.spectatingUUID = null;
            this.resetViewEntity();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !this.battleEnded) {
            this.tick();
        }
    }

    private void tick() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (!(minecraft.field_71462_r instanceof BattleScreen) && minecraft.field_71439_g != null) {
            minecraft.func_147108_a((Screen)new BattleScreen());
        }
        if (this.ticksSincePicked > 0) {
            --this.ticksSincePicked;
        }
        boolean doCameraTick = true;
        if (ClientProxy.camera != null) {
            CameraTarget tar = ClientProxy.camera.getCameraTarget();
            if (tar != null) {
                PixelmonEntity userPokemon = this.getUserPokemon();
                if (tar.getTargetData() == userPokemon && (userPokemon == null || !userPokemon.func_70089_S() || userPokemon.func_110143_aJ() <= 0.0f)) {
                    this.setCameraToPlayer();
                    doCameraTick = false;
                }
            } else {
                this.setCameraToPlayer();
            }
        }
        if (PixelmonConfigProxy.getGraphics().isUseBattleCamera() && doCameraTick && this.ticksSincePicked <= 0 && this.getUserPokemon() != null) {
            Entity viewEntity = minecraft.func_175606_aa();
            if (viewEntity instanceof CameraEntity && viewEntity != ClientProxy.camera) {
                minecraft.func_175607_a((Entity)ClientProxy.camera);
            }
            this.setCameraToPixelmon();
        }
    }

    public void restoreSettingsAndClose() {
        Minecraft.func_71410_x().field_71439_g.field_70144_Y = 0.0f;
        this.battleEnded = true;
        if (this.afkTask != null) {
            this.afkTask.cancel();
        }
        this.afkOn = false;
        this.catchCombo = 0;
        this.resetViewEntity();
        this.spectating = null;
        this.spectatingUUID = null;
        this.selectedActions.clear();
        this.enforcedFleeFailed = false;
        this.preventFleeOnSwitch = true;
        this.megaEvolution = null;
        this.dynamax = null;
        this.megaEvolving = false;
        this.dynamaxing = false;
        this.hasDynamaxed = false;
        this.gigantamax = false;
        this.hasUltraBurst = false;
        this.ultraBurst = null;
        this.showZMoves = false;
        this.usedZMove = false;
        this.setMode(BattleMode.MAIN_MENU);
        this.isProcessingTask = TriBoolean.NULL;
        this.battleTasks.clear();
        this.parallelTasks.clear();
        this.displayedOurPokemon = null;
        this.displayedAllyPokemon = null;
        this.fullOurPokemon = null;
        this.teamPokemon = null;
        this.battleControllerIndex = -1;
        this.newAttackList.clear();
        this.levelUpList.clear();
        this.weather = null;
        this.terrain = null;
        this.dynamaxDisabled = false;
    }

    public boolean canCatchOpponent() {
        for (int i = 0; i < this.battleSetup[1].length; ++i) {
            ParticipantType t = this.battleSetup[1][i];
            if (t != ParticipantType.WildPokemon || !this.displayedEnemyPokemon[i].bossTier.isNotBoss() || this.displayedEnemyPokemon[i].blockCapture) continue;
            return true;
        }
        return false;
    }

    public boolean isOpponentWildNotBoss() {
        for (int i = 0; i < this.battleSetup[1].length; ++i) {
            ParticipantType t = this.battleSetup[1][i];
            if (t != ParticipantType.WildPokemon || !this.displayedEnemyPokemon[i].bossTier.isNotBoss()) continue;
            return true;
        }
        return false;
    }

    public boolean canRunFromBattle() {
        for (int i = 0; i < this.battleSetup[1].length; ++i) {
            ParticipantType t = this.battleSetup[1][i];
            if (t != ParticipantType.WildPokemon) continue;
            return this.canFlee;
        }
        return !this.rules.hasClause(BattleClauseRegistry.FORFEIT_CLAUSE);
    }

    public boolean canForfeit() {
        for (int i = 0; i < this.battleSetup[1].length; ++i) {
            ParticipantType t = this.battleSetup[1][i];
            if (t == ParticipantType.WildPokemon) continue;
            return true;
        }
        return false;
    }

    public PlayerEntity getViewPlayer() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (this.isSpectating && this.spectatingUUID != null) {
            if (this.spectating == null) {
                this.spectating = minecraft.field_71441_e.func_217371_b(this.spectatingUUID);
            }
            if (this.spectating != null) {
                return this.spectating;
            }
        }
        return minecraft.field_71439_g;
    }

    public void startPicking(List<Boolean> canSwitch, boolean canFlee, ArrayList<UUID> pokemonToChoose) {
        this.setCameraToPlayer();
        this.ticksSincePicked = 50;
        if (!this.isSpectating) {
            this.canSwitchList = canSwitch;
            this.canFlee = canFlee;
            this.setMode(BattleMode.MAIN_MENU, BattleMode.MAIN_MENU);
            this.pokemonToChoose = pokemonToChoose;
            for (int i = 0; i < this.teamPokemon.length; ++i) {
                UUID uuid = this.teamPokemon[i];
                if (!this.fullOurPokemon.stream().anyMatch(p -> p.pokemonUUID.equals(uuid)) || !this.hasTurn(uuid)) continue;
                this.currentPokemon = i;
                int idx = pokemonToChoose.indexOf(uuid);
                this.canSwitch = this.canSwitchList.get(idx);
                break;
            }
            if (this.hasDynamaxed) {
                --this.dynamaxTurnsLeft;
            }
        }
        if (this.displayedOurPokemon != null) {
            for (PixelmonClientData pig : this.displayedOurPokemon) {
                if (pig == null) continue;
                pig.isSwitchingIn = false;
                pig.isSwitchingOut = false;
            }
        }
    }

    private boolean hasTurn(UUID uuid) {
        for (UUID pokemonUUID : this.pokemonToChoose) {
            if (!pokemonUUID.equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public void selectedMove() {
        this.selectedMove(false);
    }

    public void selectedMove(boolean isEnforcedSwitch) {
        this.afkActive = false;
        this.megaEvolving = false;
        this.dynamaxing = false;
        this.showZMoves = false;
        if (!isEnforcedSwitch && this.teamPokemon.length > this.currentPokemon + 1 && this.teamPokemon.length > this.selectedActions.size()) {
            int prevCurrentPokemon = this.currentPokemon;
            for (int i = this.currentPokemon + 1; i < this.teamPokemon.length; ++i) {
                UUID uuid = this.teamPokemon[i];
                if (this.fullOurPokemon.stream().anyMatch(p -> p.pokemonUUID.equals(uuid))) {
                    if (!this.hasTurn(uuid)) continue;
                    this.currentPokemon = i;
                    int idx = this.pokemonToChoose.indexOf(uuid);
                    this.canSwitch = this.canSwitchList.get(idx);
                    break;
                }
                this.finishSelection();
                return;
            }
            if (prevCurrentPokemon == this.currentPokemon) {
                this.finishSelection();
                return;
            }
            this.setMode(BattleMode.MAIN_MENU);
        } else {
            this.finishSelection();
        }
    }

    public void afkSelectMove() {
        if (this.getMode() != BattleMode.WAITING) {
            if (this.getMode() == BattleMode.ENFORCED_SWITCH) {
                ArrayList<PixelmonClientData> inBattle = new ArrayList<PixelmonClientData>(3);
                if (this.teamPokemon != null) {
                    for (UUID uuid : this.teamPokemon) {
                        for (PixelmonClientData pig : this.fullOurPokemon) {
                            if (!pig.pokemonUUID.equals(uuid)) continue;
                            inBattle.add(pig);
                        }
                    }
                    PixelmonClientData currentData = (PixelmonClientData)inBattle.get(this.currentPokemon % inBattle.size());
                    this.selectedActions.add(new SwitchPokemonPacket(null, this.battleControllerIndex, currentData.pokemonUUID, true));
                }
            } else if (this.getMode() == BattleMode.ENFORCED_REVIVE) {
                Attack attack = this.getCurrentPokemon().moveset.get(this.selectedAttack);
                if (attack != null && attack.isAttack(AttackRegistry.REVIVAL_BLESSING)) {
                    this.selectedActions.add(new EnforcedRevivePacket(null));
                }
            } else {
                for (int i = this.currentPokemon; i < this.teamPokemon.length; ++i) {
                    UUID uuid = this.teamPokemon[i];
                    if (!this.fullOurPokemon.stream().anyMatch(p -> p.pokemonUUID.equals(uuid)) || !this.hasTurn(uuid)) continue;
                    this.currentPokemon = i;
                    int idx = this.pokemonToChoose.indexOf(uuid);
                    this.canSwitch = this.canSwitchList.get(idx);
                    PixelmonClientData currentData = this.getCurrentPokemon();
                    AbstractPixelmonPacket action = currentData.health.get() <= 0.0 ? new SwitchPokemonPacket(null, this.battleControllerIndex, currentData.pokemonUUID, false) : new ChooseAttackPacket(this.getCurrentPokemon().pokemonUUID, new boolean[0][0], -1, this.battleControllerIndex, this.megaEvolving, this.dynamaxing);
                    this.megaEvolving = false;
                    this.showZMoves = false;
                    this.dynamaxing = false;
                    this.selectedActions.add(action);
                }
            }
            this.finishSelection();
        }
    }

    public void finishSelection() {
        this.setMode(BattleMode.WAITING);
        this.selectedActions.stream().filter(Objects::nonNull).forEach(Pixelmon.network::sendToServer);
        this.selectedActions.clear();
    }

    public void setTeamPokemon(UUID[] pokemon) {
        this.teamPokemon = pokemon;
        this.targetted[0] = new boolean[pokemon.length];
        if (this.displayedOurPokemon == null) {
            ArrayList<PixelmonClientData> ourPokemon = new ArrayList<PixelmonClientData>();
            for (UUID uuid : pokemon) {
                for (PixelmonClientData pig : this.fullOurPokemon) {
                    if (!pig.pokemonUUID.equals(uuid)) continue;
                    ourPokemon.add(pig);
                }
            }
            this.displayedOurPokemon = ourPokemon.toArray(new PixelmonClientData[0]);
            for (PixelmonClientData pig : this.displayedOurPokemon) {
                pig.xPos = 120;
            }
        }
    }

    public void setTeamPokemon(PixelmonClientData[] data) {
        if (this.displayedOurPokemon != null) {
            for (PixelmonClientData replacement : data) {
                for (PixelmonClientData current : this.displayedOurPokemon) {
                    if (!replacement.pokemonUUID.equals(current.pokemonUUID)) continue;
                    replacement.health.set(current.health.get());
                }
            }
        }
        for (PixelmonClientData replacement : data) {
            for (int i = 0; i < this.fullOurPokemon.size(); ++i) {
                PixelmonClientData pig = this.fullOurPokemon.get(i);
                if (!Objects.equals(pig.pokemonUUID, replacement.pokemonUUID)) continue;
                replacement.health.set(pig.health.get());
                this.fullOurPokemon.set(i, replacement);
            }
        }
        this.displayedOurPokemon = data;
        this.targetted[0] = new boolean[data.length];
        for (PixelmonClientData pig : this.displayedOurPokemon) {
            pig.xPos = 120;
        }
    }

    public void setOpponents(PixelmonClientData[] data) {
        if (this.displayedEnemyPokemon != null && data != null) {
            for (PixelmonClientData replacement : data) {
                for (PixelmonClientData current : this.displayedEnemyPokemon) {
                    if (!replacement.pokemonUUID.equals(current.pokemonUUID)) continue;
                    replacement.health.set(current.health.get());
                }
            }
        }
        this.displayedEnemyPokemon = data;
        this.targetted[1] = new boolean[this.displayedEnemyPokemon.length];
    }

    public void setTeamData(PixelmonClientData[] data) {
        if (this.displayedAllyPokemon != null && data != null) {
            for (PixelmonClientData replacement : data) {
                for (PixelmonClientData current : this.displayedAllyPokemon) {
                    if (!replacement.pokemonUUID.equals(current.pokemonUUID)) continue;
                    replacement.health.set(current.health.get());
                }
            }
        }
        this.displayedAllyPokemon = data;
        for (PixelmonClientData pig : this.displayedAllyPokemon) {
            pig.xPos = 120;
        }
    }

    public void setFullTeamData(PixelmonClientData[] data, boolean useOldPokemonHealth) {
        if (useOldPokemonHealth && this.fullOurPokemon != null) {
            for (PixelmonClientData replacement : data) {
                for (PixelmonClientData current : this.fullOurPokemon) {
                    if (!replacement.pokemonUUID.equals(current.pokemonUUID)) continue;
                    replacement.health.set(current.health.get());
                }
            }
        }
        this.fullOurPokemon = Lists.newArrayList((Object[])data);
        for (PixelmonClientData pig : this.fullOurPokemon) {
            pig.xPos = 120;
        }
    }

    public PixelmonClientData getUncontrolledTeamPokemon(UUID uuid) {
        if (this.displayedAllyPokemon == null) {
            return null;
        }
        for (PixelmonClientData data : this.displayedAllyPokemon) {
            if (!uuid.equals(data.pokemonUUID)) continue;
            return data;
        }
        return null;
    }

    public PixelmonClientData getPokemon(UUID uuid) {
        if (this.displayedOurPokemon != null) {
            for (PixelmonClientData pixelmonClientData : this.displayedOurPokemon) {
                if (!uuid.equals(pixelmonClientData.pokemonUUID)) continue;
                return pixelmonClientData;
            }
        }
        if (this.displayedEnemyPokemon != null) {
            for (PixelmonClientData pixelmonClientData : this.displayedEnemyPokemon) {
                if (!uuid.equals(pixelmonClientData.pokemonUUID)) continue;
                return pixelmonClientData;
            }
        }
        if (this.displayedAllyPokemon != null) {
            for (PixelmonClientData pixelmonClientData : this.displayedAllyPokemon) {
                if (!uuid.equals(pixelmonClientData.pokemonUUID)) continue;
                return pixelmonClientData;
            }
        }
        if (this.fullOurPokemon != null) {
            for (PixelmonClientData pig : this.fullOurPokemon) {
                if (!uuid.equals(pig.pokemonUUID)) continue;
                return pig;
            }
        }
        return null;
    }

    public boolean isEnemyPokemon(PixelmonClientData pokemon) {
        for (PixelmonClientData p : this.displayedEnemyPokemon) {
            if (p != pokemon) continue;
            return true;
        }
        return false;
    }

    public List<ItemData> getBagItems(BagSection section) {
        return this.sections.getOrDefault(section, Collections.emptyList());
    }

    public void setCameraToPixelmon() {
        if (ClientProxy.camera != null) {
            CameraTarget tar = ClientProxy.camera.getCameraTarget();
            if (tar != null) {
                PixelmonEntity userPokemon = this.getUserPokemon();
                if (tar.getTargetData() != userPokemon) {
                    if (tar instanceof CameraTargetEntity) {
                        tar.setTargetData(userPokemon);
                    } else if (!PixelmonConfigProxy.getGraphics().isPlayerControlCamera()) {
                        ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)userPokemon));
                    }
                }
            } else if (!PixelmonConfigProxy.getGraphics().isPlayerControlCamera()) {
                ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)Minecraft.func_71410_x().field_71439_g));
            }
        }
    }

    public void setCameraToPlayer() {
        if (ClientProxy.camera != null) {
            CameraTarget tar = ClientProxy.camera.getCameraTarget();
            if (tar != null) {
                if (tar.getTargetData() != this.getViewPlayer()) {
                    if (tar instanceof CameraTargetEntity) {
                        tar.setTargetData(this.getViewPlayer());
                    } else if (!PixelmonConfigProxy.getGraphics().isPlayerControlCamera()) {
                        ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)this.getViewPlayer()));
                    }
                }
            } else if (ClientProxy.camera == null || this.getViewPlayer() == null) {
                Pixelmon.LOGGER.warn("Problem finding battle camera.");
            } else {
                ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)this.getViewPlayer()));
            }
        }
    }

    public void setViewEntity(Entity entity) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_175607_a(entity);
        mc.field_71474_y.field_74319_N = true;
        this.pov = mc.field_71474_y.func_243230_g();
        mc.field_71474_y.func_243229_a(PointOfView.FIRST_PERSON);
        ForgeIngameGui.renderHotbar = false;
        ForgeIngameGui.renderCrosshairs = false;
        ForgeIngameGui.renderExperiance = false;
        ForgeIngameGui.renderAir = false;
        ForgeIngameGui.renderHealth = false;
        ForgeIngameGui.renderFood = false;
        ForgeIngameGui.renderArmor = false;
    }

    public Entity getViewEntity() {
        return Minecraft.func_71410_x().func_175606_aa();
    }

    public void resetViewEntity() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_175607_a((Entity)mc.field_71439_g);
        ForgeIngameGui.renderHotbar = true;
        ForgeIngameGui.renderCrosshairs = true;
        ForgeIngameGui.renderExperiance = true;
        ForgeIngameGui.renderAir = true;
        ForgeIngameGui.renderHealth = true;
        ForgeIngameGui.renderFood = true;
        ForgeIngameGui.renderArmor = true;
        mc.field_71474_y.field_74319_N = false;
        mc.field_71474_y.func_243229_a(this.pov);
        if (ClientProxy.camera != null) {
            ClientProxy.camera.func_70106_y();
        }
        ClientProxy.camera = null;
    }

    public void resetAFKTime() {
        this.setAFKTimer(this.afkActive ? this.afkTurn : this.afkActivate);
    }

    private void setAFKTimer(int time) {
        this.afkTime = time;
        if (this.afkTask != null) {
            this.afkTask.cancel();
        }
        this.afkTask = new AFKTask(this);
        TIMER.scheduleAtFixedRate((TimerTask)this.afkTask, 1000L, 1000L);
    }

    public void setTeamSelectTime() {
        if (this.rules.getOrDefault(BattleRuleRegistry.TEAM_SELECT) > 0) {
            this.afkOn = true;
            this.setAFKTimer(this.rules.getOrDefault(BattleRuleRegistry.TEAM_SELECT));
        } else {
            this.afkOn = false;
        }
    }

    public Optional<ItemData> getLastUsedItemIfStillAvailable() {
        List<ItemData> bag;
        if (this.lastItem != null && (bag = this.getBagItems((BagSection)this.lastItem.getKey())).contains(this.lastItem.getValue())) {
            return Optional.of(this.lastItem.getValue());
        }
        return Optional.empty();
    }

    public void selectRunAction(UUID pokemonUUID) {
        if (this.canForfeit()) {
            this.setMode(BattleMode.YES_NO_FORFEIT, this.getMode());
            CursorHelper.setCursor(CursorHelper.DEFAULT_CURSOR);
        } else {
            NetworkHelper.sendToServer(new FleePacket(pokemonUUID));
            this.setMode(BattleMode.WAITING);
        }
    }

    public boolean canMegaEvolve() {
        if (this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.RAID) {
            return false;
        }
        if (this.megaEvolution != null) {
            return false;
        }
        for (AbstractPixelmonPacket message : this.selectedActions) {
            if (!(message instanceof ChooseAttackPacket)) continue;
            ChooseAttackPacket attackMessage = (ChooseAttackPacket)message;
            if (attackMessage.megaEvolving) {
                return false;
            }
            if (!attackMessage.megaEvolving || attackMessage.pokemonUUID == null || this.getEntity(attackMessage.pokemonUUID).getSpecies().is(PixelmonSpecies.NECROZMA)) continue;
            return false;
        }
        return true;
    }

    public boolean canDynamax() {
        if (this.hasDynamaxed || this.dynamaxDisabled) {
            return false;
        }
        if (this.dynamax != null) {
            return false;
        }
        for (AbstractPixelmonPacket message : this.selectedActions) {
            if (!(message instanceof ChooseAttackPacket)) continue;
            ChooseAttackPacket attackMessage = (ChooseAttackPacket)message;
            if (!attackMessage.dynamaxing) continue;
            return false;
        }
        return true;
    }

    public boolean canMegaEvolve(PixelmonClientData pig) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        EnumMegaItem emi = EntityPlayerExtension.getPlayerMegaItem((PlayerEntity)player);
        if (emi == null) {
            return false;
        }
        return this.canMegaEvolve() && emi.canMega() && (pig.species.is(PixelmonSpecies.RAYQUAZA) && pig.moveset.hasAttack(AttackRegistry.DRAGON_ASCENT) && pig.heldItem.getHeldItemType() != EnumHeldItems.zCrystal || PixelmonWrapper.canMegaEvolve(pig.heldItem, pig.species, pig.form));
    }

    public boolean canUltraBurst() {
        if (this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.RAID) {
            return false;
        }
        if (this.hasUltraBurst) {
            return false;
        }
        for (AbstractPixelmonPacket message : this.selectedActions) {
            if (!(message instanceof ChooseAttackPacket)) continue;
            ChooseAttackPacket attackMessage = (ChooseAttackPacket)message;
            if (!attackMessage.megaEvolving || !this.getEntity(attackMessage.pokemonUUID).getSpecies().is(PixelmonSpecies.NECROZMA)) continue;
            return false;
        }
        return true;
    }

    public boolean canUltraBurst(PixelmonClientData pig) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        EnumMegaItem emi = EntityPlayerExtension.getPlayerMegaItem((PlayerEntity)player);
        if (emi == null) {
            return false;
        }
        if (pig.getBaseStats() == null) {
            return false;
        }
        return this.canUltraBurst() && emi.canMega() && pig.species.is(PixelmonSpecies.NECROZMA) && pig.species.getForm(pig.form).isForm("dusk", "dawn") && pig.heldItem == PixelmonItems.ultranecrozium_z;
    }

    public boolean canDynamax(PixelmonClientData pig) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        EnumMegaItem emi = EntityPlayerExtension.getPlayerMegaItem((PlayerEntity)player);
        if (emi == null || !emi.canDynamax() || !this.canDynamax()) {
            return false;
        }
        if (pig.species.is(PixelmonSpecies.GROUDON) && pig.heldItem == PixelmonItems.red_orb || pig.species.is(PixelmonSpecies.KYOGRE) && pig.heldItem == PixelmonItems.blue_orb) {
            return false;
        }
        if (pig.getBaseStats() == null) {
            return !pig.species.getDefaultForm().hasTag("cannot_dynamax");
        }
        return !pig.getBaseStats().hasTag("cannot_dynamax");
    }

    public boolean canUseZMove() {
        if (this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.RAID) {
            return false;
        }
        return !this.usedZMove;
    }

    public boolean canUseZMove(PixelmonClientData pig) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        EnumMegaItem emi = EntityPlayerExtension.getPlayerMegaItem((PlayerEntity)player);
        if (emi == null) {
            return false;
        }
        return this.canUseZMove() && emi.canMega() && pig.heldItem.getHeldItemType() == EnumHeldItems.zCrystal && !EntityPlayerExtension.getPlayerMegaItem((PlayerEntity)Minecraft.func_71410_x().field_71439_g).canDynamax();
    }

    public Optional<Entity> getPokeballEntity() {
        if (this.pokeballEntityId == -1) {
            return Optional.empty();
        }
        return Optional.ofNullable(Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(this.pokeballEntityId));
    }

    public void setPokeballEntityId(int pokeballEntityId) {
        this.pokeballEntityId = pokeballEntityId;
    }

    public void setMode(BattleMode mode) {
        BattleMode changedFrom = this.getMode();
        this.mode.set(mode);
        if (Pixelmon.LOG_BATTLE_SCREEN_MODE) {
            Pixelmon.LOGGER.debug("Changed battle screen mode from {} to {}", (Object)changedFrom, (Object)mode);
        }
    }

    public void setMode(BattleMode mode, BattleMode oldMode) {
        BattleMode changedFrom = this.getMode();
        this.oldMode = oldMode;
        this.mode.set(mode);
        if (Pixelmon.LOG_BATTLE_SCREEN_MODE) {
            Pixelmon.LOGGER.debug("Changed battle screen mode from {} to {} setting old mode to {}", (Object)changedFrom, (Object)mode, (Object)oldMode);
        }
    }

    public BattleMode getMode() {
        return this.mode.get();
    }

    public BattleMode getOldMode() {
        return this.oldMode;
    }
}

