/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.moveskills;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.StringTextComponent;

public class MoveSkillSelectScreen
extends Screen {
    int slot;
    Pokemon pokemon = null;
    ArrayList<MoveSkill> moveSkills = new ArrayList();
    int currentlySelectedIndex = -1;
    long mouseStationaryTime = System.currentTimeMillis();
    int lastMouseX = 0;
    int lastMouseY = 0;

    public MoveSkillSelectScreen(int slot) {
        super(StringTextComponent.field_240750_d_);
        this.slot = slot;
    }

    public void func_231160_c_() {
        MoveSkill selected;
        super.func_231160_c_();
        this.pokemon = ClientStorageManager.party.get(this.slot);
        if (this.pokemon == null) {
            this.field_230706_i_.field_71439_g.func_71053_j();
            return;
        }
        this.moveSkills = ClientProxy.getMoveSkills(this.pokemon);
        if (PixelmonOverlayScreen.selectedMoveSkill != null && (selected = CollectionHelper.find(this.moveSkills, moveSkill -> moveSkill.id.equals(PixelmonOverlayScreen.selectedMoveSkill))) != null) {
            this.currentlySelectedIndex = this.moveSkills.indexOf(selected);
        }
    }

    private int getIndexForPos(int mouseX, int mouseY) {
        mouseY = -1 * (mouseY - this.field_230709_l_ / 2);
        double quadrantAdjustment = (mouseX -= this.field_230708_k_ / 2) >= 0 && mouseY >= 0 ? 0.0 : (mouseX >= 0 && mouseY <= 0 ? Math.PI * 2 : Math.PI);
        double r = Math.sqrt(mouseX * mouseX + mouseY * mouseY);
        double theta = Math.atan(1.0 * (double)mouseY / (double)mouseX) + quadrantAdjustment;
        theta = ((theta - 1.5707963267948966) * 180.0 / Math.PI + 360.0) % 360.0;
        theta = 360.0 - theta;
        double wheelRadius = this.getWheelRadius();
        if (r < wheelRadius * 0.188 || r > wheelRadius * 0.9) {
            return -1;
        }
        if (this.moveSkills.isEmpty()) {
            return -1;
        }
        if (this.moveSkills.size() == 1) {
            return 0;
        }
        double radialWidth = 360.0 / (double)this.moveSkills.size();
        for (int i = 0; i < this.moveSkills.size(); ++i) {
            if (!(i == 0 ? theta > 360.0 - radialWidth / 2.0 || theta < 0.0 + radialWidth / 2.0 : theta > (double)i * radialWidth - radialWidth / 2.0 && theta < (double)i * radialWidth + radialWidth / 2.0)) continue;
            return i;
        }
        return -1;
    }

    public double getWheelRadius() {
        return 0.4 * (double)Math.min(this.field_230709_l_, this.field_230708_k_);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int i;
        int hovering = this.getIndexForPos(mouseX, mouseY);
        int focused = hovering;
        if (focused == -1) {
            focused = this.currentlySelectedIndex;
        }
        float wheelRadius = (float)this.getWheelRadius();
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.blendFunc((int)770, (int)771);
        ScreenHelper.drawImageQuad(Resources.moveSkillWheel, matrix, (float)this.field_230708_k_ / 2.0f - wheelRadius, (float)this.field_230709_l_ / 2.0f - wheelRadius, wheelRadius * 2.0f, wheelRadius * 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ScreenHelper.drawImageQuad(Resources.moveSkillWheelCenter, matrix, (float)this.field_230708_k_ / 2.0f - wheelRadius * 0.2f, (float)this.field_230709_l_ / 2.0f - wheelRadius * 0.2f, wheelRadius * 0.4f, wheelRadius * 0.4f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ScreenHelper.drawImageQuad(this.pokemon.getSprite(), matrix, (float)this.field_230708_k_ / 2.0f - wheelRadius * 0.2f, (float)this.field_230709_l_ / 2.0f - wheelRadius * 0.25f, wheelRadius * 0.4f, wheelRadius * 0.4f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        if (this.moveSkills.size() == 1) {
            this.drawMoveSkill(matrix, wheelRadius, 0.0f, this.moveSkills.get(0), true);
        } else {
            for (i = 0; i < this.moveSkills.size(); ++i) {
                this.drawMoveSkill(matrix, wheelRadius, 360.0f - (float)i * 360.0f / (float)this.moveSkills.size(), this.moveSkills.get(i), focused == i);
            }
        }
        if (focused != -1) {
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)((float)this.field_230708_k_ / 2.0f), (double)((float)this.field_230709_l_ / 2.0f), 0.0);
            matrix.func_227863_a_(QuaternionHelper.fromEuler(360.0f / (float)this.moveSkills.size() * (float)focused, 0.0f, 0.0f, 1.0f));
            ScreenHelper.drawImageQuad(Resources.moveSkillPointer, matrix, -wheelRadius / 10.0f, -wheelRadius * 0.4f, wheelRadius / 5.0f, wheelRadius / 5.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            matrix.func_227865_b_();
        }
        if (this.moveSkills.size() > 1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Resources.pcPointerGrabbed);
            for (i = 0; i < this.moveSkills.size(); ++i) {
                float angle = 360.0f / (float)this.moveSkills.size() * ((float)i + (this.moveSkills.size() % 2 == 0 ? 0.5f : 0.0f));
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)((float)this.field_230708_k_ / 2.0f), (double)((float)this.field_230709_l_ / 2.0f), 0.0);
                matrix.func_227863_a_(QuaternionHelper.fromEuler(angle, 0.0f, 0.0f, 1.0f));
                ScreenHelper.simpleDrawImageQuad(matrix, -wheelRadius / 250.0f, wheelRadius * 0.2f, wheelRadius / 125.0f, wheelRadius * 0.7f, 0.45f, 0.45f, 0.55f, 0.55f, 1.0f);
                matrix.func_227865_b_();
            }
        }
        if (mouseX == this.lastMouseX && mouseY == this.lastMouseY && System.currentTimeMillis() > this.mouseStationaryTime + 1250L && hovering != -1) {
            MoveSkill moveSkill = this.moveSkills.get(focused);
            StringBuilder str = new StringBuilder("\u00a7n" + I18n.func_135052_a((String)moveSkill.name, (Object[])new Object[0]));
            for (String description : moveSkill.descriptions) {
                str.append("\n\n\u00a7r").append(I18n.func_135052_a((String)description, (Object[])new Object[0]));
            }
            List<String> strings = ScreenHelper.splitString(str.toString(), this.field_230708_k_ - mouseX - 10);
            float maxWidth = 0.0f;
            for (String string : strings) {
                int width = this.field_230706_i_.field_71466_p.func_78256_a(string);
                if (!((float)width > maxWidth)) continue;
                maxWidth = width;
            }
            ScreenHelper.drawImageQuad(Resources.button, matrix, mouseX - 9, mouseY - 16, maxWidth + 20.0f, strings.size() * 9 + 17, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ScreenHelper.drawSplitString(matrix, str.toString(), mouseX + 3, mouseY - 7, this.field_230708_k_ - mouseX - 10, 0xFFFFFF);
        } else if (mouseX != this.lastMouseX || mouseY != this.lastMouseY) {
            this.mouseStationaryTime = System.currentTimeMillis();
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
        }
        RenderSystem.disableBlend();
    }

    private void drawMoveSkill(MatrixStack matrix, float wheelRadius, float rotation, MoveSkill moveSkill, boolean select) {
        float r = 0.6f * wheelRadius;
        int x = (int)((double)((float)this.field_230708_k_ / 2.0f) - (double)r * Math.cos((double)(rotation - 90.0f) * Math.PI / 180.0));
        int y = this.field_230709_l_ - (int)((double)((float)this.field_230709_l_ / 2.0f) - (double)r * Math.sin((double)(rotation - 90.0f) * Math.PI / 180.0));
        ScreenHelper.drawImageQuad(moveSkill.sprite, matrix, (float)x - wheelRadius / 6.0f, (float)y - wheelRadius / 6.0f, wheelRadius / 3.0f, wheelRadius / 3.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        if (select) {
            ScreenHelper.drawImageQuad(Resources.moveSkillSelect, matrix, (float)x - wheelRadius / 6.0f, (float)y - wheelRadius / 6.0f, wheelRadius / 3.0f, wheelRadius / 3.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        int clickedSpot = this.getIndexForPos((int)mouseX, (int)mouseY);
        if (clickedSpot == -1) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        } else {
            PixelmonOverlayScreen.selectedMoveSkill = this.moveSkills.get((int)clickedSpot).id;
            this.field_230706_i_.field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 1.0f, 1.0f);
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231177_au__() {
        return false;
    }
}

