/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npc;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.ClickableElement;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.TutorListScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.NPCTeachMovePacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.enums.EnumNPCTutorType;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TutorScreen
extends Screen
implements ClickableElement<NPCTutor.LearnableMove>,
INestedGuiEventHandler {
    public static List<NPCTutor.LearnableMove> moveList;
    NPCTutor tutor;
    int listTop;
    int listLeft;
    int listHeight;
    int listWidth;
    TutorListScreen attackListGui;
    Pokemon pokemon;

    public TutorScreen(Pokemon data, int npcId) {
        super(StringTextComponent.field_240750_d_);
        Optional<NPCTutor> entityNPCOptional = NPCEntity.locateNPCClient((World)Minecraft.func_71410_x().field_71441_e, npcId, NPCTutor.class);
        if (!entityNPCOptional.isPresent()) {
            ScreenHelper.closeScreen();
            return;
        }
        this.tutor = entityNPCOptional.get();
        this.pokemon = data;
        this.listHeight = 150;
        this.listWidth = 90;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        if (moveList.isEmpty()) {
            this.field_230706_i_.field_71439_g.func_71053_j();
            return;
        }
        this.listTop = this.field_230709_l_ / 2 - 62;
        this.listLeft = this.field_230708_k_ / 2 - 40;
        moveList.sort(Comparator.comparing(NPCTutor.LearnableMove::learnable).reversed());
        this.attackListGui = new TutorListScreen(this, moveList, this.listWidth, this.listHeight, this.listTop, this.listLeft, this.field_230706_i_);
        this.field_230705_e_.add(this.attackListGui);
        this.field_230710_m_.add(new IndexedButton(1, this.field_230708_k_ / 2 + 155, this.field_230709_l_ / 2 + 90, 50, 20, (ITextComponent)new TranslationTextComponent("gui.cancel.text"), this::actionPerformed));
        this.field_230705_e_.addAll(this.field_230710_m_);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float mFloat) {
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, (float)(0.05 * (double)this.field_230708_k_), (float)(0.05 * (double)this.field_230709_l_), (float)(0.9 * (double)this.field_230708_k_), (float)(0.9 * (double)this.field_230709_l_), 0.0f, 0.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.9f, 0.75f, 0.0f);
        RenderHelper.func_74518_a();
        boolean force = Minecraft.func_71410_x().func_211821_e();
        Minecraft.func_71410_x().func_238209_b_(true);
        String text = I18n.func_135052_a((String)(this.tutor.getTutorType() == EnumNPCTutorType.TRANSFER ? "pixelmon.npc.transfername" : "pixelmon.npc.tutorname"), (Object[])new Object[0]);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, text, (float)this.field_230708_k_ / 2.0f - (float)this.field_230712_o_.func_78256_a(text) / 2.0f, (float)this.field_230709_l_ / 2.0f - 110.0f, 0);
        text = I18n.func_135052_a((String)"gui.choosemoveset.choosemove", (Object[])new Object[0]);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, text, (float)this.field_230708_k_ / 2.0f - (float)this.field_230712_o_.func_78256_a(text) / 2.0f, (float)this.field_230709_l_ / 2.0f - 92.0f, 0);
        ScreenHelper.drawImageQuad(this.pokemon.getSprite(), matrix, (float)this.field_230708_k_ / 2.0f - 211.0f, (float)this.field_230709_l_ / 2.0f - 98.0f, 84.0f, 84.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        this.attackListGui.func_230430_a_(matrix, mouseX, mouseY, mFloat);
        ScreenHelper.drawAttackInfoBox(matrix, 0.0f, this.field_230708_k_, this.field_230709_l_);
        text = I18n.func_135052_a((String)"gui.choosemoveset.cost", (Object[])new Object[0]);
        int costTextWidth = this.field_230712_o_.func_78256_a(text);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, text, (float)this.field_230708_k_ / 2.0f + 125.0f - (float)costTextWidth, (float)this.field_230709_l_ / 2.0f + 60.0f, 0);
        for (int i = 0; i < moveList.size(); ++i) {
            NPCTutor.LearnableMove learnableMove = moveList.get(i);
            if (!this.attackListGui.isMouseOver(i, mouseX, mouseY)) continue;
            TutorScreen.drawAttackInfoList(matrix, learnableMove.attack(), this.field_230708_k_, this.field_230709_l_);
            List<ItemStack> costList = learnableMove.costs();
            if (costList != null && !costList.isEmpty()) {
                int j = 0;
                for (ItemStack item : costList) {
                    this.field_230707_j_.func_180450_b(item, this.field_230708_k_ / 2 + 125 + j * 20, this.field_230709_l_ / 2 + 55);
                    this.field_230707_j_.func_180453_a(this.field_230706_i_.field_71466_p, item, this.field_230708_k_ / 2 + 125 + j * 20, this.field_230709_l_ / 2 + 55, null);
                    ++j;
                }
            }
            text = this.pokemon.getMoveset().hasAttack(learnableMove.attack()) ? I18n.func_135052_a((String)"gui.tutor.already", (Object[])new Object[0]) : (learnableMove.learnable() ? I18n.func_135052_a((String)"gui.tutor.canlearn", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.tutor.cantlearn", (Object[])new Object[0]));
            this.field_230706_i_.field_71466_p.func_238421_b_(matrix, text, (float)this.field_230708_k_ / 2.0f + 125.0f - (float)costTextWidth, (float)this.field_230709_l_ / 2.0f + 75.0f, 0);
        }
        super.func_230430_a_(matrix, mouseX, mouseY, mFloat);
        Minecraft.func_71410_x().func_238209_b_(force);
    }

    @Override
    public void elementClicked(List<NPCTutor.LearnableMove> list, int index) {
        NPCTutor.LearnableMove learnableMove = moveList.get(index);
        if (learnableMove.learnable() && !this.pokemon.getMoveset().hasAttack(learnableMove.attack())) {
            ScreenHelper.closeScreen();
            NetworkHelper.sendToServer(new NPCTeachMovePacket(this.pokemon.getUUID(), learnableMove.attack().getAttackName(), this.tutor.func_145782_y()));
        }
    }

    protected void actionPerformed(Button button) {
        if (button instanceof IndexedButton && ((IndexedButton)button).id == 1) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    public static void drawAttackInfoList(MatrixStack matrix, ImmutableAttack a, int width, int height) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int y = height / 2 - 85;
        int x = width / 2 + 105;
        String powerString = I18n.func_135052_a((String)"gui.choosemoveset.power", (Object[])new Object[0]) + ": ";
        powerString = a.getBasePower() > 0 ? powerString + a.getBasePower() : powerString + "--";
        fontRenderer.func_238421_b_(matrix, powerString, (float)x, (float)(y + 3), 0);
        String accuracyString = I18n.func_135052_a((String)"gui.battle.accuracy", (Object[])new Object[0]) + ": ";
        accuracyString = a.getAccuracy() > 0 ? accuracyString + a.getAccuracy() : accuracyString + "--";
        fontRenderer.func_238421_b_(matrix, accuracyString, (float)x, (float)(y + 13), 0);
        fontRenderer.func_238421_b_(matrix, I18n.func_135052_a((String)"nbt.pp", (Object[])new Object[0]) + " " + a.getPPBase() + "/" + a.getPPBase(), (float)x, (float)(y + 23), 0);
        String typeString = I18n.func_135052_a((String)"gui.battle.type", (Object[])new Object[0]) + " ";
        fontRenderer.func_238421_b_(matrix, typeString, (float)x, (float)(y + 33), 0);
        fontRenderer.func_238421_b_(matrix, a.getAttackType().getLocalizedName(), (float)(x + fontRenderer.func_78256_a(typeString)), (float)(y + 33), a.getAttackType().getColor());
        String category = a.getAttackCategory().getLocalizedName();
        fontRenderer.func_238421_b_(matrix, category, (float)x, (float)(y + 43), 0);
        ScreenHelper.drawSplitString(matrix, I18n.func_135052_a((String)a.getDescriptionKey(), (Object[])new Object[0]), x, y + 58, 95, 0);
    }
}

