/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npcEditor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.EnumNPCServerPacketType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.NPCServerPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryTrainers;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.StringTextComponent;

class TextureEditorNPC {
    private DropDownScreen gui;
    private NPCEntity npc;
    private BaseTrainer model;
    private int x;
    private int y;
    private int width;
    private int yOffset;
    public TextFieldWidget customTextureBox;
    private DropDown<String> modelTextureDropDown;
    private boolean customFocus = false;

    TextureEditorNPC(DropDownScreen gui, NPCEntity npc, int x, int y, int width) {
        this(gui, npc, x, y, width, 0);
    }

    TextureEditorNPC(DropDownScreen gui, NPCEntity npc, int x, int y, int width, int yOffset) {
        this.gui = gui;
        this.npc = npc;
        this.model = npc.getBaseTrainer();
        this.x = x;
        this.y = y;
        this.width = width;
        this.yOffset = yOffset;
        gui.addDropDown(new DropDown<BaseTrainer>(ServerNPCRegistry.trainers.getTypes(), this.model, x, y + yOffset, width, 92).setGetOptionString(trainer -> I18n.func_135052_a((String)("trainer." + trainer.name), (Object[])new Object[0])).setOnSelected(this::selectTrainerType).setInactiveTop(y).setOrdered());
        if (this.model != null && this.model.textures.size() > 1) {
            this.displayTextureMenu();
        }
        this.customTextureBox = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, x, y + 38, width, 20, StringTextComponent.field_240750_d_);
        String tex = this.npc.getCustomSteveTexture();
        this.customTextureBox.func_146180_a(tex.contains(";") ? tex.split(";")[0] : tex);
    }

    private void displayTextureMenu() {
        int modelDistance = 16;
        this.modelTextureDropDown = new DropDown<int>((List<int>)this.model.textures, this.npc.getTextureIndex(), this.x, this.y + Math.max(this.yOffset, (this.model.textures.size() - 1) * -10) + modelDistance, this.width, 70).setGetOptionString(texture -> I18n.func_135052_a((String)("trainer.model." + texture), (Object[])new Object[0])).setOnSelectedIndex(this::selectTexture).setInactiveTop(this.y + modelDistance);
        this.gui.addDropDown(this.modelTextureDropDown);
    }

    private void selectTrainerType(BaseTrainer model) {
        this.model = model;
        this.npc.setBaseTrainer(model);
        NetworkHelper.sendToServer(new NPCServerPacket(this.npc.getNPCID(), this.model.id));
        this.npc.setTextureIndex(0);
        this.gui.removeDropDown(this.modelTextureDropDown);
        if (this.model.textures.size() > 1) {
            this.npc.setNickName("Steve");
            this.displayTextureMenu();
        }
    }

    private void selectTexture(int textureIndex) {
        if (!this.model.textures.isEmpty()) {
            NetworkHelper.sendToServer(new NPCServerPacket(this.npc.getNPCID(), EnumNPCServerPacketType.TextureIndex, textureIndex));
        }
    }

    void drawCustomTextBox(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.isCustomTexture()) {
            this.customTextureBox.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
            this.customTextureBox.func_146189_e(true);
        } else {
            this.customTextureBox.func_146189_e(false);
        }
    }

    void keyTyped(char key, int keyCode, TextFieldWidget ... otherFields) {
        if (this.customFocus && !this.customTextureBox.func_230999_j_()) {
            this.saveCustomTexture();
        }
        this.customFocus = this.customTextureBox.func_230999_j_();
        this.customTextureBox.func_231042_a_(key, keyCode);
        if (this.customTextureBox.func_146176_q()) {
            ArrayList<TextFieldWidget> fields = new ArrayList<TextFieldWidget>(Arrays.asList(otherFields));
            fields.add(this.customTextureBox);
            ScreenHelper.switchFocus(keyCode, fields);
        } else {
            ScreenHelper.switchFocus(keyCode, otherFields);
        }
        this.customTextureBox.func_231046_a_((int)key, keyCode, 0);
    }

    void mouseClicked(double x, double y, int mouseButton) {
        this.customTextureBox.func_231044_a_(x, y, mouseButton);
        if (this.customFocus && !this.customTextureBox.func_230999_j_()) {
            this.saveCustomTexture();
        }
        this.customFocus = this.customTextureBox.func_230999_j_();
    }

    void saveCustomTexture() {
        if (this.isCustomTexture() && !this.customTextureBox.func_146179_b().equals(this.npc.getCustomSteveTexture().split(";")[0])) {
            NetworkHelper.sendToServer(new NPCServerPacket(this.npc.getNPCID(), EnumNPCServerPacketType.CustomSteveTexture, this.customTextureBox.func_146179_b()));
        }
    }

    private boolean isCustomTexture() {
        if (this.model != null && (this.model == NPCRegistryTrainers.Steve || this.model.name.equals("Steve"))) {
            String texture = this.model.textures.get(this.npc.getTextureIndex());
            return texture.equals("Custom_RP") || texture.equals("Custom_PN");
        }
        return false;
    }
}

